/***************************************************************************
                          kdlgtransfer.h  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.7 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KDLGTRANSFER_H
#define KDLGTRANSFER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kdialogbase.h>
#include "ktransfer.h"

class KDlgTransferSet;
class KDlgTransfer1;
#ifdef ENABLE_WGET
class KDlgTransferWget1;
#endif
#ifdef ENABLE_KIO
class KDlgTransferKio1;
#endif

/**
 * @short Dialog to configure @ref KTransfer objects.
 * 
 * @author Sergio Moretti
 *
 * @version $Id: kdlgtransfer.h,v 1.7 2001/03/05 20:59:22 sergio Exp $
 */

class KDlgTransfer : public KDialogBase 
{
   Q_OBJECT
	   
public:
   KDlgTransfer(KTransfer t, QWidget *parent, const char *name=0);
   ~KDlgTransfer();
  
protected slots: // Protected slots
   void slotOk();
   void slotApply();
   void slotCancel();

protected: // Protected methods
   void initDialog();

private:
   KTransfer _t;
   KDlgTransferSet *_ps;
   KDlgTransfer1 *_p1;
#ifdef ENABLE_WGET
   KDlgTransferWget1 *_p2w;
#endif
#ifdef ENABLE_KIO
   KDlgTransferKio1 *_p3k;
#endif
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
