/***************************************************************************
                          kdlgapp.h  -  description
                             -------------------
    begin                : Fri Sep 15 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.18 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KDLGAPP_H
#define KDLGAPP_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <ktabctl.h>
#include <qwidget.h>
#include <qgroupbox.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>

#ifdef DMALLOC
#include <dmalloc.h>
#endif

class KMagoDoc;

/**
 * @short Dialog class for @ref KMagoApp configuration
 *
 * @author Sergio Moretti
 *
 * @version $Id: kdlgapp.h,v 1.18 2001/04/04 18:06:04 sergio Exp $
 */

class KDlgApp : public KTabCtl
{
   Q_OBJECT
public:
   KDlgApp(KMagoDoc *doc, QWidget *parent, const char *name=0);
   ~KDlgApp();
   bool isAcceptable();

protected:
   void initDialog();
   void init();
   /** get the start mode */
   int getStartMode();
   KMagoDoc * doc() const;

public slots:
   void accept();
   void reject();

protected:
   QLineEdit *lneCmdOnIdle;
   QCheckBox *cbtTrayProgress;
   QCheckBox *cbtAutoProgress;
   QCheckBox *cbtNotify;
   QCheckBox *cbtLoadLast;
   QCheckBox *cbtAEFile;
   QCheckBox *cbtNoPrompt;
   QCheckBox *cbtFEFile;
   QLineEdit *lneUpdateInt;
   QLineEdit *lneSaveInt;
   QLineEdit *lneTStart;
   QCheckBox *cbtExpert;
   QRadioButton *rbtStart0;
   QRadioButton *rbtStart1;
   QRadioButton *rbtStart2;
   QCheckBox *cbtListOnDrop;

private:
   KMagoDoc * _doc;
};

#endif

/* Local Variables: */
/* mode: c++ */
/* End: */
