/***************************************************************************
                          kobjectimpl.cpp  -  description
                             -------------------
    begin                : Mon Oct 16 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.14 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kdebug.h>
#include <klocale.h>
#include <qtextstream.h>
#include <kapp.h>
#include <qdatetime.h>
#include "kfactoryimpl.h"
#include "kobjectimpl.h"
#include "kcontainerimpl.h"
#include "krootcontainerimpl.h"

const char KObjectImpl::DOCID[] = "Object";
const char KObjectImpl::DOCTYPE[] = "<!DOCTYPE Object >";

KObjectImpl::KObjectImpl(int type) 
   : QObject(), _root(0), _container(0), _id(0), _global(0), 
     _cfg_global(false), _type(type), _modState(MDI_NUM), _priority(-1) 
{
   resetBits(_modState);
}

KObjectImpl::~KObjectImpl() 
{
   kdDebug(D_INI) << name() << ": destroy" << endl;
   //kdFatal(isModified(MOD_ALL)) << name() << ": destroy modified " << _modified << endl;
   //kdWarning(isMods(ANYMOD)) << name() << ": destroy modified" << endl;
   kdFatal(isRunning()) << name() << ": destroy running" << endl;
   dom().clear();
}

int KObjectImpl::cmpPriority(const KObjectImpl *obj) const 
{
   // root can't be compared
   kdFatal(isRoot() || obj->isRoot()) << name() << ": cmpPriority with root" << endl;
   int p1 = prioritySum();
   int p2 = obj->prioritySum();
   if ( p1 != p2 )
      return p1 > p2 ? 1 : -1;
   // if p1 == p2
   switch (container()->getPriorityPolicy()) 
   {
   case PRI_FIFO:
      return cmpPriorityFifo(obj);
   case PRI_LIFO:
      return cmpPriorityLifo(obj);
   case PRI_SHORT:
      return cmpPriorityShort(obj);
   case PRI_LONG:
      return cmpPriorityLong(obj);
   default:
      kdFatal(D_RUN) << name() << ": priority policy unknown " << container()->getPriorityPolicy() << endl;
   }
   return 0;
}

int KObjectImpl::cmpPriorityFifo(const KObjectImpl *obj) const
{
   return ( id() > obj->id() ? -1 : 1);
}

int KObjectImpl::cmpPriorityLifo(const KObjectImpl *obj) const
{
   return ( id() < obj->id() ? -1 : 1);
}

int KObjectImpl::cmpPriorityShort(const KObjectImpl *) const
{
   return 0;
}

int KObjectImpl::cmpPriorityLong(const KObjectImpl *) const
{
   return 0;
}

void KObjectImpl::emitMod() 
{
   if (isMods(ANYMOD)) // && obj == 0 && !isRoot()) 
   {
      //kdDebug(D_RUN) << name() << ": modified = " << QString("%1").arg(_modState, 0, 16) << " prop = " << QString("%1").arg(prop, 0, 16) << endl;
      root()->signalMod(this);
   }
}

bool KObjectImpl::isRoot() const
{
   return root() == this; 
}

void KObjectImpl::load(KContainerImpl *cont, const QDomElement &e) 
{
   kdDebug(D_INI) << e.attribute("Name") << ": load" << endl;
   if (e.tagName() != docId()
       || !e.hasAttribute("Version")
       || !e.hasAttribute("Id")
       || !e.hasAttribute("Name")
       || !e.hasAttribute("Type")) 
   {
      /* throw */
      new DomError(name(), i18n("load: malformed document"), e);
      //kdFatal(D_INI) << "MALFORMED DOM:" << e.ownerDocument().toString() << endl;
   }
   _container = cont;
   _root = (cont != 0 ? cont->root() : dynamic_cast<KRootContainerImpl*>(this));
   _dom = e;
   _id = e.attribute("Id").toInt();
   setName(e.attribute("Name"));
   _global = (_container != 0 && isNormal()) ?
      _container->findGlobal(e.attribute("Type").toInt()) : 0;
   loadData();
   checkState();
   kdDebug(D_INI) << name() << ": Object loaded" << endl;
   //<< dom().ownerDocument().toString() << "END DOM" << endl;
}

void KObjectImpl::loadData() 
{
   kdDebug(D_INI) << name() << ": Object loaddata" << endl;
   if (!dom().hasAttribute("GlobalCfg"))
   {
      dom().setAttribute("GlobalCfg", !isGlobal());
   }
   if (!dom().hasAttribute("Priority"))
   {
      dom().setAttribute("Priority", 0);
   }
   _cfg_global = dom().attribute("GlobalCfg", 
				 QString::number(!isGlobal())).toInt();
   _priority = dom().attribute("Priority", QString::number(0)).toInt();
}

int KObjectImpl::prioritySum() const 
{ 
   return priority() + (isRoot() ? 0 : container()->prioritySum());
}

void KObjectImpl::runPeriodically() 
{
   // refresh the object view
   emitMod();
}

void KObjectImpl::setGlobal(bool g) 
{ 
   if (_cfg_global != g) 
   {
      _cfg_global = g; 
      dom().setAttribute("GlobalCfg", _cfg_global);
      setMod(MDI_GLOBAL); 
      root()->setModified();
   } 
}

void KObjectImpl::setPriority(int p) 
{ 
   if (_priority != p)
   {
      _priority = p;
      dom().setAttribute("Priority", _priority);
      setMod(MDI_PRIORITY); 
      root()->setModified();
   }
   
}

void KObjectImpl::setMessage(const QString &msg) 
{ 
   // temp data
   if (_msg != msg)
   {
      _msg = msg; 
      setMod(MDI_MESSAGE);
      root()->setModified();
   }
}

void KObjectImpl::setFatalError(bool v)
{
   if (_fatalError != v)
   {
      _fatalError = v;
      setMod(MDI_FATAL);
      root()->setModified();
   }
}

QDomDocument KObjectImpl::toDom() const 
{
   QDomDocument doc(DOC);
   QByteArray data;
   QTextStream s(data, IO_WriteOnly);
   // FIXME!!
   s << "<?xml version = '1.0'?><!DOCTYPE " << DOC << " >";
   dom().save(s, 0);
   if (!doc.setContent(data))
      //kdFatal(D_RUN) << name() << " ERROR IN DOM GENERATION:\n" << (const char*)data << endl;
      /* throw */
      new DomError(name(), i18n("error in dom generation"), doc);
   return doc;
}

QString KObjectImpl::typeStr() const 
{
   return KFactoryImpl::factory()->typeStr(type());
}

void KObjectImpl::waitForKill() 
{
   QTime timeout;
   timeout.start();
   while (isRunning() && timeout.elapsed() < 5000)
      kapp->processEvents();

   kdFatal(isRunning(), D_RUN) << name() << ": unable to complete kill op" << endl;
}   

bool KObjectImpl::isMod(ModIndex p) const
{
   return getBit(p, _modState);
}

bool KObjectImpl::isMods(const ModFlags &f) const
{
   return mapBits(f, _modState);
}

void KObjectImpl::setMod(ModIndex p) 
{ 
   setBit(p, _modState);
   /*
   if (!isRoot())
      if (!container()->isMod(MDI_CHILD))
	 container()->setMod(MDI_CHILD);
   */
}

void KObjectImpl::setMods(const ModFlags &f) 
{ 
   orBits(f, _modState);
   /*
   if (!isRoot())
      if (!container()->isMod(MDI_CHILD))
	 container()->setMod(MDI_CHILD);
   */
}

void KObjectImpl::resetMods()
{
   resetBits(_modState);
}

#include "kobjectimpl.moc"
