/***************************************************************************
                          kmago.h  -  description
                             -------------------
    begin                : Mon Sep 18 2000
    copyright            : (C) 2000 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.36 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMAGO_H
#define KMAGO_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for KDE
#include <kapp.h>
#include <kmainwindow.h>
#include <qintdict.h>
#include <qtimer.h>
//#include <kaccel.h>
#include <kaction.h>
#include <qstringlist.h>
#include "ktransfer.h"
#include "ktmanager.h"
#include "kmmanager.h"

#ifdef DMALLOC
#include <dmalloc.h>
#endif

// forward declaration of the KMago classes
class KMagoDoc;
class KMagoView;
//class KTManagerView;
class KSysTrayView;
class KDropper;

/**
 * @short Base class for KMago application windows.
 *
 * @author Sergio Moretti
 *
 * @version $Id: kmago.h,v 1.36 2001/04/04 18:06:04 sergio Exp $
 *
 * The base class for KMago application windows. It sets up the main
 * window and reads the config file as well as providing a menubar, toolbar
 * and statusbar. An instance of KMagoView creates your center view, which is connected
 * to the window's Doc object.
 * @see KMainWindow
 * @see KApplication
 * @see KConfig
 * @see KAccel
 */

class KMagoApp : public KMainWindow
{
   Q_OBJECT

   friend class KMagoDoc;

   static const char IDS_STATUS_DEFAULT[];

public:
   /**
    * construtor of KMagoApp, calls all init functions to create the application.
    * @see initMenuBar initToolBar
    */
   KMagoApp(bool restored = false);
   ~KMagoApp();

   /**
    * returns a pointer to the current document connected to the KMainWindow
    * instance and is used by the View class to access the document object's
    * methods
    */
   KMagoDoc *doc() const { return _doc; }
   KSysTrayView *sysTray() const { return _sysTray; }
   KMagoView *view() const { return _view; }
   KDropper *dropper() const { return _dropper; }
   //KMManager mainManager() const;

   void setDownloadLock(bool v);
   void setExitOnIdle(bool v);
   void setExecuteOnIdle(bool v);

   void updateCaption();
   void updateStatusBarCount();
   void updateStatusBarBand();
   void updateToolTip();
   void updateManagerList();
   void updateTransferMenu();
   void updateManagerMenu();

   QSize sizeHint() const;
   //virtual void resizeEvent ( QResizeEvent *event );

   // configuration

protected:
   /** initActions creates the actions for menus and toolbars */
   void initActions();
   /** sets up the statusbar for the main window by initialzing a statuslabel. */
   void initStatusBar();
   /**
    * initializes the document object of the main window that is connected to
    * the view in initView().
    * @see initView();
    */
   void initDocument();
   /**
    * creates the centerwidget of the KTMainWindow instance and sets it as the
    * view
    */
   void initView();
   /** create the system tray widget */
   void initSysTray();
   /**
    * queryClose is called by KTMainWindow on each closeEvent of a window.
    * Against the default implementation (only returns true), this calles
    * saveModified() on the document object to ask if the document shall
    * be saved if Modified; on cancel the closeEvent is rejected.
    * @see KMainWindow#queryClose
    * @see KMainWindow#closeEvent
    */
   virtual bool queryClose();
   /**
    * queryExit is called by KTMainWindow when the last window of the
    * application is going to be closed during the closeEvent().
    * Against the default implementation that just returns true, this calls
    * saveOptions() to save the settings of the last window's properties.
    * @see KMainWindow#queryExit
    * @see KMainWindow#closeEvent
    */
   virtual bool queryExit();

   /** read and apply main window settings */
   void  applySettings(KConfig *config, bool fromSession);
   /** save main window settings */
   void  saveSettings(KConfig *config, bool toSession);

   /**
    * saves the window properties for each open window during session end to
    * the session config file, including saving the currently
    * opened file by a temporary filename provided by KApplication.
    * @see KMainWindow#saveProperties
    */
   virtual void saveProperties(KConfig *config);
   /**
    * reads the session config file and restores the application's state
    * including the last opened files and documents by reading the
    * temporary files saved by saveProperties()
    * @see KMainWindow#readProperties
    */
   virtual void readProperties(KConfig *config);

   /** open transfer progress window */
   void openTransferProgress(KTransfer t);
   /** close all windows related to transfer */
   void closeTransferWindows(KTransfer t);

   virtual void resizeEvent(QResizeEvent *);

protected slots:
   /** open a new application window by creating a new instance of KMagoApp */
   void slotFileNewWindow();
   /** clears the document in the actual view to reuse it as the new document */
   void slotFileNew();
   /** open a file and load it into the document*/
   void slotFileOpen();
   /** opens a file from the recent files menu */
   void slotFileOpenRecent(const KURL &url);
   /** save a document by a new filename */
   void slotFileSaveAs();
   /**
    * asks for saving if the file is modified, then closes the actual file
    * and window
    */
   void slotFileClose();
   /** save a document */
   void slotFileQuit();
   /** select current manager */
   void slotFileSelectMngr(int i);
   /** add a manager */
   void slotFileAddMngr();
   /** automatic download locking */
   void slotFileDownloadLock();

   /**
    * put the marked text/object into the clipboard and remove it from
    * the document
    */
   void slotEditCut();
   /** put the marked text/object into the clipboard */
   void slotEditCopy();
   /** paste the clipboard into the document */
   void slotEditPaste();
   /** unselect the current transfer */
   void slotEditUnselectTransfer();

   /** add a new transfer to the transfers list */
   void slotManagerAdd();
   /** add a transfer from the recent transfers list */
   void slotManagerAddRecent(const KURL& u);
   /** enable/disable auto-downloading mode */
   void slotManagerAutoDownload();
   /** open the document configure dialog */
   void slotManagerConfigure();
   /** stop all transfers */
   void slotManagerKillAll();
   /** remove a manager */
   void slotManagerRemoveMngr();
   /** clear manager */
   void slotManagerClear();
   /** refresh manager view */
   void slotManagerRefresh(KTManager m);
   /** set manager's priority */
   void slotManagerSetPriority(int index);
   /** increase manager priority by 1 */
   void slotManagerIncrPriority();
   /** decrease manager priority by 1 */
   void slotManagerDecrPriority();
   void slotManagerCut();
   void slotManagerCopy();
   /** add a new transfer from pasting */
   void slotManagerPaste();
   /** enable/disable exiting on idle */
   void slotManagerExitOnIdle();
   /** kill all active transfers */
   void slotKillAll();
   /** enable/disable execute command on first idle state */
   void slotExecuteOnIdle();

   /** start/resume transfer*/
   void slotTransferStartStop();
   /** remove transfer*/
   void slotTransferRemove();
   /** open dialog to view the transfer cmd output */
   void slotTransferLog();
   /** open the current transfer configure dialog */
   void slotTransferConfigure();
   /** enable/disable auto resuming */
   void slotTransferAutoResume();
   /** enable/disable auto check resume */
   void slotTransferAutoCheck();
   /** check for transfer resume capability */
   void slotTransferCheck();
   /** open the transfer status dialog */
   void slotTransferStatus();
   /** clear transfer */
   void slotTransferClear();
   /** set transfer priority */
   void slotTransferSetPriority(int index);
   /** set transfer resume state */
   void slotTransferSetResumeState(int index);
   /** reset transfer resumed number */
   void slotTransferSetResumed();
   /** increase transfer priority by 1 */
   void slotTransferIncrPriority();
   /** decrease transfer priority by 1 */
   void slotTransferDecrPriority();
   /** reset transfer state */
   void slotTransferSetState();
   void slotTransferCut();
   void slotTransferCopy();
   void slotTransferProgress();

   /** toggles the main toolbar*/
   void slotViewToolBarMain();
   /** toggles the managers toolbar*/
   void slotViewToolBarMng();
   /** toggles the transfers toolbar*/
   void slotViewToolBarTrn();
   /** toggles the statusbar*/
   void slotViewStatusBar();
   /** refresh the views */
   void slotViewRefresh();
   /** open the application preferences dialog */
   void slotViewPreferences();
   /** show/hide managers list */
   void slotViewManagers();
   /** show/hide system tray icon */
   void slotViewSysTray();
   /** show/hide the dropper window */
   void slotViewDropper();
   void slotDropperClose();
   /** open edit keybindings dialog */
   void slotEditKeys();
   /** open edit toolbar dialog */
   void slotEditToolbars();
   /** save options */
   void slotSaveOptions();

   /**
    * changes the statusbar contents for the standard label permanently, used
    * to indicate current actions.
    * @param text the text that is displayed in the statusbar
    */
   void slotStatusMsg(const QString &text);
   /**
    * changes the status message of the whole statusbar for two seconds, then
    * restores the last status. This is used to display
    * statusbar messages that give information about actions for toolbar icons
    * and menuentries.
    * @param text the text that is displayed in the statusbar
    */
   void slotStatusHelpMsg(const QString &text);

   /** called when clipboard data change */
   void slotClipboardChange();

protected slots:
   void slotWndStatusClosed(int id);
   void slotWndLogClosed(int id);
   void slotWndProgressClosed(int id);

private:
   /**
    * view is the main widget which represents your working area. The View
    * class should handle all events of the view widget.  It is kept empty so
    * you can create your view according to your application's needs by
    * changing the view class.
    */
   KMagoView *_view;
   /** system tray widget */
   KSysTrayView *_sysTray;
   /** dropper window */
   KDropper *_dropper;
   /**
    * doc represents your actual document and is created only once. It keeps
    * information such as filename and does the serialization of your files.
    */
   KMagoDoc *_doc;
   /** dictionary id/window of open log windows */
   QIntDict<QWidget> _logWnds;
   /** dictionary id/window of open status windows */
   QIntDict<QWidget> _statusWnds;
   /** dictionary id/window of open progress windows */
   QIntDict<QWidget> _progressWnds;

   // actions
   KAction
      *fileNewWindow,
      *fileNew,
      *fileOpen,
      *fileClose,
      *fileSaveAs,
      *fileQuit,
      *fileAddMngr,
      *fileDocConf,
      *editCopy,
      *editCut,
      *editPaste,
      *editUnselectTransfer,
      *managerAdd,
      *managerConf,
      *managerKillAll,
      *managerRemoveMngr,
      *managerClear,
      *managerSetIncrPriority,
      *managerSetDecrPriority,
      *managerCut,
      *managerCopy,
      *managerPaste,
      *killAll,
      *transferCheck,
      *transferConf,
      *transferRemove,
      *transferStartStop,
      *transferStatus,
      *transferLog,
      *transferClear,
      *transferSetResumed,
      *transferSetIncrPriority,
      *transferSetDecrPriority,
      *transferSetState,
      *transferCut,
      *transferCopy,
      *transferProgress,
      *viewRefresh,
      *viewPrefs,
      *separator;
   KRecentFilesAction
      *fileOpenRecent,
      *managerAddRecent;
   KToggleAction
      *fileDownloadLock,
      *managerAutoDownload,
      *managerExitOnIdle,
      *executeOnIdle,
      *transferAutoCheck,
      *transferAutoResume,
      *viewStatusBar,
      *viewToolBarMain,
      *viewToolBarMng,
      *viewToolBarTrn,
      *viewManagers,
      *viewSysTray,
      *viewDropper;
   KListAction
      *fileSelectMngr,
      *managerSetPriority,
      *transferSetPriority,
      *transferSetRsmState;

   int _statusMsgWidth;
};

#endif // KMAGO_H

/* Local Variables: */
/* mode: c++ */
/* End: */
