/***************************************************************************
                           kdlgtransferset.cpp - 
                         ---------------------------
    begin                : Sun Mar  4 2001
    copyright            : (C) 2001 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.1 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlabel.h>
#include <qtooltip.h>
#include <qlayout.h>
#include <qhbox.h>
#include <qgroupbox.h>
#include <klocale.h>
#include <kfiledialog.h>
#include "kdlgtransferset.h"

KDlgTransferSet::KDlgTransferSet(KTransfer tr, QWidget *parent, const char *name)
   : QWidget(parent, name), t(tr)
{
   initDialog();
   init();
}

KDlgTransferSet::~KDlgTransferSet()
{
}

void KDlgTransferSet::initDialog()
{
   QBoxLayout *l = new QVBoxLayout(this, 8);

   QGroupBox *gbox = new QGroupBox(1, Horizontal, i18n("Url & File"),
				   this);
   l->addWidget(gbox);

   new QLabel(i18n("Url"), gbox);
   lneRemote = new QLineEdit(gbox, "LneRemote");
   QToolTip::add(lneRemote, i18n("Url to download"));

   new QLabel(i18n("File"), gbox);
#ifndef KURLREQ_ERR
   cmbLocal = new KURLRequester(gbox, "CmbLocal");
#ifdef KDE_VERSION_POST_1207
   connect(cmbLocal, SIGNAL(openFileDialog(KURLRequester *)),
	   SLOT(slotOpenFileDialog(KURLRequester *)));
#else
   KFile::Mode mode = static_cast<KFile::Mode>(KFile::LocalOnly);
   cmbLocal->fileDialog()->setMode(mode);
   //cmbLocal->fileDialog()->setKeepLocation(true);
#endif
   QToolTip::add(cmbLocal, i18n("File to write"));
#else
   lneLocal = new QLineEdit(gbox, "LneLocal");
   QToolTip::add(lneLocal, i18n("File to write"));
#endif

   new QLabel(i18n("Temporary File"), gbox);
#ifndef KURLREQ_ERR
   cmbTmp = new KURLRequester(gbox, "CmbTmp");
#ifdef KDE_VERSION_POST_1207
   connect(cmbTmp, SIGNAL(openFileDialog(KURLRequester *)),
	   SLOT(slotOpenFileDialog(KURLRequester *)));
#else
   mode = static_cast<KFile::Mode>(KFile::LocalOnly);
   cmbLocal->fileDialog()->setMode(mode);
   //cmbLocal->fileDialog()->setKeepLocation(true);
#endif
   QToolTip::add(cmbTmp, i18n("Temporary file"));
#else
   lneTmp = new QLineEdit(gbox, "LneTmp");
   QToolTip::add(lneTmp, i18n("Temporary file"));
#endif

   gbox = new QGroupBox(1, Horizontal, i18n("State"),
			this);
   l->addWidget(gbox);

   QHBox * box = new QHBox(gbox);
   QLabel *lbl = new QLabel(i18n("Length:"), box);
   lbl->setAlignment(AlignLeft | AlignVCenter);
   lneLen = new QLineEdit(box, "LblLen");
   lneLen->setFixedWidth(lneLen->fontMetrics().width("XXXXXXXXX"));
   lneLen->setAlignment(AlignRight | AlignVCenter);
   QToolTip::add(lneLen, i18n("Size of file"));
   box->setStretchFactor(lbl, 5);
   box->setStretchFactor(lneLen, 1);

   box = new QHBox(gbox);
   lbl = new QLabel(i18n("Resumable:"), box);
   lbl->setAlignment(AlignLeft | AlignVCenter);
   cmbResumable = new KComboBox(box, "CmbResumable");
   cmbResumable->insertItem(i18n("Unknown"));
   cmbResumable->insertItem(i18n("Checking"));
   cmbResumable->insertItem(i18n("Check fail"));
   cmbResumable->insertItem(i18n("Yes"));
   cmbResumable->insertItem(i18n("No"));
   box->setStretchFactor(lbl, 5);
   box->setStretchFactor(cmbResumable, 1);
   
   box = new QHBox(gbox);
   lbl = new QLabel(i18n("Resumed:"), box);
   lbl->setAlignment(AlignLeft | AlignVCenter);
   lneResumed = new QLineEdit(box, "LneResumed");
   lneResumed->setFixedWidth(lneResumed->fontMetrics().width("XXXXX"));
   lneResumed->setAlignment(AlignRight | AlignVCenter);
   box->setStretchFactor(lbl, 5);
   box->setStretchFactor(lneResumed, 1);

   box = new QHBox(gbox);
   lbl = new QLabel(i18n("Priority:"), box, "LblPriority");
   lbl->setAlignment(AlignLeft | AlignVCenter);
   lnePriority = new QLineEdit(box, "LnePriority");
   lnePriority->setFixedWidth(lnePriority->fontMetrics().width("XXXXX"));
   lnePriority->setAlignment(AlignRight | AlignVCenter);
   box->setStretchFactor(lbl, 5);
   box->setStretchFactor(lnePriority, 1);
}

void KDlgTransferSet::init() 
{
   lneRemote->setText(t.remote().url());
   lnePriority->setText(QString::number(t.priority()));
   lneLen->setText(QString::number(t.len()));
   lneResumed->setText(QString::number(t.resumed()));
   cmbResumable->setCurrentItem(t.rsmState());
#ifndef KURLREQ_ERR
   cmbLocal->setURL(t.local().path());
   cmbTmp->setURL(t.tmp().path());
#else
   lneLocal->setText(t.local().path());
   lneTmp->setText(t.tmp().path());
#endif
}

bool KDlgTransferSet::isAcceptable()
{
   bool check;
   QString(lneResumed->text()).toInt(&check);
   if (!check)
      return false;
   QString(lneLen->text()).toInt(&check);
   if (!check)
      return false;
   lnePriority->text().toInt(&check);
   return check;
}

void KDlgTransferSet::accept() 
{ 
   if (!isAcceptable())
      return;
   t.setRemote(lneRemote->text());
#ifndef KURLREQ_ERR
   t.setLocal(cmbLocal->url());
   t.setTmp(cmbTmp->url());
#else
   t.setLocal(lneLocal->text());
   t.setTmp(lneTmp->text());
#endif   
   t.setLen(lneLen->text().toInt());
   t.setPriority(QString(lnePriority->text()).toInt());
   t.setResumed(QString(lneResumed->text()).toInt());
   t.setRsmState((KM::RsmState)cmbResumable->currentItem());
}

void KDlgTransferSet::reject()
{
}

#ifdef KDE_VERSION_POST_1207
void KDlgTransferSet::slotOpenFileDialog(KURLRequester *kreq)
{
   KFile::Mode mode;
   mode = static_cast<KFile::Mode>(KFile::File | KFile::LocalOnly);
   kreq->fileDialog()->setMode(mode);
   //kreq->fileDialog()->setKeepLocation(true);
}
#endif   

#include "kdlgtransferset.moc"

/* Local Variables: */
/* mode: c++ */
/* End: */
