/***************************************************************************
                           kdlgmanagerset.cpp - 
                         ---------------------------
    begin                : Fri Mar  2 2001
    copyright            : (C) 2001 by Sergio Moretti
    email                : sermore@libero.it
    revision             : $Revision: 1.1 $
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlabel.h>
#include <qtooltip.h>
#include <qlayout.h>
#include <qhbox.h>
#include <qgroupbox.h>
#include <klocale.h>
#include "kdlgmanagerset.h"

KDlgManagerSet::KDlgManagerSet(KTManager mngr, QWidget *parent, const char *name)
   : QWidget(parent, name), m(mngr)
{
   initDialog();
   lneTitle->setText(m.title());
   lnePriority->setText(QString::number(m.priority()));
}

KDlgManagerSet::~KDlgManagerSet()
{
}

void KDlgManagerSet::initDialog()
{
   QBoxLayout *l = new QVBoxLayout(this, 8);

   QGroupBox *gbox = new QGroupBox(1, Horizontal, this);
   l->addWidget(gbox);

   new QLabel(i18n("Manager Title"), gbox, "LblTitle");
   lneTitle = new QLineEdit(gbox, "LneTitle");
   
   QHBox * box = new QHBox(gbox);
   QLabel *lbl = new QLabel(i18n("Priority"), box, "LblPriority");
   lnePriority = new QLineEdit(box, "LnePriority");
   lnePriority->setFixedWidth(lnePriority->fontMetrics().width("XXXXX"));
   box->setStretchFactor(lbl, 5);
   box->setStretchFactor(lnePriority, 1);
}

bool KDlgManagerSet::isAcceptable()
{
   bool check;
   lnePriority->text().toInt(&check);
   return !lneTitle->text().isEmpty() && check;
}

void KDlgManagerSet::accept() 
{ 
   if (!isAcceptable())
      return;
   m.setTitle(lneTitle->text());
   m.setPriority(lnePriority->text().toInt());
}

void KDlgManagerSet::reject()
{
}

#include "kdlgmanagerset.moc"

/* Local Variables: */
/* mode: c++ */
/* End: */
