//****************************************************************
//** digital simulation 
//** 
//** Andreas Rostin
//** 12.10.1997
//****************************************************************
#include <kapp.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klogic.h>
#include <version.h>
#include <mainw.h>

// unique-id counter
int uniqueID::id = 0;

// global constants
const QString Global::Klogic::Name = "klogic";
const QString Global::Klogic::emptyFileName = i18n("new.circuit");

int Global::Screen::VIRT_SCREEN_SIZE_X = 2600;
int Global::Screen::VIRT_SCREEN_SIZE_Y = 1200;

QString Global::CurrentCircuit::filename = "";
QString Global::CurrentCircuit::version = "";
QString Global::CurrentCircuit::creation = "";
QString Global::CurrentCircuit::author = "";
QString Global::CurrentCircuit::title = "";
QString Global::CurrentCircuit::comment = "";

static KCmdLineOptions options[] =
{
	{ "+[File]", i18n("file to open"), 0 },
	{ 0, 0, 0 }
};

int main( int argc, char **argv )
{	KApplication *a;
	MainWidget *w;

	uniqueID::reset();

	KAboutData aboutData(Global::Klogic::Name, Global::Klogic::Name,
		VERSION, i18n("digital circuit simulator"), KAboutData::License_GPL,
		"(c) 2003 Andreas Rostin", 0, 0, "andreas@a-rostin.de");

	aboutData.addAuthor("Andreas Rostin",0, "andreas@a-rostin.de");
	KCmdLineArgs::init( argc, argv, &aboutData );
	KCmdLineArgs::addCmdLineOptions( options );

	a = new KApplication();				// takes KCmdLineArgs and KAboutData

	// main-widget
	if (a->isRestored()) {
		RESTORE(MainWidget(a));
	} else {
		KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
		if (args->count() == 1)
			w = new MainWidget(a, args->arg(0));
		else
			w = new MainWidget(a);
		args->clear();
		a->setMainWidget(w);
    		w->show();
	}

    	return a->exec();

	delete w;
}

