#ifndef __DEVICE_TEXT__
#define __DEVICE_TEXT__

#include <qpainter.h>
#include "xdevice.h"

class TextDevice : public XDevice
{
public:
	TextDevice(int x, int y, int size = -1, int del = -1, int undef = -1, int clock = -1)
		: XDevice(DeviceType::fTXT, x, y, size, del, undef, clock)
	{
	}

	virtual ~TextDevice()
	{
	}

	virtual void init()
	{
		deviceOutputInverted = false;
		setSize(MINSIZE);
		deviceMaxInput = 0;
		deviceMaxOutput = 0;

		XDevice::init();
	}

	virtual void * getInstance()
	{
		return (void *)this;
	}

	virtual void setEquation()
	{
		Device::setEquation(Operator::NONE);
	}

	virtual bool hasClock()
	{
		return false;
	}

	virtual bool sizeChangeable()
	{
		return true;
	}

	virtual void displayName(bool)
	{
	}

	virtual void setImage()
	{	QPixmap *pic = getImage();
		QPainter p;

		p.begin(pic);
		p.setFont(XDevice::STATfont);
		QRect r = p.boundingRect(1000, 1000, 1000, 1000, Qt::AlignLeft, getName());
		p.end();

		if (r.width() < 1) r.setWidth(10);
		if (r.height() < 1) r.setHeight(8);
		pic->resize(r.width() + 4, r.height());

		p.begin(pic);
		p.setBrush(Qt::white);
		p.setPen(Qt::black);
		p.drawRect(pic->rect());
		p.setFont(STATfont);
		p.drawText(3, pic->height() - 2, getName());
		setVOffset(-3);

		drawConnectionLines(&p);
		XObject::setImage();
		p.end();
	}

	virtual void printImage(QPainter *, const QRect &)
	{
	}

	// return device's output value
	virtual int output(int)
	{
		return 0;
	}

	virtual int outputChanged()
	{
		return 0;
	}

	virtual void Calculate(int)
	{
	}

	virtual void Propagate(int)
	{
	}
};

#endif
