#ifndef __DEVICE_SWITCH__
#define __DEVICE_SWITCH__

#include <qpainter.h>
#include "xdevice.h"

// interface devices for circuit
class SwitchDevice : public XDevice
{
public:
	SwitchDevice(int x, int y, int size = -1, int del = -1, int undef = -1, int clock = -1)
		: XDevice(DeviceType::fSWI, x, y, size, del, undef, clock)
		{
			m_iInputValue = 0;
		}

	virtual ~SwitchDevice()
	{
	}

	virtual void init()
	{
		deviceOutputInverted = false;
		deviceMaxInput = 0;
		m_bToggle = false;

		XDevice::init();
	}

	virtual void * getInstance()
	{
		return (void *)this;
	}

	virtual void setEquation()
	{
		Device::setEquation(Operator::NONE);
	}

	virtual bool hasClock()
	{
		return false;
	}

	virtual bool sizeChangeable()
	{
		return false;
	}

	virtual bool isInteractive()
	{
		return true;
	}

	virtual bool isEditable()
	{
		return false;
	}

	virtual bool hasStaticInput() const
	{
		return true;
	}

	// push button or switch button?
	virtual bool isToggle() const
	{
		return m_bToggle;
	}

	virtual void setToggle(bool bToggle)
	{
		if (m_bToggle != bToggle) {
			m_bToggle = bToggle;
			if (!Device::IMPORT_IGNORE_GLOBAL)
				setImage();
		}
	}

	// set static output-value
	virtual void toggleStaticInput()
	{
		if (m_iInputValue) m_iInputValue = 0;
		else m_iInputValue = 1;
		named_output.Get()->flush(m_iInputValue);
		forceOutputChange();
	}

	// set static input-value
	virtual void setStaticInput(int val)
	{
		m_iInputValue = val;
		named_output.Get()->flush(m_iInputValue);
		forceOutputChange();
	}

	virtual void setImage()
	{	QPixmap *pic = getImage();
		QPoint pt(0, 0);
		QPainter p;
		QPoint pp(15, 35);

		pic->resize(pxSWI0->width(), pxSWI0->height());

		p.begin(pic);
		p.drawPixmap(pt, *pxSWI0);
		setHOffset(-2);

		drawConnectionLines(&p);
		XObject::setImage();

		p.end();

		if (m_oTextDev) m_oTextDev->setImage();
	}

	virtual void printImage(QPainter *p, const QRect &r)
	{
		QRect rr(r);
		rr.setY(r.y() + 12);
		rr.setHeight(r.height() - 20);
		p->drawRect(rr);
		int a = rr.x() + 8;
		int b = rr.x() + rr.width() - 7;
		int c = rr.y() + (rr.height() / 2) + 1;
		p->drawLine(rr.x() + 2, c, a, c);
		p->drawLine(b, c, rr.x() + rr.width() - 2, c);
		p->drawLine(a, c, b + 1, c - 3);
		p->drawLine(b, c, b, c - 4);
	}

	// set image in dependance of output value
	virtual bool setColor()
	{
		if (!outputChanged())
			return false;

		QPixmap *img = 0;
		if (m_iInputValue)
			img = pxSWI1;
		else
			img = pxSWI0;

		QPainter p;
		QPixmap *pic = getImage();
		p.begin(pic);
		QPoint pp(0,0);
		p.drawPixmap(pp, *img);
		drawConnectionLines(&p);
		p.end();
		return true;
	}

	virtual int output(int = 0)
	{
		return m_iInputValue;
	}

	virtual int outputChanged()
	{
		return m_bChangedOutput;
	}

	virtual void forceOutputChange()
	{
		m_bChangedOutput = true;
	}

	virtual void Calculate(int)
	{
	}

	virtual void Propagate(int)
	{
		if (m_bChangedOutput) {
			if (!m_bLastChangedOutput) {
				m_bLastChangedOutput = true;
			} else {
				m_bLastChangedOutput = false;
				m_bChangedOutput = false;
			}
		}
	}

private:
	int m_iInputValue;
	bool m_bChangedOutput;
	bool m_bLastChangedOutput;
	bool m_bToggle;		// push button or switch?
};

#endif
