#ifndef __DEVICE_OSCOLLATOR__
#define __DEVICE_OSCOLLATOR__

#include <qpainter.h>
#include "xdevice.h"

class OscillatorDevice : public XDevice
{
public:
	OscillatorDevice(int x, int y, int size = -1, int del = -1, int undef = -1, int clock = -1)
		: XDevice(DeviceType::fOSC, x, y, size, del, undef, clock)
	{
	}

	virtual ~OscillatorDevice()
	{
	}

	virtual void init()
	{
		osz_off_cnt = DEFAULT_OSC_CNT;
		osz_on_cnt = DEFAULT_OSC_CNT;
		osz_curr_step = 0;
		if (clock() != CLK_MONO && clock() != CLK_MULTI) setClock(CLK_MULTI);

		deviceOutputInverted = false;
		deviceSize = MINSIZE;
		if (clock() == CLK_MULTI) deviceMaxInput = 0;
		else deviceMaxInput = 1;
		static_output_value = 0;

		XDevice::init();
	}

	virtual void * getInstance()
	{
		return (void *)this;
	}

	virtual void setEquation()
	{
		Device::setEquation(Operator::NONE);
	}

	virtual bool hasClock()
	{
		return true;
	}

	virtual void setClock(int new_clk)
	{
		if (new_clk == CLK_MULTI) deviceMaxInput = 0;
		else deviceMaxInput = 1;

		Device::setClock(new_clk);
		setImage();
	}

	virtual bool sizeChangeable()
	{
		return false;
	}

	virtual void setImage()
	{	QPixmap *pic = getImage();
		QPoint pt(0, 0);
		QPainter p;
		QPoint pp(15, 35);

		int i =  PTOP->height() + (PMID->height() * deviceSize) + PBOT->height();
		pic->resize(PTOP->width(), i);

		p.begin(pic);

		// the body
		p.drawPixmap(pt, *PTOP);
		pt.setY(pt.y() + PTOP->height());
		for(int i = 0; i < deviceSize; i++) {
			p.drawPixmap(pt, *PMID);
			pt.setY(pt.y() + PMID->height());
		}
		p.drawPixmap(pt, *PBOT);

		// the symbol
		if (clock() == CLK_MULTI) {
			pp.setX(pic->width()/2 - syOSC->width()/2);
			pp.setY(pic->height()/2 - syOSC->height()/2);
			p.drawPixmap(pp, *syOSC);
		} else {
			pp.setX(pic->width()/2 - syMONOFLOP->width()/2);
			pp.setY(pic->height()/2 - syMONOFLOP->height()/2);
			p.drawPixmap(pp, *syMONOFLOP);
		}
		drawConnectionLines(&p);
		XObject::setImage();

		p.end();

		if (m_oTextDev) m_oTextDev->setImage();
	}

	virtual void printImage(QPainter *p, const QRect &r)
	{	int a,d,e,h;

		if (clock() == CLK_MULTI) {
			a = r.x() + 2;
			h = (r.width() - IOREG) / IOREG;
			d = r.y() + (r.height() / 2) - 4;
			e = r.y() + (r.height() / 2) + 4;
			p->drawLine(a, e, a + h, e);
			p->drawLine(a + h, e, a + h, d);
			p->drawLine(a + h, d, a + h + h, d);
			p->drawLine(a + h + h, d, a + h + h, e);
			p->drawLine(a + h + h, e, a + h + h + h, e);
			p->drawLine(a + h + h + h, e, a + h + h + h, d);
			p->drawLine(a + h + h + h, d, a + h + h + h + h, d);
		} else {
			a = r.x() + 2;
			h = (r.width() - IOREG) / IOREG;
			d = r.y() + (r.height() / 2) - 4;
			e = r.y() + (r.height() / 2) + 4;
			p->drawLine(a, e, a + h, e);
			p->drawLine(a + h, e, a + h, d);
			p->drawLine(a + h, d, a + h + h, d);
			p->drawLine(a + h + h, d, a + h + h, e);
			p->drawLine(a + h + h, e, a + h + h + h + h, e);
		}
	}

	// return device's output value
	virtual int output(int)
	{
		return static_output_value;
	}

	virtual int outputChanged()
	{
		if (old_static_output_value != static_output_value) return 1;
		return 0;
	}

	// oscillator has a very special calculation (the only one which is special!)
	// whatever we do here, ::Calculate() should result into a OpStack::calculate(..) ..
	// .. otherwise no output will change for ever
	virtual void Calculate(int burst_step) 
	{
		old_static_output_value = static_output_value;
		if (!burst_step) {
			if (clock() == CLK_MULTI) {
				osz_curr_step++;
				if (static_output_value && osz_curr_step >= osz_on_cnt) {
					static_output_value = 0;
					osz_curr_step = 0;
				}
				if (!static_output_value && osz_curr_step >= osz_off_cnt) {
					static_output_value = 1;
					osz_curr_step = 0;
				}
			} else {
				KlogicList<Device> *l = connection_list.First();
				if (l) {
					if (static_output_value) {
						if (osz_curr_step > osz_on_cnt) static_output_value = 0;
						else osz_curr_step++;
					} else {
						if (l->Get()->output()) {
							if (!osz_curr_step) static_output_value = 1;
						} else osz_curr_step = 0;
					}
				}
			}
			named_output.Get()->push(static_output_value);
			named_output.Get()->calculate(tristate_active);
		}
	}

	virtual void Propagate(int)
	{
	}

	virtual int oszOn()
	{
		return osz_on_cnt;
	}
	 
	virtual void setOszOn(int value)
	{
		osz_on_cnt = value;
	}
	 
	virtual int oszOff()
	{
		return osz_off_cnt;
	}

	virtual void setOszOff(int value)
	{
		osz_off_cnt = value;
	}
	 
	// only for export
	virtual int getCurrOszStep()
	{
		return osz_curr_step;
	}
	 
	// only for import
	virtual void setCurrOszStep(int curr_step)
	{
		osz_curr_step = curr_step;
	}

	static const int CLK_MONO = 7;
	static const int CLK_MULTI = 8;
	static const int MAXOSCCNT = 10000;

private:
	// oszillator timing
	int osz_off_cnt;
	int osz_on_cnt;
	int osz_curr_step;
	int static_output_value;
	int old_static_output_value;
};

#endif
