/*******************************************/
/* XML Symbols                             */
/* it can only accessed via XmlObject      */
/* because of the static list template     */
/* of XmlSymbolContainer instances within  */
/* XmlSymbolContainer itself               */
/*                                         */
/* so enhancements must be encapsulated by */
/* XmlObject class                         */
/*                                         */
/* Andreas Rostin 23.08.2001               */
/*******************************************/
#ifndef __XMLSYMBOLCONTAINER__
#define __XMLSYMBOLCONTAINER__

class XmlSymbolContainer
{
public:
        XmlSymbolContainer(const char *_name, int _id)
	{
		memset(name, 0, 64);
		memset(sid, 0, 5);
		memcpy(name, _name, strlen(_name));
		sprintf(sid, "%d", _id);
		id = _id;
		static_map->Append(this, _id)->setText(_name);
	}

	static XmlSymbolContainer * get(int _id)
	{
		KlogicList<XmlSymbolContainer> *lsym = static_map->With(_id);
		if (lsym) return lsym->Get();
		return (XmlSymbolContainer *)NULL;
	}

	static XmlSymbolContainer * get(const char *_name)
	{
		KlogicList<XmlSymbolContainer> *lsym = static_map->With(_name);
		if (lsym) return lsym->Get();
		return (XmlSymbolContainer *)NULL;
	}

        bool operator== (int _id)
	{
		if (id == _id)
			return true;
		return false;
	}

        const char * operator[] (int idx)
	{
		if (idx == 0) return name;
		if (idx == 1) return sid;
		return (const char *)NULL;
	}

        int getID()
	{
		return id;
	}
 
private:
        char name[64];
        char sid[5];
        int id;
	static KlogicList<XmlSymbolContainer> *static_map;
};

KlogicList<XmlSymbolContainer> * XmlSymbolContainer::static_map = new KlogicList<XmlSymbolContainer>;

#endif
