#ifndef __SYMBOLOPSTACK_CLASS__
#define __SYMBOLOPSTACK_CLASS__

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
class Device;
class QString;
class StackInfo; // see value.h
#include<value.h>
class Fifo;
template <class T> class KlogicList;
#include <opStack.h>

class SymbolOpStack : public opStack {
public:
	SymbolOpStack();
	~SymbolOpStack();

	char * calculateSymbolic();                     // calculate the stack symbolic, return the new equation
	char * calculateSymbolicNormalized(int, int);   // build minimal normalized equation, return the new equation
	const char * getSymbol(int);                    // return the n-th symbol in the equation (each symbol only once,start with 0!)
	void getPatterns(char ***, int *, int ***, int *);// return a set of all possible patterns
	void getGroups(int ***, int **, int *);         // return a set of groups found in  patterns
							// the pointer may become invalid on further operations

private:
	virtual int getPattern(int pattern_idx);
	void scanInputList();
	void calculatePattern();
	static int needsParenthesis(char *, char);

	// analyze pattern
	char **input_list;
	int input_cnt;

	int *pattern_idx;
	int **patterns;
	char *daa_patterns;
	unsigned daa_patterns_dimensions[2];
	int *pattern;           // pointer to the current pattern, no memory to free!
	int pattern_cnt;

	int pattern_mode;

	// the groups found using the normalizing algorithm
	int **group;            // array of groups found
	int *group_size;        // size of groups held in int**group
	int group_cnt;          // total number of groups in int**group
	char *daa_group;        // pointer to use with free
	unsigned daa_group_dimensions[2];
	char *tmp_equ;
};

#endif
