/*************************************************/
/* methods for class PropName                    */
/*                                               */
/* name property dialog                          */
/*                                               */
/* Andreas Rostin                                */
/* 15.01.99                                      */
/*************************************************/
#include <qmessagebox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <klineedit.h>

#include "klogic.h"
#include "netw.h"
#include "xnet.h"
#include "xdevice.h"
#include "deviceTypes.h"

#include "propName.h"
#include "propName.moc"

PropName::PropName(QWidget *parent, QString name, NetWidget *_netw, XDeviceNet *_dnet, XDevice *_dev)
	: QDialog(parent, name, TRUE, WStyle_DialogBorder)
{
    // main variable for this dialog:
    dev = _dev;
    dnet = _dnet;
    netw = _netw;

    label0 = new QLabel((QWidget *)this, (QString)NULL);
    label0->setGeometry(30, 10, 43, 20);
    label0->setText(i18n("Name"));
    devname = new KLineEdit((QWidget *)this, (QString)NULL);
    devname->setGeometry(80, 10, 80, 20);
    devname->setCaption("(null)");
    if (dev->type() == DeviceType::fIN || dev->type() == DeviceType::fOUT)
	    devname->setMaxLength(4);

    bCancel = new QPushButton(this);
    bCancel->setGeometry(108, 50, 60, 25);
    bCancel->setText(i18n("Cancel"));

    bOK = new QPushButton(this);
    bOK->setGeometry(25, 50, 60, 25);
    bOK->setDefault(true);
    bOK->setText(i18n("OK"));

    setCaption(name);
    setFixedSize(195, 95);
    devname->setText(dev->getText());

    connect(bOK, SIGNAL(clicked()), SLOT(accept()));
    connect(bCancel, SIGNAL(clicked()), SLOT(reject()));
}

void PropName::done(int r)
{
	if (r == Accepted) {
                // check/set new name
		QString s = dev->getText();
		if (0 != devname->text().compare(s)) {
			dnet->setText(dev->getID(), devname->text());
			netw->repaint(TRUE);
                }
	}
	QDialog::done(r);
}

