#ifndef __OPSTACK_CLASS__
#define __OPSTACK_CLASS__

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <qvalidator.h>

class Device;
class QString;
class QueueInfo; // see value.h
#include<value.h>
class Fifo;
template <class T> class KlogicList;

// operations
#define OP_BRACKET	'('
#define OP_AND		'&'
#define OP_OR		'+'
#define OP_XOR		'#'
#define OP_NOT		'/'
#define OP_BIN		''
#define OP_BIT		'%'
#define OP_NONE		'\10'
#define OP_INTERFACE	'\11'

// operation types
#define OP_PARENTHESIS	0
#define OP_LR		1	// left and right operand required
#define OP_R		2	// right operand only

// error codes
#define STACK_NEG_ERROR	1
#define STACK_POS_ERROR	2
#define NTERM_ERROR	3
#define PAR_ERROR	4

// max. number of inputs for a static device
#define OP_MAXINP	100

class opStack : public DelayedValue {
public:
	static int instance;

	opStack(Device *, int, int);
	opStack();
	virtual ~opStack();			// virtual to avoid warnings only!

	void setEquation(char);			// set single operator as equation (no named inputs)
	void setEquation(char *);		// set equation
	void setEquation(const char *);		// set equation
	QString getEquation();			// return equation
	QString getEquation(const char *);	// return prefixed equation
	int hasEquation();			// return wether we have an equation or not
	char hasStaticOP();			// true if equation contains a single operator

	void clear();				// clear calculation stack, reset parsing
	QueueInfo parse();			// parse current equation, build calculation stack
	QueueInfo parse(KlogicList<Value> *, KlogicList<opStack> *);// parse current equation, check computation, build calculation stack (needs a dev)

	void push(int);				// push values to the calculation stack
	int calculate(bool);			// calculate the stack, return the result (needs a dev)

	void stackDump();			// debug
	void groupDump(int group_no, int **group, int *group_cnt);	// debug

	char ** getQueue();			// return parsed queue
	QueueInfo ** getInfo();			// return info for the queue elements
	int getCounter();			// return number of elements in queue

	static bool isNumber(QString str);

protected:
	char *equation;				// the equation
	char **queue;				// calculation queue
	int total;				// total items in the queue
	int maxitem;				// max number of items for queue, stack and stack_info
	int plane;				// total no of values in the stack

private:
	char * getOP(char *);			// return pointer to an operation contained in string
	// methods used for parsing equations
	int parse(char *, int current_offset, int docnt = 0);
	// check that calculation stack is computational
	QueueInfo check(KlogicList<Value> *, KlogicList<opStack> *);
	virtual int getPattern(int pattern_idx) { pattern_idx = 0; return 0; };	// by SymbolOpStack

	int getBracket(char *);
	int getLeft(char *, char **);
	int getRight(char *, char **);
	void push(char *, int length, int current_offset);
	int opType(char);
	void init();

	QueueInfo **queue_info;

	// the owner of the queue
	Device *dev;

	// type of calculation: static (unique operation on all input values) or dynamic (equation based)
	char staticOP;

	// operation stack to push values
	int * stack;

	static QIntValidator intValidator;
};

#endif

