/***************************************************************************
                          setuplang.cpp  -  description
                             -------------------
    begin                : Fri Feb 22 2002
    copyright            : (C) 2002 by Anne-Marie Mahfouf
    email                : annma@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "setuplang.h"

setupLang::setupLang(QWidget *parent, const char *name ) : setupDlg(parent,name)
{
	QObject::connect(finishButton, SIGNAL(clicked()), this, SLOT(slotFinish()));
	QObject::connect(frenchButton, SIGNAL(clicked()), this, SLOT(slotFrench()));
   QObject::connect(dutchButton, SIGNAL(clicked()), this, SLOT(slotDutch()));
	QObject::connect(cancelButton, SIGNAL(clicked()), this, SLOT(slotCancel()));
}

setupLang::~setupLang()
{
}

/** No descriptions */
void setupLang::slotFinish()
{
	if (!lang) lang="french";//in case Finish button is clicked without language selected
											//at first run
	//config is stored after the first time set up
	KConfig *config = kapp->config();
	config->setGroup("Language");
	config->writeEntry("MyLanguage", lang);
	config->setGroup("french");
	config->writeEntry("Alphabet", 26);
   config->writeEntry("Syllables", 28);
	config->setGroup("dutch");
	config->writeEntry("Alphabet", 22);
   config->writeEntry("Syllables", 26);
  //read config to find l1 and l2
	config->setGroup(lang);	
	l1 =config->readNumEntry("Alphabet");
	l2 =config->readNumEntry("Syllables");
	this->close();
}

/** Choose French */
void setupLang::slotFrench()
{
		lang="french";
		frenchLabel->setText("  Currently choosen");
		dutchLabel->setText("");
}

/** Cancel: retain language or set French as default if none */
void setupLang::slotCancel()
{
		if (!lang) lang="french";   //set French as default if no language choosen and no config file
		frenchLabel->setText("  Currently choosen");
		dutchLabel->setText("");
		slotFinish();
}

/** Choose Dutch  */
void setupLang::slotDutch()
{
		lang="dutch";	
		dutchLabel->setText("  Currently choosen");
		frenchLabel->setText("");
}

#include "setuplang.moc"
