/***************************************************************************
                          klettres.cpp  -  description
                             -------------------
    begin                : Wed Oct 17 17:12:06 BST 2001
    copyright            : (C) 2001 by Anne-Marie Mahfouf
    email                : annma@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "klettres.h"

QString s[30], sd[30], a1, t1, sb, s1, sj, st;
int n=0, niveau=1;

KLettres::KLettres(QWidget *parent, const char *name) : KLettresDlg(parent, name)
{
	setuplng=NULL;
	QAccel *a = new QAccel( comb1 );        // create accels for comb1
	a->connectItem( a->insertItem(Key_L+ALT), // adds ALT+N accelerator
	                this,                  // connected to this'
	                SLOT(slotNiveau()) );

	// Set up the help menu
   	mHelpMenu = new KHelpMenu(this, KGlobal::instance()->aboutData(), true);
	aide->setPopup(mHelpMenu->menu());
	// signals and slots connections
	connect( comb1, SIGNAL( activated(int) ), this, SLOT( slotNext(int) ) );
	QObject::connect( quitte, SIGNAL( clicked() ), kapp, SLOT( quit() ) );

	QPixmap pm;
	pm.load(locate("data","klettres/pics/klettres_back.jpeg"));
	setBackgroundPixmap(pm);

	QFont f( "bitstream-courier" , 100, QFont::Bold );
    button1->setFont( f );
	line1->setFont(f);

	 QObject::connect( langButton, SIGNAL( clicked() ), this, SLOT( slotLang() ) );

   //see if there is a config file
	//if not first time setup called
	//first time setup write the config file
    KConfig *config = kapp->config();
	 config->setGroup("Language");
	 langString=config->readEntry("MyLanguage");
	 if (!langString) //if there is no config file
	 {
		setuplng = new setupLang();
		setuplng->show();
		langString=setuplng->lang;
		l1=setuplng->l1;
		l2=setuplng->l2;
		QObject::connect(setuplng->finishButton, SIGNAL(clicked()), this, SLOT(game()));
	 }
  else
	{
		config->setGroup(langString);	
		l1 =config->readNumEntry("Alphabet");
		l2 =config->readNumEntry("Syllables");
		game();
	}
}


KLettres::~KLettres()
{
}

/** When level changes */
void KLettres::slotNext(int index)
{
	switch ( index )
	{
	default:
	case 0:
		niveau=1;
		break;

	case 1:
		niveau=2;
		break;

	case 2:
		niveau=3;
		break;

	case 3:
		niveau=4;
		break;
	}
	game();
}

/**main fonction */
void KLettres::game()
{
	if (setuplng)
	{              //pass the config variables from setup
		l1=setuplng->l1;
		l2=setuplng->l2;
	   langString=setuplng->lang;
   }
	language=langString;
	show();
	if (niveau==1)
		button1->show();

	if (niveau==2)
		button1->hide();

	if (niveau==1||niveau==2)
	{
		button1->setMinimumSize( QSize( 200, 160 ) );
		button1->setMaximumSize( QSize( 200, 160 ) );
		line1->setMinimumSize( QSize( 140, 160 ) );
		line1->setMaximumSize( QSize( 140, 160 ) );
		srand((unsigned int)time((time_t *)NULL));
		n=rand()%l1;     //choose a random number
		dataString=QString("klettres/%1/data/level1.txt").arg(language);  //dataString holds the data file name
		string2=QString("klettres/%1/alpha/a-%2.mp3").arg(language).arg(n);
		 play();

		QObject::connect(line1, SIGNAL(textChanged(const
 QString&)),this,SLOT(treat1(const QString&)) );
		QObject::disconnect(line1, SIGNAL(textChanged(const
 QString&)),this,SLOT(slotLet2(const QString&)) );
	}

	if (niveau==3)
		button1->show();

	if (niveau==4)
		button1->hide();

	if (niveau==3 || niveau==4)
	{
		srand((unsigned int)time((time_t *)NULL));
		n=rand()%l2;
		dataString=QString("klettres/%1/data/level3.txt").arg(language);  //dataString holds the data file name
		string2=QString("klettres/%1/syllab/ad-%2.mp3").arg(language).arg(n);
       play();
		if (length==2)
		{
			button1->setMinimumSize( QSize( 200, 160 ) );
			button1->setMaximumSize( QSize( 200, 160 ) );
			line1->setMinimumSize( QSize( 200, 160 ) );
			line1->setMaximumSize( QSize( 200, 160 ) );
		}
       	if (length==3)
		{
			button1->setMinimumSize( QSize(250, 160 ) );
			button1->setMaximumSize( QSize( 250, 160 ) );
			line1->setMinimumSize( QSize( 250, 160 ) );
			line1->setMaximumSize( QSize( 250, 160 ) );
		}
		QObject::connect(line1, SIGNAL(textChanged(const
 QString&)),this,SLOT(slotLet2(const QString&)) );
		QObject::disconnect(line1, SIGNAL(textChanged(const
 QString&)),this,SLOT(treat1(const QString&)) );
	}
	line1->setMaxLength( 1 );
	line1->setCursorPosition(0);
	line1->setFocus();
}

void KLettres::treat1(const QString& p)
{
	QObject::disconnect(line1, SIGNAL(textChanged(const
 QString&)),this,SLOT(treat1(const QString&)) );
	QObject::disconnect(line1, SIGNAL(textChanged(const
 QString&)),this,SLOT(slotLet2(const QString&)) );
	a1=line1->text();         //get text from LineEdit
   t1.sprintf(a1.upper().latin1());    //put it in uppercase
	line1->selectAll();
	line1->cut();
	line1->setText(t1);     //display it in uppercase
	if (niveau==2)
		button1->hide();
	emit newText(p);
	QTimer *timer = new QTimer( this );
	connect( timer, SIGNAL(timeout()),
	         this, SLOT(timer1()) );
	timer->start( 2000, TRUE );
}

void KLettres::timer1()
{
	line1->selectAll();
	if ((button1->text())==t1)
	{
		srand((unsigned int)time((time_t *)NULL));
		n=rand()%l1;
		dataString=QString("klettres/%1/data/level1.txt").arg(language);
		string2=QString("klettres/%1/alpha/a-%2.mp3").arg(language).arg(n);
		play();
	}
	else
	{
		if (niveau==2)
		button1->show(); //show letter after first miss

		string2=QString("klettres/french/alpha/a-%1.mp3").arg(n);    //replay sound
		string1=locate("data",string2);                //of letter
		KAudioPlayer::play(string1);
	}
		
	line1->cut();

	QObject::connect(line1, SIGNAL(textChanged(const
 				QString&)),this,SLOT(treat1(const QString&)) );
	line1->setFocus();
}

//levels 3 and 4
void KLettres::slotLet2(const QString& s)
{
	line1->clearFocus();
	//disconnect
	QObject::disconnect(line1, SIGNAL(textChanged(const
 		QString&)),this,SLOT(slotLet2(const QString&)) );

	line1->cursorLeft(true, 1);
	a1=line1->markedText();   //get the input letter
	t1.sprintf(a1.upper().latin1()); //input in uppercase
	line1->cut();
	line1->setText(line1->text()+t1);
    t1=line1->text(); //t1 is the whole lineEdit text now
	sj=st.left(input);
	QTimer *timer = new QTimer( this );
	connect( timer, SIGNAL(timeout()),
	         this, SLOT(timerDone()) );
	timer->start( 1000, TRUE );
}

void KLettres::timerDone()
{
	if (t1==sj)   //if letter input is correct
	{
	   if (sj!=st)  //if text in lineEdit not equal to text on button
		{            //i.e if you still have to allow input
			line1->setMaxLength( input+1 );
			line1->setCursorPosition( input );
			line1->setFocus();
			input++;
			QObject::connect(line1, SIGNAL(textChanged(const
 					QString&)),this,SLOT(slotLet2(const QString&)) );
       }
		else
		{
			line1->selectAll();
			line1->cut();
			line1->setCursorPosition(0 );
			line1->setFocus();
			line1->setMaxLength( 1 );
      		if (niveau==4)
				button1->hide();
			game();  //another syllable
		}
	}
	else   //if not, cut it
	{
		line1->backspace();  //delete the char to the left  and position curseur accordingly
		line1->setFocus();
		//play sound again
		string2=QString("klettres/%1/syllab/ad-%2.mp3").arg(language).arg(n);
		string1=locate("data",string2);
		KAudioPlayer::play(string1);

		QObject::connect(line1, SIGNAL(textChanged(const
 QString&)),this,SLOT(slotLet2(const QString&)) );
	}
}

void KLettres::slotNiveau()
{
	if ((niveau==1)||(niveau==2)||(niveau==3))
		niveau++;
	else
	{
		if (niveau==4)
			niveau--;
	}
	comb1->setCurrentItem( niveau-1 );
	game();
}

/**Play the sound and display the letter/syllable*/
void KLettres::play()
{
		input=1;
      lev1File.setName(locate("data",dataString));
       if (!lev1File.exists()) //if the data files are not installed in the correct dir
         {
					QString mString=QString("File $KDEDIR/share/apps/%1 not found!\n"
                                                  "Check your installation, please!").arg(dataString);
					KMessageBox::sorry( this, mString,
		                    "KLettres - Error" );
					exit(1);
			}
		lev1File.open(IO_ReadOnly);
		QTextStream namesStream( &lev1File);
		QString nameString;
		int count=0;
		while (namesStream.atEnd()==0)
		{
			//read one line from the text
			nameString=namesStream.readLine();
			if (count==n)
				st=nameString; //store the choosen word in variable st
			count++ ;
		}
		lev1File.close();    	
  		button1->setText(st);
		length=st.length();
		string1=locate("data",string2);
		 if (!string1) //if the sound files are not installed  correctly
         {
					QString mString=QString("File $KDEDIR/share/apps/%1 not found!\n"
                                                  "Check your installation, please!").arg(string2);
					KMessageBox::sorry( this, mString,
		                    "KLettres - Error" );
					exit(1);
			}
		KAudioPlayer::play(string1);
}

/** Call the language setup */
void KLettres::slotLang()
{
		setuplng = new setupLang();
		setuplng->show();
		setuplng->lang=language;//in case of Cancel
		if (language=="dutch")
			setuplng->dutchLabel->setText("  Currently choosen");	
	   	if (language=="french")
			setuplng->frenchLabel->setText("  Currently choosen");	
		QObject::connect(setuplng->finishButton, SIGNAL(clicked()), this, SLOT(game()));
}

#include "klettres.moc"
