// tbuddylist.h
//
// Kit AIM client
//
// For copyright and license, see accompanying documentation

#ifndef TBUDDYLIST_H
#define TBUDDYLIST_H

#include <qstring.h>

typedef struct TBuddy
{
	QString name;
	QString alias;
	int group;
	int status;
	int userClass;
	int signonTime;
	int idleTime;
	QString idleTimeString;
	int evil;
	int lastOn;
	QString lastOnString;
  int signedOn;
	
	TBuddy *prev;
	TBuddy *next;
};

typedef struct TBuddyGroup
{
	QString name;
  int size;
	TBuddyGroup *prev;
	TBuddyGroup *next;
};

class TBuddyList
{
  public:
    TBuddyList();
    TBuddyList(const TBuddyList &);
    TBuddyList operator=(const TBuddyList &);
    ~TBuddyList();

    int add(const TBuddy *);
    int del(int num);
    int del(const QString &name);
    QString getName(int num) const;
		QString getAlias(int num) const;
    int getNum(const QString &name) const;
    int getGroup(int num) const;
    int getStatus(int num) const;
    int get(TBuddy *, int num) const;
    int get(TBuddy *, const QString &name) const;
    inline int getCount(void) const {return count;};
    
    int setStatus(int num, int status);
    int setUserClass(int num, int userClass);
    int setSignonTime(int num, int time);
		int setIdleTime(int num, int time);
		int setIdleTimeString(int num, QString time);
    int setEvil(int num, int evil);
    int setLastOn(int num, int time);
		int setLastOnString(int num, QString time);
    int setGroup(int num, int group);
	 	
    int addGroup(const QString &name);
    int delGroup(int num);
		
    int delGroup(const QString &name);
    int renameGroup(const QString &oldname, const QString &newname);
    QString getNameGroup(int num) const;
    int getNumGroup(const QString &name) const;
    inline int getCountGroup(void) const {return countG;};

    void reset(void);

    TBuddy *getByNum(int) const;
    TBuddyGroup *getByNumG(int) const;
  
  private:
		TBuddy *head;
		TBuddy *tail;
		int count;

		TBuddyGroup *headG;
		TBuddyGroup *tailG;
		int countG;

};

#endif

