/***************************************************************************
                           soundconfigureimp.cpp
                             -------------------
    begin                : Thursday April 13 2001 
    copyright            : (C) 2001 Benjamin Meyer
    email                : ben@meyerhome.net
 ***************************************************************************/


#include "soundconfigureimp.h"
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qfiledialog.h>

/******************************************************************************
 * Constructor
 ******************************************************************************/
SoundConfigureImp::SoundConfigureImp(QWidget *parent, const char *name) : SoundConfigure( parent,name,false ){
  
	internal.hidden = true;
  connect(buttonOk, SIGNAL(clicked()), this, SLOT(buttonOkHit()));
  connect(buttonDefault, SIGNAL(clicked()), this, SLOT(defaultButtonHit()));

	connect(browseLogin, SIGNAL(clicked()), this, SLOT(browseLoginClicked()));
	connect(browserLogoff, SIGNAL(clicked()), this, SLOT(browseLogOut()));
	connect(browseInitial, SIGNAL(clicked()), this, SLOT(browseInit()));
}

/******************************************************************************
 * Deconstructor
 ******************************************************************************/
SoundConfigureImp::~SoundConfigureImp(){
}

/******************************************************************************
 * Set the default settings for the options to what was passed in the 
 * setDefault() function. 
 ******************************************************************************/
void SoundConfigureImp::defaultButtonHit(){
  login->setText(signOnSound);
	logoff->setText(signOffSound);
  ignore->setChecked(false);
}

/******************************************************************************
 * Copy the data to the internal struct and send out a signal.  Then quit.
 ******************************************************************************/
void SoundConfigureImp::buttonOkHit(){
  internal.signOnSound = login->text();
	internal.signOffSound = logoff->text();
  internal.ignoreSettings = ignore->isChecked();
  updateOrAddPounce(internal);

  this->accept();
}

/******************************************************************************
 * Set the current settings to newpounce
 ******************************************************************************/
void SoundConfigureImp::setPounce(pounce *newpounce){
  internal.buddyName = newpounce->buddyName;
  login->setText(newpounce->signOnSound);
  logoff->setText(newpounce->signOffSound);
	ignore->setChecked(newpounce->ignoreSettings);
}

/******************************************************************************
 * Set the default settings as called by the default button.
 ******************************************************************************/
void SoundConfigureImp::setDefault(pounce *newpounce){
	signOnSound = newpounce->signOnSound;
	signOffSound = newpounce->signOffSound;
}

void SoundConfigureImp::browseLoginClicked(){
  QString s( QFileDialog::getOpenFileName( QString(""),QString("*.wav *.au"),this, "Multimedia Files (*.au *.wav)") );
  if ( s.isEmpty()) return;
	else login->setText(s);
}

void SoundConfigureImp::browseLogOut(){
  QString s( QFileDialog::getOpenFileName( QString(""),QString("*.wav *.au"),this, "Multimedia Files (*.au *.wav)") );
  if ( s.isEmpty()) return;
	else logoff->setText(s);
}

void SoundConfigureImp::browseInit(){
  QString s( QFileDialog::getOpenFileName( QString(""),QString("*.wav *.au"),this, "Multimedia Files (*.au *.wav)") );
  if ( s.isEmpty()) return;
	else initial->setText(s);
}

// SoundConfigureImp.cpp
