/***************************************************************************
                                  sound.cpp
                             -------------------
    begin                : Mon march 10 2001
    copyright            : (C) 2000 by Benjamin Meyer
    email                : ben@meyerhome.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "sound.h"
#include <qmessagebox.h>
#include <unistd.h> 
#include <sys/wait.h>
#include <stdlib.h>
#include <qtextstream.h>
#include <kprocess.h>

/***************************************************************************
 * Constructor
 ***************************************************************************/
Sound::Sound(){
  playCommand = "play";
  mute = false;
}

/***************************************************************************
 * Deconstructor
 ***************************************************************************/
Sound::~Sound(){
}

/***************************************************************************
 * Set the browser choice number
 ***************************************************************************/
void Sound::setSound(QString command){
  playCommand = command;
}

/***************************************************************************
 * make a beep with the system speaker
 ***************************************************************************/
void Sound::beep(){
  if (mute)
    return;

  printf("\a");
  fflush(stdout);
}

void Sound::muteSound(bool muteMe){
  mute = muteMe;
}

/***************************************************************************
 * Open the file that is passed through.
 ***************************************************************************/
void Sound::playFile(QString file){
  if (mute)
    return;


	if (file.mid(0,1) == "-"){
	  printf( "Possible security hack, not parsing: %s.\n" , file.latin1());
	  return;	
	}
	// Make sure we are only passing in one thing.
	int space = file.find(" ", 0, true);
        // If spaces are found, escape them...
	if (space != -1)
          file = file.replace(QRegExp(" "), ("\\ ") );
        KProcess *proc = new KProcess();
        *proc << playCommand.latin1();
        *proc << file.latin1();
        proc->start( KProcess::DontCare );
}

// sound.cpp




