/***************************************************************************
                                  setup.h
                             -------------------
    begin                : Thu Feb 17 2000
    copyright            : (C) 2000 by Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SETUP_H
#define SETUP_H

#include <qstring.h>
#include <qtextstream.h>
#include <qfile.h>
#include <qdict.h>
#include <qmessagebox.h>
#include <stdlib.h>
#include <qdir.h>
#include <qmap.h>
#include <qmultilinedit.h>

#include "tbuddylist.h"
#include "newpounceimp.h"

#include "preferences.h"

struct toolTipData{
  QString tip;
	QRect cords;
};

struct buddylist_Font_Settings{
	QFont buddylist_OnlineFont;
	QFont buddylist_OfflineFont;
	QFont buddylist_SignOnFont;
};


struct im_ToolBar_Settings {		
  bool chat_remove;               // Done
  bool chat_warn;                 // Done
  bool chat_block;                // Done
  bool chat_info;
  bool chat_pounce;
};

struct room_ToolBar_Settings {		
  bool room_invite;
};

struct chat_Settings {		
  bool chat_raise_window;         // Done
  bool chat_flash_on_new_message; // Done
  bool chat_log;                  // Done
  bool chat_log_inHtml;           // Done
  bool chat_show_time;            // Done
  bool chat_log_time;             // Done
  bool chat_return_send;	  			// Done
  bool chat_sreturn_send;         // Done
  bool chat_send_blank;           // Done
  bool chat_ignore_buddyhtml;     // Done
  bool chat_line_limit;           // Done
  bool chat_show_smilies;         // Done
  int chat_line_limit_number;     // Done
  bool chat_log_singleFile;
  bool chat_crypt;
};

struct chat_Color_Settings{
  QColor chat_yourText_color;     // Done
  QColor chat_yourName_color;     // Done
  QColor chat_buddyText_color;    // Done
  QColor chat_buddyName_color;    // Done
  QColor chat_yourbg_color;       // Done
  QColor chat_buddybg_color;      // Done
};

struct chat_Font_Settings{
	QFont chat_yourFont;
	QFont chat_buddyFont;
};

struct chat_Sound_Settings{
  bool chat_sound;                // Done
  bool chat_sound_beepInitial;     // Done
  bool chat_sound_beepReceive;    // Done
  bool chat_sound_beepSend;       // Done
  bool chat_sound_playFile;       // Done
  QString chat_sound_fileSend;
  QString chat_sound_fileReceive;
  QString chat_sound_fileInitial; 
};

struct chat_ToolBar_Settings{
  bool view_text;                 // Done
  bool view_chat;                 // Done

  // 0 top
  // 1 right
  // 2 bottom
  // 3 left                       // Done
  int loc_text;                   // Done
  int loc_chat;                   // Done

  bool text_bold;                 // Done
  bool text_italic;               // Done
  bool text_underline;            // Done

  bool text_fontdown;             // Done
  bool text_fontnormal;           // Done
  bool text_fontbig;              // Done

  bool text_bgcolor;              // Done
  bool text_pencolor;             // Done
  bool text_link;                 // Done
  bool text_smiley;               // Done

  bool chat_send;                 // Done
   
  bool chat_clear;                // Done
  bool chat_save;                 // Done
  bool chat_print;                // Done
  bool chat_time;                 // Done

  bool chat_log;                  // Done
  bool chat_sound;                // Done
};

struct settings_t {		
  QString config;
    
  // Sound
  int SoundMode;
  bool sound_enable_login;
  bool sound_enable_logout;
  QString sound_file_command;
  QString sound_file_login;
  QString sound_file_logout;
 	
  // Network
  QString login_server_toc;
  QString login_server_login;
  QString login_port_toc;
  QString login_port_login;
  bool login_enable_save;					// In Use
  bool login_enable_auto;					// In Use
  QString login_name;					// In Use
  QString login_password;					// In Use
  int proxy_Choice;
  QString proxy_server;
  QString proxy_port;
  	
  // Permit Deny
 
  // Away
  bool away_enable_auto;
  int away_auto_delay_minutes;
  QString away_auto_default_message;
  QMap <QString, QString> *mapAwayMessages;
  bool away_comeBackOnlyOnBackClick;
  bool away_disable_sound;
		
  // General
  bool main_resizeHeight;
  int main_resizeHeightMax;
  int main_resizeHeightMin;
  bool main_resizeWidth;
  int main_resizeWidthMax;
  int main_resizeWidthMin;
  bool main_loginMoveRight;
  bool main_loginMoveLeft;
  bool main_loginMoveNo;
  int main_moveDown;
  bool main_showIdle;
  bool main_showLastOn;
  QString main_browser;
  bool main_noIcons;
  int main_idleLayout;
  bool main_noHeader;
  bool main_useX11ForIdle;
  bool main_mute_on_login;
  bool main_log_on_off;

  // Chat Settings
  chat_Settings *chatSettings;
  chat_Color_Settings *chatColorSettings;
  buddylist_Font_Settings *buddylistFontSettings;
  chat_Font_Settings *chatFontSettings;
  chat_Sound_Settings *chatSoundSettings;
  chat_ToolBar_Settings *chatToolBarSettings;
  im_ToolBar_Settings *imToolBarSettings;

  chat_ToolBar_Settings *chatRoomToolBarSettings;
  room_ToolBar_Settings *crToolBarSettings;


  bool ignore_automated_get_away;
			
  QString IgnoreThisUpdate;
  int xSize;
  int ySize;

  int chatWindowXSize;
  int chatWindowYSize;
  int chatWindowSplitterHeight;

  int chatRoomXSize;
  int chatRoomYSize;
  int chatRoomSplitterHeight;
  int chatRoomSplitter2Width;

	QDict<pounce> pounces;

  // Internal Settings (not to be saved)
  QString Version;
  QString ReleaseDate;
  QString Language;
};

/**
  *@author Benjamin Meyer
  */

class setup {
	
  public:
    setup();
    ~setup();
		static setup *instance();
		static settings_t *settings();
				
    void save();
    void read();
    void removeGroup(QString group);
    void resetDefaults();
		void savePounces(const QString &user, const QDict<pounce> &list);
		QDict<pounce> readPounces(const QString &user);

    QString readPassword(const QString &user);
    QString decryptPassword(const QString &cryptedPass);
    QString cryptPassword(const QString &plainPass);
    void savePassword(const QString &user, const QString &password);
    void removePassword(const QString &user);
    QStringList registeredUsers(void);
    bool isRegisteredUser(QString &user);
    QString readProfile(const QString &user);
    void saveProfile(const QString &user, const QString &profile);
    void saveBuddyList(const QString &user, 
	    const TBuddyList *buddyList, 
	    const TBuddyList *permitList, 
	    const TBuddyList *denyList, int permitStatus);
    void parseBuddyList(const QString &user, 
	    TBuddyList *buddyList, 
	    TBuddyList *permitList, 
	    TBuddyList *denyList, int *permitStatus);
    void parseBuddyListFile(const QString &settingsFileXml, 
	    TBuddyList *buddyList, 
	    TBuddyList *permitList, 
	    TBuddyList *denyList, int *permitStatus);
    QString buddyListFileToString(const QString &file);
    QString buddyListToString(const QString &user);
    QString buddyListToString(const TBuddyList *buddyList, 
	    const TBuddyList *permitList, 
	    const TBuddyList *denyList, int permitStatus);
    //XXX: temporary
    void convertOldFilesToNewFiles(void);

  private:
    QString KDEHOMEDIR;
    settings_t *i_currentSettings;
};

#endif

// setup.h

