/**************************************************************************
                          				setup.cpp
                             -------------------
    begin                : Thu Feb 17 2000
    copyright            : (C) 2000 by Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "setup.h"
#include "aim.h"
#include <qprogressdialog.h>
#include <qfont.h>
#include <kprocess.h>
#include <stdlib.h>

//The default profile for new users, or users with no profile set yet.
#define DEFAULT_PROFILE "<P>Visit the Kinkatta website at: <A HREF=\"http://kinkatta.sourceforge.net/\">http://kinkatta.sourceforge.net/</A>.</P>"

#define KINKATTA_DIR (KDEHOMEDIR +  "/share/apps/kinkatta/").latin1()
#define QT_KINKATTA_DIR "/.kaim"

setup *__instance = 0;

/***************************************************************************
 * Instance.  This is a static method that returns the current reference to
 * setup.  This is so we can avoid creating/deleting setup's all over the
 * place, and we dont need static methods to do simple things.
 ***************************************************************************/
setup *setup::instance(void){
  if( !__instance )
    __instance = new setup();
  return __instance;
}

/***************************************************************************
 * This is just a shortcut from having to write
 * setup::instance()->i_currentSettings every time
 ***************************************************************************/
settings_t *setup::settings(void){
  return setup::instance()->i_currentSettings;
}

/***************************************************************************
 * Constructor
 ***************************************************************************/
setup::setup(){
  KDEHOMEDIR = getenv("KDEHOME");
  if (KDEHOMEDIR.length() == 0)
    KDEHOMEDIR = QDir::homeDirPath() + "/.kde/";

  i_currentSettings = new settings_t;
  
  // Set up basic defaults
  i_currentSettings->Version = "Version 1.00";
  i_currentSettings->ReleaseDate = "10/29/01";

  i_currentSettings->chatSettings = new chat_Settings;
  i_currentSettings->chatColorSettings = new chat_Color_Settings;
  i_currentSettings->chatFontSettings = new chat_Font_Settings;
  i_currentSettings->buddylistFontSettings = new buddylist_Font_Settings;
  i_currentSettings->chatSoundSettings = new chat_Sound_Settings;
  i_currentSettings->chatToolBarSettings = new chat_ToolBar_Settings;
  i_currentSettings->imToolBarSettings = new im_ToolBar_Settings;

  i_currentSettings->chatRoomToolBarSettings = new chat_ToolBar_Settings;
  i_currentSettings->crToolBarSettings = new room_ToolBar_Settings;

  i_currentSettings->mapAwayMessages = new QMap<QString, QString>;
}

/***************************************************************************
 * Deconstructor
 ***************************************************************************/
setup::~setup(){
  delete i_currentSettings->chatSettings;
  delete i_currentSettings->chatColorSettings;
  delete i_currentSettings->buddylistFontSettings;
  delete i_currentSettings->chatFontSettings;
  delete i_currentSettings->chatSoundSettings;
  delete i_currentSettings->chatToolBarSettings;
  delete i_currentSettings->imToolBarSettings;
  delete i_currentSettings->mapAwayMessages;
  delete i_currentSettings->chatRoomToolBarSettings;
  delete i_currentSettings->crToolBarSettings;

  delete i_currentSettings;
}

/***************************************************************************
 * Returns a list of all the registered users of kinkatta. By this, it means all
 * users that have a settings file under ~/.kde/share/apps/kinkatta/
 ***************************************************************************/
QStringList setup::registeredUsers(){
	QString buddy = "";
	QString extension = "";
	QFileInfo fileInfo;
	QStringList l;

	QString homeDirr = KINKATTA_DIR;
	if(!QFile::exists(homeDirr)) {
		return l; //no registered users, return empty StringList
	}

  QDir home(homeDirr);
  home.setFilter( QDir::Files | QDir::NoSymLinks );

  if ( home.exists() ){
   for (unsigned int i = 0; i < home.count(); i++){
			fileInfo.setFile(home[i]);
      buddy = fileInfo.baseName().lower();
			extension = fileInfo.extension( FALSE );
      if ( (extension == "xml") && buddy != "settings"){ //settings.xml is the global settings file
				if(l.contains(buddy) == 0)  //make them unique
					l.append(buddy);
      }
    }
  }
	return l;
}

/***************************************************************************
 * Returns whether or not the passed user has used kinkatta before (ie, if he is
 * in the list returned by setup::registeredUsers())
 ***************************************************************************/
bool setup::isRegisteredUser(QString &user){
	if( setup::registeredUsers().contains(user) != 0)
		return TRUE; //has used kinkatta, is registered
	else
		return FALSE; //has not used kinkatta, is not registered
}

/***************************************************************************
 * Save the settings to the file
 ***************************************************************************/
void setup::save(){
  // Gets Window Placement
  // int winX = this->x();
  // int winY = this->y();
	//qDebug("::save() i_currentSettings->login_name %s\n", i_currentSettings->login_name.latin1());
	/*
  if (i_currentSettings->login_name == QString("<new user>"))
    return;
	*/

	QString kinkattaDirStr = KINKATTA_DIR;
  QString settingsFile = kinkattaDirStr + "settings"; //the old settings file

  QString settingsFileXml =  kinkattaDirStr + "settings.xml";

	//first we remove the settings.xml file.  this is so that old/unused settings
	//from things we are not using anymore do not get parsed by
	//Preferences::readData() (which is called from Preferences::Preferences()).
	//Our format does not change too often now, but sometimes it does, so it does
	//not hurt.
	QFile::remove(settingsFileXml);

	Preferences prefs(settingsFileXml, QString("kinkatta prefs"), QString("1.0"));
	prefs.setGroup("sound");
	prefs.setNumber("SoundMode", i_currentSettings->SoundMode);
	prefs.setBool("sound_enable_login", i_currentSettings->sound_enable_login);
	prefs.setBool("sound_enable_logout", i_currentSettings->sound_enable_logout);
	prefs.setString("sound_file_command", i_currentSettings->sound_file_command);
	prefs.setString("sound_file_login", i_currentSettings->sound_file_login);
	prefs.setString("sound_file_logout", i_currentSettings->sound_file_logout);

	prefs.setGroup("network");
	prefs.setString("login_server_toc", i_currentSettings->login_server_toc );
	prefs.setString("login_server_login", i_currentSettings->login_server_login);
	prefs.setString("login_port_toc", i_currentSettings->login_port_toc);
	prefs.setString("login_port_login", i_currentSettings->login_port_login );
	prefs.setBool("login_enable_auto", i_currentSettings->login_enable_auto);
	prefs.setString("login_name", i_currentSettings->login_name );
	prefs.setNumber("proxy_Choice", i_currentSettings->proxy_Choice);
	prefs.setString("proxy_server" , i_currentSettings->proxy_server );
	prefs.setString("proxy_port" , i_currentSettings->proxy_port );

	prefs.setGroup("away");

	prefs.setBool("away_comeBackOnlyOnBackClick", i_currentSettings->away_comeBackOnlyOnBackClick );
	prefs.setBool("away_disable_sound", i_currentSettings->away_disable_sound );
	prefs.setBool("away_enable_auto", i_currentSettings->away_enable_auto );
	prefs.setNumber("away_auto_delay_minutes", i_currentSettings->away_auto_delay_minutes);
	prefs.setString("away_auto_default_message", i_currentSettings->away_auto_default_message);
	prefs.setBool("ignore_automated_get_away", i_currentSettings->ignore_automated_get_away );

	prefs.setGroup("general");
	prefs.setBool("main_resizeHeight", i_currentSettings->main_resizeHeight);
	prefs.setNumber("main_resizeHeightMax", i_currentSettings->main_resizeHeightMax);
	prefs.setNumber("main_resizeHeightMin", i_currentSettings->main_resizeHeightMin);
	prefs.setBool("main_resizeWidth", i_currentSettings->main_resizeWidth);
	prefs.setNumber("main_resizeWidthMax", i_currentSettings->main_resizeWidthMax);
	prefs.setNumber("main_resizeWidthMin", i_currentSettings->main_resizeWidthMin);
	prefs.setBool("main_loginMoveRight", i_currentSettings->main_loginMoveRight);
	prefs.setBool("main_loginMoveLeft", i_currentSettings->main_loginMoveLeft);
	prefs.setBool("main_loginMoveNo", i_currentSettings->main_loginMoveNo);
	prefs.setBool("main_showIdle", i_currentSettings->main_showIdle);
	prefs.setString("main_browser", i_currentSettings->main_browser);
	prefs.setBool("main_showLastOn", i_currentSettings->main_showLastOn);
	prefs.setBool("main_noIcons", i_currentSettings->main_noIcons);
	prefs.setNumber("main_moveDown", i_currentSettings->main_moveDown);
	prefs.setNumber("main_idleLayout", i_currentSettings->main_idleLayout);
	prefs.setBool("main_noHeader", i_currentSettings->main_noHeader);
	prefs.setBool("main_useX11ForIdle", i_currentSettings->main_useX11ForIdle);
	prefs.setBool("main_mute_on_login", i_currentSettings->main_mute_on_login);
	prefs.setBool("main_log_on_off", i_currentSettings->main_log_on_off);

	prefs.setNumber("xSize", i_currentSettings->xSize);
	prefs.setNumber("ySize", i_currentSettings->ySize);

	prefs.setNumber("chatWindowXSize", i_currentSettings->chatWindowXSize );
	prefs.setNumber("chatWindowYSize", i_currentSettings->chatWindowYSize );
  prefs.setNumber("chatWindowSplitterHeight", i_currentSettings->chatWindowSplitterHeight );

  prefs.setNumber("chatRoomXSize", i_currentSettings->chatRoomXSize );
	prefs.setNumber("chatRoomYSize", i_currentSettings->chatRoomYSize );
  prefs.setNumber("chatRoomSplitterHeight", i_currentSettings->chatRoomSplitterHeight );
  prefs.setNumber("chatRoomSplitter2Width", i_currentSettings->chatRoomSplitter2Width );

	prefs.setGroup("chat");
	prefs.setBool("chat_raise_window", i_currentSettings->chatSettings->chat_raise_window);
	prefs.setBool("chat_flash_on_new_message", i_currentSettings->chatSettings->chat_flash_on_new_message );
	prefs.setBool("chat_log", i_currentSettings->chatSettings->chat_log );
	prefs.setBool("chat_log_inHtml", i_currentSettings->chatSettings->chat_log_inHtml);
	prefs.setBool("chat_show_time", i_currentSettings->chatSettings->chat_show_time );
	prefs.setBool("chat_log_time", i_currentSettings->chatSettings->chat_log_time);
	prefs.setBool("chat_return_send", i_currentSettings->chatSettings->chat_return_send);
	prefs.setBool("chat_sreturn_send", i_currentSettings->chatSettings->chat_sreturn_send);
	prefs.setBool("chat_send_blank", i_currentSettings->chatSettings->chat_send_blank);
	prefs.setBool("chat_ignore_buddyhtml", i_currentSettings->chatSettings->chat_ignore_buddyhtml);
	prefs.setBool("chat_show_smilies", i_currentSettings->chatSettings->chat_show_smilies);
	prefs.setBool("chat_line_limit", i_currentSettings->chatSettings->chat_line_limit);
	prefs.setNumber("chat_line_limit_number", i_currentSettings->chatSettings->chat_line_limit_number);
	prefs.setBool("chat_log_singleFile", i_currentSettings->chatSettings->chat_log_singleFile);
	prefs.setBool("chat_crypt", i_currentSettings->chatSettings->chat_crypt);

	// Chat Room Toolbar
	prefs.setBool("room_view_text", i_currentSettings->chatRoomToolBarSettings->view_text);
	prefs.setBool("room_view_chat", i_currentSettings->chatRoomToolBarSettings->view_chat);
	prefs.setNumber("room_loc_text", i_currentSettings->chatRoomToolBarSettings->loc_text);
	prefs.setNumber("room_loc_chat" , i_currentSettings->chatRoomToolBarSettings->loc_chat);
	prefs.setBool("room_text_bold", (i_currentSettings->chatRoomToolBarSettings->text_bold));
	prefs.setBool("room_text_italic", (i_currentSettings->chatRoomToolBarSettings->text_italic) );
	prefs.setBool("room_text_underline", (i_currentSettings->chatRoomToolBarSettings->text_underline) );
	prefs.setBool("room_text_fontdown", (i_currentSettings->chatRoomToolBarSettings->text_fontdown) );
	prefs.setBool("room_text_fontnormal", (i_currentSettings->chatRoomToolBarSettings->text_fontnormal) ) ;
	prefs.setBool("room_text_fontbig", (i_currentSettings->chatRoomToolBarSettings->text_fontbig) );
	prefs.setBool("room_text_bgcolor", (i_currentSettings->chatRoomToolBarSettings->text_bgcolor) );
	prefs.setBool("room_text_pencolor", (i_currentSettings->chatRoomToolBarSettings->text_pencolor) );
	prefs.setBool("room_text_link", (i_currentSettings->chatRoomToolBarSettings->text_link) );
	prefs.setBool("room_text_smiley", (i_currentSettings->chatRoomToolBarSettings->text_smiley) );
	prefs.setBool("room_chat_clear", (i_currentSettings->chatRoomToolBarSettings->chat_clear) );
	prefs.setBool("room_chat_save", (i_currentSettings->chatRoomToolBarSettings->chat_save) );
	prefs.setBool("room_chat_print", (i_currentSettings->chatRoomToolBarSettings->chat_print) );
	prefs.setBool("room_chat_time", (i_currentSettings->chatRoomToolBarSettings->chat_time) );
	prefs.setBool("room_chat_log", (i_currentSettings->chatRoomToolBarSettings->chat_log) );
	prefs.setBool("room_chat_sound", (i_currentSettings->chatRoomToolBarSettings->chat_sound) );
	prefs.setBool("room_chat_invite", (i_currentSettings->crToolBarSettings->room_invite) );
	prefs.setBool("room_chat_send", (i_currentSettings->chatRoomToolBarSettings->chat_send) );

  // Chat Toolbar
  prefs.setBool("singleChat_view_text", i_currentSettings->chatToolBarSettings->view_text);
	prefs.setBool("singleChat_view_chat", i_currentSettings->chatToolBarSettings->view_chat);
	prefs.setNumber("singleChat_loc_text", i_currentSettings->chatToolBarSettings->loc_text);
	prefs.setNumber("singleChat_loc_chat" , i_currentSettings->chatToolBarSettings->loc_chat);
	prefs.setBool("singleChat_text_bold", (i_currentSettings->chatToolBarSettings->text_bold));
	prefs.setBool("singleChat_text_italic", (i_currentSettings->chatToolBarSettings->text_italic) );
	prefs.setBool("singleChat_text_underline", (i_currentSettings->chatToolBarSettings->text_underline) );
	prefs.setBool("singleChat_text_fontdown", (i_currentSettings->chatToolBarSettings->text_fontdown) );
	prefs.setBool("singleChat_text_fontnormal", (i_currentSettings->chatToolBarSettings->text_fontnormal) ) ;
	prefs.setBool("singleChat_text_fontbig", (i_currentSettings->chatToolBarSettings->text_fontbig) );
	prefs.setBool("singleChat_text_bgcolor", (i_currentSettings->chatToolBarSettings->text_bgcolor) );
	prefs.setBool("singleChat_text_pencolor", (i_currentSettings->chatToolBarSettings->text_pencolor) );
	prefs.setBool("singleChat_text_link", (i_currentSettings->chatToolBarSettings->text_link) );
	prefs.setBool("singleChat_text_smiley", (i_currentSettings->chatToolBarSettings->text_smiley) );
	prefs.setBool("singleChat_chat_clear", (i_currentSettings->chatToolBarSettings->chat_clear) );
	prefs.setBool("singleChat_chat_save", (i_currentSettings->chatToolBarSettings->chat_save) );
	prefs.setBool("singleChat_chat_print", (i_currentSettings->chatToolBarSettings->chat_print) );
	prefs.setBool("singleChat_chat_time", (i_currentSettings->chatToolBarSettings->chat_time) );
	prefs.setBool("singleChat_chat_log", (i_currentSettings->chatToolBarSettings->chat_log) );
	prefs.setBool("singleChat_chat_sound", (i_currentSettings->chatToolBarSettings->chat_sound) );

  prefs.setBool("chat_remove", (i_currentSettings->imToolBarSettings->chat_remove) );
	prefs.setBool("chat_warn", (i_currentSettings->imToolBarSettings->chat_warn) );
	prefs.setBool("chat_block", (i_currentSettings->imToolBarSettings->chat_block) );
	prefs.setBool("chat_info", (i_currentSettings->imToolBarSettings->chat_info) );
	prefs.setBool("chat_pounce", (i_currentSettings->imToolBarSettings->chat_pounce) );
	prefs.setBool("singleChat_chat_send", (i_currentSettings->chatToolBarSettings->chat_send) );


  prefs.setNumber("chat_yourText_color.R" , i_currentSettings->chatColorSettings->chat_yourText_color.red());
  prefs.setNumber("chat_yourText_color.G" , i_currentSettings->chatColorSettings->chat_yourText_color.green());
  prefs.setNumber("chat_yourText_color.B" , i_currentSettings->chatColorSettings->chat_yourText_color.blue());
  prefs.setNumber("chat_yourName_color.R", i_currentSettings->chatColorSettings->chat_yourName_color.red());
  prefs.setNumber("chat_yourName_color.G", i_currentSettings->chatColorSettings->chat_yourName_color.green());
  prefs.setNumber("chat_yourName_color.B", i_currentSettings->chatColorSettings->chat_yourName_color.blue());

  prefs.setNumber("chat_buddyText_color.R", i_currentSettings->chatColorSettings->chat_buddyText_color.red());
  prefs.setNumber("chat_buddyText_color.G", i_currentSettings->chatColorSettings->chat_buddyText_color.green());
  prefs.setNumber("chat_buddyText_color.B", i_currentSettings->chatColorSettings->chat_buddyText_color.blue());

  prefs.setNumber("chat_buddyName_color.R", i_currentSettings->chatColorSettings->chat_buddyName_color.red());
  prefs.setNumber("chat_buddyName_color.G", i_currentSettings->chatColorSettings->chat_buddyName_color.green());
  prefs.setNumber("chat_buddyName_color.B", i_currentSettings->chatColorSettings->chat_buddyName_color.blue());

  prefs.setNumber("chat_buddyBg_color.R", i_currentSettings->chatColorSettings->chat_buddybg_color.red());
  prefs.setNumber("chat_buddyBg_color.G", i_currentSettings->chatColorSettings->chat_buddybg_color.green());
  prefs.setNumber("chat_buddyBg_color.B", i_currentSettings->chatColorSettings->chat_buddybg_color.blue());

  prefs.setNumber("chat_yourBg_color.R", i_currentSettings->chatColorSettings->chat_yourbg_color.red());
  prefs.setNumber("chat_yourBg_color.G", i_currentSettings->chatColorSettings->chat_yourbg_color.green());
  prefs.setNumber("chat_yourBg_color.B", i_currentSettings->chatColorSettings->chat_yourbg_color.blue());

	prefs.setFont("chat_yourFont", i_currentSettings->chatFontSettings->chat_yourFont);

	prefs.setFont("chat_buddyFont", i_currentSettings->chatFontSettings->chat_buddyFont);

	prefs.setFont("buddylist_OnlineFont", i_currentSettings->buddylistFontSettings->buddylist_OnlineFont);

	prefs.setFont("buddylist_OfflineFont", i_currentSettings->buddylistFontSettings->buddylist_OfflineFont);

	prefs.setFont("buddylist_SignOnFont", i_currentSettings->buddylistFontSettings->buddylist_SignOnFont);

	prefs.setBool("chat_sound_enable", i_currentSettings->chatSoundSettings->chat_sound);
	prefs.setBool("chat_sound_beepInitial", i_currentSettings->chatSoundSettings->chat_sound_beepInitial);
	prefs.setBool("chat_sound_beepReceive", i_currentSettings->chatSoundSettings->chat_sound_beepReceive);
	prefs.setBool("chat_sound_beepSend", i_currentSettings->chatSoundSettings->chat_sound_beepSend);
	prefs.setBool("chat_sound_playFile", i_currentSettings->chatSoundSettings->chat_sound_playFile );
	prefs.setString("chat_sound_fileSend" ,i_currentSettings->chatSoundSettings->chat_sound_fileSend);
	prefs.setString("chat_sound_fileReceive" ,i_currentSettings->chatSoundSettings->chat_sound_fileReceive);
	prefs.setString("chat_sound_fileInitial" , i_currentSettings->chatSoundSettings->chat_sound_fileInitial);
	prefs.setString("IgnoreThisUpdate", i_currentSettings->IgnoreThisUpdate);

	prefs.setGroup("away list");
	QMap <QString,QString>::Iterator it;
	int i = 1;
	for(i = 1; i <= prefs.getNumber("away_message_count"); i++){
		prefs.removeKey(QString("away_message_%1").arg(i));
		//prefs.removeKey(QString("away_message_text%1").arg(i));
	}
	for(i = 1, it = i_currentSettings->mapAwayMessages->begin();
				it != i_currentSettings->mapAwayMessages->end(); ++it, ++i){
		prefs.setString(QString("away_message_%1").arg(i), it.key());
		prefs.setAttr1(QString("away_message_%1").arg(i), it.data());
		//prefs.setString(QString("away_message_text%1").arg(i), it.latin1());
	}
	prefs.setNumber("away_message_count", i-1); //i-1 because of the last ++i
	prefs.flush();

}

/******************************************************************************
 * Returns a string (in "config" format) of the passed user's buddy list
 * (in other words, converts the xml buddy list to config format)
 * this is only a helper function for the below function
 ******************************************************************************/
QString setup::buddyListFileToString(const QString &file){
  if (file.isEmpty())
		return QString("");

	TBuddyList buddyList, permitList, denyList;
	int status;

	parseBuddyListFile(file, &buddyList, &permitList, &denyList, &status);

	return buddyListToString(&buddyList, &permitList, &denyList, status);

}

/******************************************************************************
 * Returns a string (in "config" format) of the passed user's buddy list
 * (in other words, converts the xml buddy list to config format)
 * this is only a helper function for the below function
 ******************************************************************************/
QString setup::buddyListToString(const QString &user){
  if (user.isEmpty() || user == QString("<new user>"))
		return QString("");

	TBuddyList buddyList, permitList, denyList;
	int status;

	parseBuddyList(user, &buddyList, &permitList, &denyList, &status);

	return buddyListToString(&buddyList, &permitList, &denyList, status);

}

/******************************************************************************
 * Returns a string (in "config" format) of the passed user's buddy list
 * (in other words, converts the xml buddy list to config format)
 ******************************************************************************/
QString setup::buddyListToString(const TBuddyList *buddyList, const TBuddyList *permitList, const TBuddyList *denyList, int permitStatus){
  QString data;
  data.sprintf("m %1i\n", permitStatus);

  int i = -1;

  for (int group =0; group < buddyList->getCountGroup(); group++){
    data += "g " + buddyList->getNameGroup(group) + "\n";

   // int currentGroup = buddyList->getGroup(group);
    i = -1;
    while(++i < buddyList->getCount()){
      if(group == buddyList->getGroup(i))
         data += "b " + buddyList->getName(i) + ":" + buddyList->getAlias(i) + "\n";
      }
    }


  i = -1;
  while(++i < permitList->getCount())
  {
    data += "p " + permitList->getName(i) + "\n";
  }
  i = -1;
  while(++i < denyList->getCount())
  {
    data += "d " + denyList->getName(i) + "\n";
  }

	//qDebug("config :%s\n", data.latin1());
	return data;

}

/******************************************************************************
 * Saves the config
 ******************************************************************************/
void setup::saveBuddyList(const QString &user, const TBuddyList *buddyList, const TBuddyList *permitList, const TBuddyList *denyList, int permitStatus){
  if (user.isEmpty() || user == QString("<new user>"))
    return;

  QString settingsFileXml = KINKATTA_DIR;
  settingsFileXml += user.lower();
  settingsFileXml += ".xml";

	TBuddy buddy;
	Preferences prefs(settingsFileXml, QString("kinkatta user prefs"), QString("1.0"));
	prefs.setGroup("buddy list");

	prefs.setNumber( "permit status", permitStatus );
	int buddyCount = 0;
	int group = 0;

	//first reset the list to remove any deleted options
	for(int i =1; i <= prefs.getNumber("group_count"); i++){
		prefs.removeKey( QString("group_%1").arg(i) );
	}
	//first reset the list to remove any deleted options
	for(int i =1; i <= prefs.getNumber("buddy_count"); i++){
		prefs.removeKey( QString("buddy_%1").arg(i) );
	}

	group = buddyCount = 0;

	for (group =0; group < buddyList->getCountGroup(); group++){
		prefs.setString( QString("group_%1").arg(group + 1),
					buddyList->getNameGroup(group));

		for(int i = 0; i < buddyList->getCount(); i++){
			if(group == buddyList->getGroup(i)){
				buddyCount++;
				prefs.setString( QString("buddy_%1").arg(buddyCount), buddyList->getName(i) );
				prefs.setAttr1( QString("buddy_%1").arg(buddyCount), buddyList->getNameGroup(group) );
				prefs.setAttr2( QString("buddy_%1").arg(buddyCount), "buddy" );
				if( !buddyList->getAlias(i).isEmpty() )
					prefs.setAttr3( QString("buddy_%1").arg(buddyCount), buddyList->getAlias(i) );
			}
		}
	}
	prefs.setNumber( "group_count", group );

	buddyCount++; //fixes an offset problem
	for(int i = 0; i < permitList->getCount(); i++, buddyCount++){
		prefs.setString( QString("buddy_%1").arg(buddyCount), permitList->getName(i) );
		//prefs.setAttr1( QString("buddy_%1").arg(buddyCount), permitList->getNameGroup(group) );
		prefs.setAttr2( QString("buddy_%1").arg(buddyCount), "permit" );
	}

	for(int i = 0; i < denyList->getCount(); i++, buddyCount++){
		prefs.setString( QString("buddy_%1").arg(buddyCount), denyList->getName(i) );
		//prefs.setAttr1( QString("buddy_%1").arg(buddyCount), denyList->getNameGroup(group) );
		prefs.setAttr2( QString("buddy_%1").arg(buddyCount), "deny" );
	}

	prefs.setNumber("buddy_count", buddyCount-1);//-1 for the offset problem

	prefs.flush();
}

/******************************************************************************
 * Reads the buddylist (helper function for below)
 ******************************************************************************/
void setup::parseBuddyList(const QString &user, TBuddyList *buddyList, TBuddyList *permitList, TBuddyList *denyList, int *permitStatus){
  if (user.isEmpty() || user == QString("<new user>"))
		return;

  QString settingsFileXml = KINKATTA_DIR;
  settingsFileXml += user.lower();
  settingsFileXml += ".xml";

	return parseBuddyListFile(settingsFileXml, buddyList, permitList, denyList, permitStatus);

}

/******************************************************************************
 * Reads the buddylist
 ******************************************************************************/
void setup::parseBuddyListFile(const QString &settingsFileXml, TBuddyList *buddyList, TBuddyList *permitList, TBuddyList *denyList, int *permitStatus){
	if( !QFile::exists(settingsFileXml) ){
		buddyList->addGroup("Buddies"); //default group, if there are none
		(*permitStatus) = 1;
		return;
	}

	TBuddy buddy;
	Preferences prefs(settingsFileXml, QString("kinkatta user prefs"), QString("1.0"));

	prefs.setGroup("buddy list");
	*permitStatus = prefs.getNumber("permit status", 1); //default to 1!  important!
	//qDebug(" %s defaulting to %d\n", user.latin1(), *permitStatus);

	for(int g = 1; g <= prefs.getNumber("group_count"); g++){
		QString groupStr = prefs.getString( QString("group_%1").arg(g) );
		int groupNumber = buddyList->addGroup( groupStr );
		if (groupNumber == -1)
			groupNumber = buddyList->getNumGroup(groupStr);
		for(int i = 1; i <= prefs.getNumber("buddy_count"); i++){
			buddy.status = TAIM_OFFLINE;
			buddy.lastOn = 0;
			buddy.name = prefs.getString( QString("buddy_%1").arg(i) );
			QString alias = prefs.getAttr3( QString("buddy_%1").arg(i),buddy.name );
			if( !alias.isEmpty() )
				buddy.alias = alias;

			// Easter Egg Developer names get put to their real names.
      if ( buddy.name.lower() == QString("icefox2") ){
				if (buddy.name == buddy.alias){
				  buddy.alias = "Ben Meyer";
				}
			}
      if ( buddy.name.lower() == QString("remo177") ){
				if (buddy.name == buddy.alias){
				  buddy.alias = "Dimi Shahbaz";
				}
			}
      if ( buddy.name.lower() == QString("jimwinme") ){
				if (buddy.name == buddy.alias){
				  buddy.alias = "Jim Wilson";
				}
			}

			QString type = prefs.getAttr2( QString("buddy_%1").arg(i));
			if( type == "permit" ){
				permitList->add(&buddy);
			} else if (type == "deny" ){
				denyList->add(&buddy);
			} else { // type = "buddy"
				if(prefs.getAttr1( QString("buddy_%1").arg(i) ) == groupStr){
					buddy.group = groupNumber; //prefs.getAttr1( QString("buddy_%1").arg(i) );
					buddyList->add(&buddy);
				}
			}

		}
	}

	if(buddyList->getCountGroup() == 0){
		buddyList->addGroup("Buddies"); //default group, if there are none
	}
}

/***************************************************************************
 * Remove an entire group of settings (ie, "sound")
 ***************************************************************************/
void setup::removeGroup(QString group){
  QString kinkattaDirStr = KINKATTA_DIR;
  QString settingsFileXml = kinkattaDirStr;
  settingsFileXml +=  "settings.xml";
  Preferences prefs(settingsFileXml, QString("kinkatta prefs"), QString("1.0"));
  prefs.setGroup(group);
  prefs.removeGroup();
}

/***************************************************************************
 * Reset the default settings.
 ***************************************************************************/
void setup::resetDefaults(){
  removeGroup("away");
  //removeGroup("away list");
  removeGroup("chat");
  removeGroup("general");
  removeGroup("network");
  removeGroup("sound");

  read();
}

/***************************************************************************
 * Read the settings from the file
 ***************************************************************************/
void setup::read(){
  int i, r, g, b;
  bool convertoldfiles = false;
  //Get File Name
  //qDebug("setup::read() i_currentSettings->login_name %s\n", i_currentSettings->login_name.latin1());

  QString kinkattaDirStr = KINKATTA_DIR;
  QString qtkinkattaDir;
  QDir kinkattaDir(kinkattaDirStr);
  //Make Dir
  bool madeKinkattaDir = false;
  if( !kinkattaDir.exists() ){
  // if no kdeDir and qt dir (~/.kinkatta) exists then copy settings to kdeDir
	qtkinkattaDir = QT_KINKATTA_DIR;
	if(QFile::exists(qtkinkattaDir)) {
		// copy qt settings to kdedir
		KShellProcess *shell = new KShellProcess();
		*shell << "cp";
		*shell << "-r";
		*shell << qtkinkattaDir.latin1();
		*shell << kinkattaDirStr.latin1();
		shell->start( KProcess::Block );
	} else {
	    madeKinkattaDir = true;
	    kinkattaDir.mkdir(kinkattaDirStr, true);
	}
  }

  QString settingsFileXml = kinkattaDirStr;
  settingsFileXml +=  "settings.xml";

	if(!QFile::exists(settingsFileXml)){ //both xml and old prefs files dont exist
		//There is a .kinkatta folder but no xml file, convert
	  //XXX: temporary
	  if (madeKinkattaDir == false){
                        // set flag so conversion can be done after defaults load
                        convertoldfiles = true;
		}
	}
	Preferences prefs(settingsFileXml, QString("kinkatta prefs"), QString("1.0"));

	r = g = b = 0;

	prefs.setGroup("sound");
	i_currentSettings->SoundMode= prefs.getNumber("SoundMode", 1);
	i_currentSettings->sound_enable_login	= prefs.getBool("sound_enable_login", true);
	i_currentSettings->sound_enable_logout= prefs.getBool("sound_enable_logout", false );
	i_currentSettings->sound_file_command= prefs.getString("sound_file_command", "artsplay" );
	i_currentSettings->sound_file_login= prefs.getString("sound_file_login", DATADIR "/sounds/BuddyArrive.au");
	i_currentSettings->sound_file_logout= prefs.getString("sound_file_logout",  DATADIR "/sounds/BuddyLeave.au");

	prefs.setGroup("network");
	i_currentSettings->login_server_toc = prefs.getString("login_server_toc", "toc.oscar.aol.com");
	i_currentSettings->login_server_login= prefs.getString("login_server_login", "login.oscar.aol.com");
	i_currentSettings->login_port_toc= prefs.getString("login_port_toc", "9898");
	i_currentSettings->login_port_login= prefs.getString("login_port_login", "5190");
	i_currentSettings->login_enable_auto= prefs.getBool("login_enable_auto", false);
	i_currentSettings->login_name = prefs.getString("login_name", "<new user>");
	i_currentSettings->proxy_Choice= prefs.getNumber("proxy_Choice", 0);
	i_currentSettings->proxy_server = prefs.getString("proxy_server", "");
	i_currentSettings->proxy_port = prefs.getString("proxy_port", "");

	prefs.setGroup("away");
	i_currentSettings->away_enable_auto= prefs.getBool("away_enable_auto" , false);
	i_currentSettings->away_comeBackOnlyOnBackClick= prefs.getBool("away_comeBackOnlyOnBackClick" , false);
	i_currentSettings->away_disable_sound= prefs.getBool("away_disable_sound" , false);
	i_currentSettings->away_auto_delay_minutes= prefs.getNumber("away_auto_delay_minutes", 30);
	i_currentSettings->away_auto_default_message= prefs.getString("away_auto_default_message", "Away");
	i_currentSettings->ignore_automated_get_away= prefs.getBool("ignore_automated_get_away", true);

	prefs.setGroup("general");
	i_currentSettings->main_resizeHeight= prefs.getBool("main_resizeHeight", false);
	i_currentSettings->main_resizeHeightMax= prefs.getNumber("main_resizeHeightMax", 600);
	i_currentSettings->main_resizeHeightMin= prefs.getNumber("main_resizeHeightMin", 200);
	i_currentSettings->main_resizeWidth= prefs.getBool("main_resizeWidth", true);
	i_currentSettings->main_resizeWidthMax= prefs.getNumber("main_resizeWidthMax", 300);
	i_currentSettings->main_resizeWidthMin= prefs.getNumber("main_resizeWidthMin", 50);
	i_currentSettings->main_loginMoveRight= prefs.getBool("main_loginMoveRight", false);
	i_currentSettings->main_loginMoveLeft= prefs.getBool("main_loginMoveLeft", false);
	i_currentSettings->main_loginMoveNo	= prefs.getBool("main_loginMoveNo", true);
	i_currentSettings->main_showIdle= prefs.getBool("main_showIdle", true);
	i_currentSettings->main_browser = prefs.getString("main_browser", "netscape");
	i_currentSettings->main_showLastOn= prefs.getBool("main_showLastOn", false);
	i_currentSettings->main_noIcons= prefs.getBool("main_noIcons", false);
	i_currentSettings->main_moveDown= prefs.getNumber("main_moveDown", 0);
	i_currentSettings->main_idleLayout= prefs.getNumber("main_idleLayout", 0);
	i_currentSettings->main_noHeader= prefs.getBool("main_noHeader", false);
	i_currentSettings->main_useX11ForIdle= prefs.getBool("main_useX11ForIdle", false );
	i_currentSettings->main_mute_on_login= prefs.getBool("main_mute_on_login", true );
	i_currentSettings->main_log_on_off= prefs.getBool("main_log_on_off", false );

	i_currentSettings->xSize= prefs.getNumber("xSize", -1);
	i_currentSettings->ySize= prefs.getNumber("ySize", -1);

	i_currentSettings->chatWindowXSize= prefs.getNumber("chatWindowXSize", 335);
        if (i_currentSettings->chatWindowXSize == 330) {
		/* convert old default to 335 so large toolbar buttons fit */
		i_currentSettings->chatWindowXSize = 335;
	}
	i_currentSettings->chatWindowYSize= prefs.getNumber("chatWindowYSize", 330);
	i_currentSettings->chatWindowSplitterHeight= prefs.getNumber("chatWindowSplitterHeight", 40);

	i_currentSettings->chatRoomXSize= prefs.getNumber("chatRoomXSize", 447);
	i_currentSettings->chatRoomYSize= prefs.getNumber("chatRoomYSize", 330);
	i_currentSettings->chatRoomSplitterHeight= prefs.getNumber("chatRoomSplitterHeight", 40);
	i_currentSettings->chatRoomSplitter2Width= prefs.getNumber("chatRoomSplitter2Width", 40);

	prefs.setGroup("chat");
	i_currentSettings->chatSettings->chat_raise_window= prefs.getBool("chat_raise_window", true);
	i_currentSettings->chatSettings->chat_flash_on_new_message = prefs.getBool("chat_flash_on_new_message", true);
	i_currentSettings->chatSettings->chat_log = prefs.getBool("chat_log", true);
	i_currentSettings->chatSettings->chat_log_inHtml= prefs.getBool("chat_log_inHtml", true);
	i_currentSettings->chatSettings->chat_show_time = prefs.getBool("chat_show_time", true);
	i_currentSettings->chatSettings->chat_log_time= prefs.getBool("chat_log_time", true);
	i_currentSettings->chatSettings->chat_return_send= prefs.getBool("chat_return_send", true);
	i_currentSettings->chatSettings->chat_sreturn_send= prefs.getBool("chat_sreturn_send", false);
	i_currentSettings->chatSettings->chat_send_blank= prefs.getBool("chat_send_blank", false);
	i_currentSettings->chatSettings->chat_ignore_buddyhtml= prefs.getBool("chat_ignore_buddyhtml", false);
	i_currentSettings->chatSettings->chat_show_smilies= prefs.getBool("chat_show_smilies", true);
	i_currentSettings->chatSettings->chat_line_limit= prefs.getBool("chat_line_limit", false);
	i_currentSettings->chatSettings->chat_line_limit_number= prefs.getNumber("chat_line_limit_number",200 );
	i_currentSettings->chatSettings->chat_log_singleFile= prefs.getBool("chat_log_singleFile", false);
	i_currentSettings->chatSettings->chat_crypt= prefs.getBool("chat_crypt", false);

	i_currentSettings->chatToolBarSettings->view_text= prefs.getBool("singleChat_view_text", true);
	i_currentSettings->chatToolBarSettings->view_chat= prefs.getBool("singleChat_view_chat", true);
	i_currentSettings->chatToolBarSettings->loc_text= prefs.getNumber("singleChat_loc_text", 0);
	i_currentSettings->chatToolBarSettings->loc_chat= prefs.getNumber("singleChat_loc_chat", 0);
	i_currentSettings->chatToolBarSettings->text_bold= prefs.getBool("singleChat_text_bold", true);
	i_currentSettings->chatToolBarSettings->text_italic = prefs.getBool("singleChat_text_italic", true);
	i_currentSettings->chatToolBarSettings->text_underline = prefs.getBool("singleChat_text_underline", true);
	i_currentSettings->chatToolBarSettings->text_fontdown = prefs.getBool("singleChat_text_fontdown", true);
	i_currentSettings->chatToolBarSettings->text_fontnormal= prefs.getBool("singleChat_text_fontnormal", true) ;
	i_currentSettings->chatToolBarSettings->text_fontbig= prefs.getBool("singleChat_text_fontbig", true);
	i_currentSettings->chatToolBarSettings->text_bgcolor= prefs.getBool("singleChat_text_bgcolor", true);
	i_currentSettings->chatToolBarSettings->text_pencolor= prefs.getBool("singleChat_text_pencolor", true);
	i_currentSettings->chatToolBarSettings->text_link= prefs.getBool("singleChat_text_link", true);
	i_currentSettings->chatToolBarSettings->text_smiley= prefs.getBool("singleChat_text_smiley", true);
	i_currentSettings->chatToolBarSettings->chat_clear= prefs.getBool("singleChat_chat_clear", true);
	i_currentSettings->chatToolBarSettings->chat_save= prefs.getBool("singleChat_chat_save", true);
	i_currentSettings->chatToolBarSettings->chat_print= prefs.getBool("singleChat_chat_print", false);
	i_currentSettings->chatToolBarSettings->chat_time= prefs.getBool("singleChat_chat_time", true);
	i_currentSettings->chatToolBarSettings->chat_log= prefs.getBool("singleChat_chat_log", true);
	i_currentSettings->chatToolBarSettings->chat_sound= prefs.getBool("singleChat_chat_sound", true);

        i_currentSettings->imToolBarSettings->chat_remove= prefs.getBool("chat_remove", true);
	i_currentSettings->imToolBarSettings->chat_warn= prefs.getBool("chat_warn", false);
	i_currentSettings->imToolBarSettings->chat_block= prefs.getBool("chat_block", true);
	i_currentSettings->imToolBarSettings->chat_pounce= prefs.getBool("chat_pounce", false);
	i_currentSettings->imToolBarSettings->chat_info= prefs.getBool("chat_info", true);
	i_currentSettings->chatToolBarSettings->chat_send= prefs.getBool("singleChat_chat_send", true);

	// ChatRoom Toolbar
	i_currentSettings->chatRoomToolBarSettings->view_text= prefs.getBool("room_view_text", true);
	i_currentSettings->chatRoomToolBarSettings->view_chat= prefs.getBool("room_view_chat", true);
	i_currentSettings->chatRoomToolBarSettings->loc_text= prefs.getNumber("room_loc_text", 0);
	i_currentSettings->chatRoomToolBarSettings->loc_chat= prefs.getNumber("room_loc_chat", 0);

	i_currentSettings->chatRoomToolBarSettings->text_bold= prefs.getBool("room_text_bold", true);
	i_currentSettings->chatRoomToolBarSettings->text_italic = prefs.getBool("room_text_italic", true);
	i_currentSettings->chatRoomToolBarSettings->text_underline = prefs.getBool("room_text_underline", true);
	i_currentSettings->chatRoomToolBarSettings->text_fontdown = prefs.getBool("room_text_fontdown", true);
	i_currentSettings->chatRoomToolBarSettings->text_fontnormal= prefs.getBool("room_text_fontnormal", true) ;
	i_currentSettings->chatRoomToolBarSettings->text_fontbig= prefs.getBool("room_text_fontbig", true);
	i_currentSettings->chatRoomToolBarSettings->text_bgcolor= prefs.getBool("room_text_bgcolor", true);
	i_currentSettings->chatRoomToolBarSettings->text_pencolor= prefs.getBool("room_text_pencolor", true);
	i_currentSettings->chatRoomToolBarSettings->text_link= prefs.getBool("room_text_link", true);
	i_currentSettings->chatRoomToolBarSettings->text_smiley= prefs.getBool("room_text_smiley", true);
	i_currentSettings->chatRoomToolBarSettings->chat_clear= prefs.getBool("room_chat_clear", true);
	i_currentSettings->chatRoomToolBarSettings->chat_save= prefs.getBool("room_chat_save", true);
	i_currentSettings->chatRoomToolBarSettings->chat_print= prefs.getBool("room_chat_print", false);
	i_currentSettings->chatRoomToolBarSettings->chat_time= prefs.getBool("room_chat_time", true);
	i_currentSettings->chatRoomToolBarSettings->chat_log= prefs.getBool("room_chat_log", true);
	i_currentSettings->chatRoomToolBarSettings->chat_sound= prefs.getBool("room_chat_sound", true);
	i_currentSettings->crToolBarSettings->room_invite= prefs.getBool("room_chat_invite", true);
	i_currentSettings->chatRoomToolBarSettings->chat_send= prefs.getBool("room_chat_send", true);


	r = prefs.getNumber("chat_yourText_color.R", 0);
  g = prefs.getNumber("chat_yourText_color.G", 0);
  b = prefs.getNumber("chat_yourText_color.B", 0);
	i_currentSettings->chatColorSettings->chat_yourText_color.setRgb(r, g, b);

  r = prefs.getNumber("chat_yourName_color.R", 0);
  g = prefs.getNumber("chat_yourName_color.G", 60);
  b = prefs.getNumber("chat_yourName_color.B", 128);
	i_currentSettings->chatColorSettings->chat_yourName_color.setRgb(r, g, b);

  r = prefs.getNumber("chat_buddyText_color.R", 0);
  g = prefs.getNumber("chat_buddyText_color.G", 0);
  b = prefs.getNumber("chat_buddyText_color.B", 0);
	i_currentSettings->chatColorSettings->chat_buddyText_color.setRgb(r, g, b);

  r = prefs.getNumber("chat_buddyName_color.R", 128);
  g = prefs.getNumber("chat_buddyName_color.G", 0);
  b = prefs.getNumber("chat_buddyName_color.B", 0);
	i_currentSettings->chatColorSettings->chat_buddyName_color.setRgb(r, g, b);

  r = prefs.getNumber("chat_buddyBg_color.R", 255);
  g = prefs.getNumber("chat_buddyBg_color.G", 255);
  b = prefs.getNumber("chat_buddyBg_color.B", 255);
	i_currentSettings->chatColorSettings->chat_buddybg_color.setRgb(r, g, b);

  r = prefs.getNumber("chat_yourBg_color.R", 255);
  g = prefs.getNumber("chat_yourBg_color.G", 255);
  b = prefs.getNumber("chat_yourBg_color.B", 255);
	i_currentSettings->chatColorSettings->chat_yourbg_color.setRgb(r, g, b);

	QFont defaultFont = qApp->font();
	i_currentSettings->buddylistFontSettings->buddylist_OnlineFont=prefs.getFont("buddylist_OnlineFont", defaultFont);

	i_currentSettings->buddylistFontSettings->buddylist_OfflineFont=prefs.getFont("buddylist_OfflineFont", defaultFont);

	i_currentSettings->buddylistFontSettings->buddylist_SignOnFont=prefs.getFont("buddylist_SignOnFont", defaultFont);

	//for chat_*Font, we need the default to be 12 points.
	defaultFont.setPointSize(12);
	i_currentSettings->chatFontSettings->chat_yourFont=prefs.getFont("chat_yourFont", defaultFont);
	i_currentSettings->chatFontSettings->chat_buddyFont=prefs.getFont("chat_buddyFont", defaultFont);


	i_currentSettings->chatSoundSettings->chat_sound= prefs.getBool("chat_sound_enable", true);
	i_currentSettings->chatSoundSettings->chat_sound_beepInitial= prefs.getBool("chat_sound_beepInitial", true);
	i_currentSettings->chatSoundSettings->chat_sound_beepReceive= prefs.getBool("chat_sound_beepReceive", true);
	i_currentSettings->chatSoundSettings->chat_sound_beepSend= prefs.getBool("chat_sound_beepSend", true);
	i_currentSettings->chatSoundSettings->chat_sound_playFile = prefs.getBool("chat_sound_playFile", false);
	i_currentSettings->chatSoundSettings->chat_sound_fileSend= prefs.getString("chat_sound_fileSend", DATADIR "/sounds/Send.au");
	i_currentSettings->chatSoundSettings->chat_sound_fileReceive= prefs.getString("chat_sound_fileReceive", DATADIR "/sounds/Receive.au");
	i_currentSettings->chatSoundSettings->chat_sound_fileInitial= prefs.getString("chat_sound_fileInitial", DATADIR "/sounds/Receive.au");
	i_currentSettings->IgnoreThisUpdate= prefs.getString("IgnoreThisUpdate", i_currentSettings->ReleaseDate);

	prefs.setGroup("away list");
	i_currentSettings->mapAwayMessages->clear();
	for(i = 1; i <= prefs.getNumber("away_message_count"); i++){
	  i_currentSettings->mapAwayMessages->insert(
	    prefs.getString(QString("away_message_%1").arg(i)),
	    prefs.getAttr1(QString("away_message_%1").arg(i)) );
	}
  if (i_currentSettings->mapAwayMessages->count() == 0){
    i_currentSettings->mapAwayMessages->insert("Default Away",
      "I am sorry, but I am away from the computer right now.");

  }
}

void setup::saveProfile(const QString &user, const QString &profile){
	if(user.isEmpty() || user == QString("<new user>"))
		return;

  QString settingsFileXml = KINKATTA_DIR;
  settingsFileXml += user.lower();
  settingsFileXml += ".xml";

	Preferences prefs(settingsFileXml, QString("kinkatta user prefs"), QString("1.0"));

	prefs.setGroup("profile");
	prefs.setCDATA("profile", profile);

	prefs.flush();

}

/*
 * Decrypt a password.  Since the algorithm is circular, this is just a helper
 * function for the below.  It does the same thing.
 */
QString setup::decryptPassword(const QString &cryptedPass){
	return cryptPassword(cryptedPass);
}

QString setup::cryptPassword(const QString &plainPass){
  // The point of this "encryption" is not to accually encrypt the data, but
	// simply to not have the password in plain text
	QString crypted;
	int len = plainPass.length();
  for (int i = 0; i < len; i ++){
    int temp = plainPass[i].latin1();
		//qDebug("'%c' becomes ", temp);
		if( (temp >= 'a') && (temp <= 'm') )
			temp += 13;
		else if ( (temp >= 'A') && (temp <= 'M') )
			temp += 13;
		else if ( (temp >= 'n') && (temp <= 'z') )
			temp -= 13;
		else if ( (temp >= 'N') && (temp <= 'Z') )
			temp -= 13;
		else if ( (temp >= '0') && (temp <= '4') )//temp is a number
			temp += 5;
		else if ( (temp >= '5') && (temp <= '9') )
			temp -= 5;

		//qDebug(" '%c'\n", temp);
		crypted += (char)temp;
 	}

	return crypted;
}


void setup::savePassword(const QString &user, const QString &password){
	if(user.isEmpty() || (user == QString("<new user>")) || password.isEmpty())
		return;

	QString crypted = cryptPassword(password);

  QString settingsFileXml = KINKATTA_DIR;
  settingsFileXml += user.lower();
  settingsFileXml += ".xml";

	Preferences prefs(settingsFileXml, QString("kinkatta user prefs"), QString("1.0"));

	prefs.setGroup("password");
	prefs.setCDATA("password", crypted);

	prefs.flush();
}

/***************************************************************************
 * Save a user's list of pounces.
 ***************************************************************************/
void setup::savePounces(const QString &user, const QDict<pounce> &list){
	if(user.isEmpty() || (user == QString("<new user>")) )
		return;

//	if(list.count() == 0)
//		return;

  QString settingsFileXml = KINKATTA_DIR;
  settingsFileXml += user.lower();
  settingsFileXml += ".xml";

	Preferences prefs(settingsFileXml, QString("kinkatta user prefs"), QString("1.0"));

	prefs.setGroup("pounces");

	//first clear the list so outlying pounces do not get saved if they dont
	//exist.
	int i;
	int pcount = prefs.getNumber("pounce_count", 0);
	if (pcount > 0)
	for(i = 0; i <= pcount; i++){
		prefs.removeKey(QString("pounce_%1").arg(i) + "_buddyName");
		prefs.removeKey(QString("pounce_%1").arg(i) + "_signOn");
		prefs.removeKey(QString("pounce_%1").arg(i) + "_returnAway");
		prefs.removeKey(QString("pounce_%1").arg(i) + "_returnIdle");
		prefs.removeKey(QString("pounce_%1").arg(i) + "_openChat");
		prefs.removeKey(QString("pounce_%1").arg(i) + "_sendMessage");
		prefs.removeKey(QString("pounce_%1").arg(i) + "_message");
		prefs.removeKey(QString("pounce_%1").arg(i) + "_execCommand");
		prefs.removeKey(QString("pounce_%1").arg(i) + "_command");
		prefs.removeKey(QString("pounce_%1").arg(i) + "_doNotRemove");

		prefs.removeKey(QString("pounce_%1").arg(i) + "_hidden");
		prefs.removeKey(QString("pounce_%1").arg(i) + "_signOnSound");
		prefs.removeKey(QString("pounce_%1").arg(i) + "_signOffSound");
	  prefs.removeKey(QString("pounce_%1").arg(i) + "_ignoreSettings");
	}

	QDictIterator<pounce> it(list);
	pounce *p;
	i = 0;
	while( it.current() ){
		p = it.current();
		if (p->doNotRemove == true){
			prefs.setString(QString("pounce_%1").arg(i) + "_buddyName", p->buddyName);
			if (p->signOn == true)
			  prefs.setBool(QString("pounce_%1").arg(i) + "_signOn", p->signOn);
			if (p->returnAway == true)
			  prefs.setBool(QString("pounce_%1").arg(i) + "_returnAway", p->returnAway);
			if (p->returnIdle == true)
			  prefs.setBool(QString("pounce_%1").arg(i) + "_returnIdle", p->returnIdle);
			if (p->openChat == true)
			  prefs.setBool(QString("pounce_%1").arg(i) + "_openChat", p->openChat);
			if (p->sendMessage == true)
			  prefs.setBool(QString("pounce_%1").arg(i) + "_sendMessage", p->sendMessage);
			if ((p->message).length() > 0)
				prefs.setString(QString("pounce_%1").arg(i) + "_message", p->message);
			if (p->execCommand == true)
			  prefs.setBool(QString("pounce_%1").arg(i) + "_execCommand", p->execCommand);
			if ((p->command).length() > 0)
			  prefs.setString(QString("pounce_%1").arg(i) + "_command", p->command);

			if(p->hidden == true){
				prefs.setBool(QString("pounce_%1").arg(i) + "_hidden", p->hidden);
			  prefs.setString(QString("pounce_%1").arg(i) + "_signOnSound", p->signOnSound);
			  prefs.setString(QString("pounce_%1").arg(i) + "_signOffSound", p->signOffSound);
			  if(p->ignoreSettings == true)
				  prefs.setBool(QString("pounce_%1").arg(i) + "_ignoreSettings", p->ignoreSettings);
      }
      i++;
		}
    it += 1;
	}

	prefs.setNumber(QString("pounce_count"), i);

	prefs.flush();

}

/***************************************************************************
 * Returns a list of all the pounces of a user.
 ***************************************************************************/
QDict<pounce> setup::readPounces(const QString &user){
	QDict<pounce> list;
	if(user.isEmpty() || (user == QString("<new user>")) )
		return list;

  QString settingsFileXml = KINKATTA_DIR;
  settingsFileXml += user.lower();
  settingsFileXml += ".xml";

	Preferences prefs(settingsFileXml, QString("kinkatta user prefs"), QString("1.0"));

	prefs.setGroup("pounces");

	pounce *p;
  int count = prefs.getNumber("pounce_count", 0);
	for(int i = 0; i < count; i++){
		p = new pounce;
		p->buddyName = prefs.getString(QString("pounce_%1").arg(i) + "_buddyName", QString(""));
		p->signOn = prefs.getBool(QString("pounce_%1").arg(i) + "_signOn",false);
		p->returnAway = prefs.getBool(QString("pounce_%1").arg(i) + "_returnAway", false);
		p->returnIdle = prefs.getBool(QString("pounce_%1").arg(i) + "_returnIdle", false);
		p->openChat = prefs.getBool(QString("pounce_%1").arg(i) + "_openChat", false);
		p->sendMessage = prefs.getBool(QString("pounce_%1").arg(i) + "_sendMessage", false);
		p->message = prefs.getString(QString("pounce_%1").arg(i) + "_message", QString(""));
		p->execCommand = prefs.getBool(QString("pounce_%1").arg(i) + "_execCommand", false);
		p->command = prefs.getString(QString("pounce_%1").arg(i) + "_command", QString(""));
		p->doNotRemove = true;

		p->hidden = prefs.getBool(QString("pounce_%1").arg(i) + "_hidden", false);
		p->ignoreSettings = prefs.getBool(QString("pounce_%1").arg(i) + "_ignoreSettings", false);
		p->signOnSound = prefs.getString(QString("pounce_%1").arg(i) + "_signOnSound", QString(""));
		p->signOffSound = prefs.getString(QString("pounce_%1").arg(i) + "_signOffSound", QString(""));

		list.insert(p->buddyName, p);
	}
	return list;

}


QString setup::readPassword(const QString &user){
	//qDebug("::readPassword %s\n", user.latin1());

	QString pw;
  QString settingsFileXml = KINKATTA_DIR;
  settingsFileXml += user.lower();
  settingsFileXml += ".xml";

	if(user.isEmpty() || (user == QString("<new user>")) || !QFile::exists(settingsFileXml)){
		//must be a new user
		return QString("");
	}
	Preferences prefs(settingsFileXml, QString("kinkatta user prefs"), QString("1.0"));

	//qDebug("::readPassword settingsFileXml %s\n", settingsFileXml.latin1());

	prefs.setGroup("password");
	pw = prefs.getCDATA("password", QString(""));
	return decryptPassword(pw);
}

void setup::removePassword(const QString &user){
 	//qDebug("::removePassword %s\n", user.latin1());

  QString settingsFileXml = KINKATTA_DIR;
  settingsFileXml += user.lower();
  settingsFileXml += ".xml";

	if(user.isEmpty() || user == QString("<new user>") || !QFile::exists(settingsFileXml)){
		//must be a new or unknown user
		return;
	}
	Preferences prefs(settingsFileXml, QString("kinkatta user prefs"), QString("1.0"));

	//qDebug("::removePassword settingsFileXml %s\n", settingsFileXml.latin1());

	prefs.setGroup("password");
	prefs.setString("password", ""); // this is to make it "dirty"
	prefs.removeKey("password");

	prefs.flush();
}

QString setup::readProfile(const QString &user){
	//qDebug("::readProfile %s\n", user.latin1());
  QString settingsFileXml = KINKATTA_DIR;
  settingsFileXml += user.lower();
  settingsFileXml += ".xml";

	if(user.isEmpty() || (user == QString("<new user>")) || !QFile::exists(settingsFileXml))
		return QString("");

	Preferences prefs(settingsFileXml, QString("kinkatta user prefs"), QString("1.0"));

	//qDebug("setup::readProfile settingsFileXml %s\n", settingsFileXml.latin1());

	prefs.setGroup("profile");
	QString profile = prefs.getCDATA("profile", "default");
	if(profile == "default"){ //must be a new user
		profile = DEFAULT_PROFILE;
	}
	//qDebug("getCDATA %s\n", i_currentSettings->profile.latin1());
	return profile;
}


// setup.cpp















