/***************************************************************************
                           mainwindowoptionsimp.cpp
                             -------------------
    begin                : Tuesday Jan 10 2001
    copyright            : (C) 2001 Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/


#include "mainwindowoptionsimp.h"
#include <qlineedit.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qspinbox.h>

/******************************************************************************
 * Constructor
 ******************************************************************************/
MainWindowOptionsImp::MainWindowOptionsImp(QWidget *parent, const char *name) : MainWindowOptions ( parent,name,false ){
	i_aimSettings = setup::settings();
  resizeWidth->setChecked(true);
  resizeWidth->setChecked(false);
  resizeHeight->setChecked(true);
  resizeHeight->setChecked(false);
}

/******************************************************************************
 * Deconstructor
 ******************************************************************************/
MainWindowOptionsImp::~MainWindowOptionsImp(){
}

/******************************************************************************
 * Copy the settings to the dialogs
 ******************************************************************************/
void MainWindowOptionsImp::updateData(){
  i_aimSettings = setup::settings();

  browser_other->setChecked(true);
  resizeHeight->setChecked(true);
  resizeWidth->setChecked(true);
  loginMoveRight->setChecked(true);

  resizeHeight->setChecked(i_aimSettings->main_resizeHeight);
  resizeHeightMax->setValue(i_aimSettings->main_resizeHeightMax);
  resizeWidth->setChecked(i_aimSettings->main_resizeWidth);
  resizeWidthMax->setValue(i_aimSettings->main_resizeWidthMax);
  if (i_aimSettings->main_loginMoveRight == true)
    loginMoveRight->setChecked(true);
  if (i_aimSettings->main_loginMoveLeft == true)
    loginMoveLeft->setChecked(true);
  if (i_aimSettings->main_loginMoveNo == true)
    loginMoveNo->setChecked(true);
  showIdle->setChecked(i_aimSettings->main_showIdle);
  showLastOn->setChecked(i_aimSettings->main_showLastOn);
  if (i_aimSettings->main_browser == "netscape")
		browser_netscape->setChecked(true);
	else if (i_aimSettings->main_browser == "konqueror")
		browser_konq->setChecked(true);
	else{
    browser_other->setChecked(true);
	  browser->setText(i_aimSettings->main_browser);
	}
	noButtons->setChecked(i_aimSettings->main_noIcons);

	
	loginMoveDown->setValue(i_aimSettings->main_moveDown);
  
	if (i_aimSettings->main_idleLayout == 1)
		loginIdleLayout1->setChecked(true);
  else
	  loginIdleLayout2->setChecked(true);

  noHeaders->setChecked(i_aimSettings->main_noHeader);
  x11IdleTime->setChecked(i_aimSettings->main_useX11ForIdle);
  main_noSoundOnLogin->setChecked(i_aimSettings->main_mute_on_login);
  logSignOnOff->setChecked(i_aimSettings->main_log_on_off);

}

/******************************************************************************
 * Copy the settings to the dialogs
 ******************************************************************************/
void MainWindowOptionsImp::getData(){
  i_aimSettings->main_resizeHeight = resizeHeight->isChecked();
  i_aimSettings->main_resizeHeightMax = atoi(resizeHeightMax->text().latin1());
  i_aimSettings->main_resizeWidth = resizeWidth->isChecked();
  i_aimSettings->main_resizeWidthMax = atoi(resizeWidthMax->text().latin1());
  if (loginMoveRight->isChecked() == true)
    i_aimSettings->main_loginMoveRight = true;
  else
    i_aimSettings->main_loginMoveRight = false;
  if (loginMoveLeft->isChecked() == true)
    i_aimSettings->main_loginMoveLeft = true;
  else
    i_aimSettings->main_loginMoveLeft = false;
  if (loginMoveNo->isChecked() == true)
    i_aimSettings->main_loginMoveNo = true;
  else
    i_aimSettings->main_loginMoveNo = false;

  i_aimSettings->main_showIdle = showIdle->isChecked();
  i_aimSettings->main_showLastOn = showLastOn->isChecked();
  
	if (browser_netscape->isChecked() == true)
		i_aimSettings->main_browser = "netscape";
	if (browser_konq->isChecked() == true)
		i_aimSettings->main_browser = "konqueror";
  if (browser_other->isChecked() == true)
	  i_aimSettings->main_browser = browser->text();
  
	i_aimSettings->main_noIcons = noButtons->isChecked();
  
	i_aimSettings->main_moveDown = atoi(loginMoveDown->text().latin1());
  
	if (loginIdleLayout1->isChecked() == true)
	  i_aimSettings->main_idleLayout = 1;
	else
		i_aimSettings->main_idleLayout = 2;
  
  i_aimSettings->main_noHeader = noHeaders->isChecked();
  i_aimSettings->main_useX11ForIdle = x11IdleTime->isChecked();
  i_aimSettings->main_mute_on_login = main_noSoundOnLogin->isChecked();
  i_aimSettings->main_log_on_off = logSignOnOff->isChecked();

}

// MainWindowOptionsImp.cpp
