/***************************************************************************
                               ChatOptionsImp.cpp
                             -------------------
    begin                : Tuesday Nov 14 2000
    copyright            : (C) 2000 Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/


#include "chatoptionsimp.h"
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qspinbox.h>

/******************************************************************************
 * Constructor
 ******************************************************************************/
ChatOptionsImp::ChatOptionsImp(QWidget *parent, const char *name) : ChatOptions ( parent,name,false ){
	i_aimSettings = setup::settings();
}

/******************************************************************************
 * Deconstructor
 ******************************************************************************/
ChatOptionsImp::~ChatOptionsImp(){
}

/******************************************************************************
 * Copy the settings to the dialogs
 ******************************************************************************/
void ChatOptionsImp::updateData(){
	i_aimSettings = setup::settings();

  chat_message_flash->setChecked(i_aimSettings->chatSettings->chat_flash_on_new_message);
  chat_message_raise->setChecked(i_aimSettings->chatSettings->chat_raise_window);
  chat_log_everything->setChecked(i_aimSettings->chatSettings->chat_log);
  chat_log_html->setChecked(i_aimSettings->chatSettings->chat_log_inHtml);
  chat_log_single_file->setChecked(!i_aimSettings->chatSettings->chat_log_singleFile);
  chat_show_time->setChecked(i_aimSettings->chatSettings->chat_show_time);
  chat_log_time->setChecked(i_aimSettings->chatSettings->chat_log_time);
  chat_send_return->setChecked(i_aimSettings->chatSettings->chat_return_send);
  chat_send_shift->setChecked(i_aimSettings->chatSettings->chat_sreturn_send);
  chat_send_blank->setChecked(i_aimSettings->chatSettings->chat_send_blank);
  chat_remove_tages->setChecked(i_aimSettings->chatSettings->chat_ignore_buddyhtml);
  chat_show_smilies->setChecked(i_aimSettings->chatSettings->chat_show_smilies);
  chat_conversation_limit->setChecked(i_aimSettings->chatSettings->chat_line_limit);
  if (i_aimSettings->chatSettings->chat_line_limit == true)
    chat_conversation_limit_number->setEnabled(true);
  else
    chat_conversation_limit_number->setEnabled(false);

  chat_conversation_limit_number->setValue(i_aimSettings->chatSettings->chat_line_limit_number);

  chat_log_everything->setChecked(i_aimSettings->chatSettings->chat_log);

  //TOOLBAR STUFF
  chat_view_text->setChecked(i_aimSettings->chatToolBarSettings->view_text);
  chat_view_chat->setChecked(i_aimSettings->chatToolBarSettings->view_chat);

  if (i_aimSettings->chatToolBarSettings->view_chat == true)
    chat_chat_loc->setEnabled(true);
  else
    chat_chat_loc->setEnabled(false);
  if (i_aimSettings->chatToolBarSettings->view_text == true)
    chat_text_loc->setEnabled(true);
  else
    chat_text_loc->setEnabled(false);

  chat_text_loc->setCurrentItem(i_aimSettings->chatToolBarSettings->loc_text);
  chat_chat_loc->setCurrentItem(i_aimSettings->chatToolBarSettings->loc_chat);

  chat_text_bold->setChecked(i_aimSettings->chatToolBarSettings->text_bold);
  chat_text_italic->setChecked(i_aimSettings->chatToolBarSettings->text_italic);
  chat_text_underline->setChecked(i_aimSettings->chatToolBarSettings->text_underline);
  chat_text_fontdown->setChecked(i_aimSettings->chatToolBarSettings->text_fontdown);
  chat_text_fontnorm->setChecked(i_aimSettings->chatToolBarSettings->text_fontnormal);
  chat_text_fontup->setChecked(i_aimSettings->chatToolBarSettings->text_fontbig);
  chat_text_bgcolor->setChecked(i_aimSettings->chatToolBarSettings->text_bgcolor);
  chat_text_textcolor->setChecked(i_aimSettings->chatToolBarSettings->text_pencolor);
  chat_text_link->setChecked(i_aimSettings->chatToolBarSettings->text_link);
  chat_text_smiley->setChecked(i_aimSettings->chatToolBarSettings->text_smiley);

  chat_chat_send->setChecked(i_aimSettings->chatToolBarSettings->chat_send);
  chat_chat_clear->setChecked(i_aimSettings->chatToolBarSettings->chat_clear);
  chat_chat_save->setChecked(i_aimSettings->chatToolBarSettings->chat_save);
  chat_chat_print->setChecked(i_aimSettings->chatToolBarSettings->chat_print);
  chat_chat_time->setChecked(i_aimSettings->chatToolBarSettings->chat_time);
  chat_chat_log->setChecked(i_aimSettings->chatToolBarSettings->chat_log);
  chat_chat_sound->setChecked(i_aimSettings->chatToolBarSettings->chat_sound);
  chat_chat_addremove->setChecked(i_aimSettings->imToolBarSettings->chat_remove);
  chat_chat_warn->setChecked(i_aimSettings->imToolBarSettings->chat_warn);
  chat_chat_block->setChecked(i_aimSettings->imToolBarSettings->chat_block);
  chat_chat_info->setChecked(i_aimSettings->imToolBarSettings->chat_info);
  chat_chat_pounce->setChecked(i_aimSettings->imToolBarSettings->chat_pounce);


  // Chat Room Toolbar Settings
  chat_view_text_2->setChecked(i_aimSettings->chatRoomToolBarSettings->view_text);
  chat_view_chat_2->setChecked(i_aimSettings->chatRoomToolBarSettings->view_chat);

  if (i_aimSettings->chatRoomToolBarSettings->view_chat == true)
    chat_chat_loc_2->setEnabled(true);
  else
    chat_chat_loc_2->setEnabled(false);
  if (i_aimSettings->chatRoomToolBarSettings->view_text == true)
    chat_text_loc_2->setEnabled(true);
  else
    chat_text_loc_2->setEnabled(false);

  chat_text_loc_2->setCurrentItem(i_aimSettings->chatRoomToolBarSettings->loc_text);
  chat_chat_loc_2->setCurrentItem(i_aimSettings->chatRoomToolBarSettings->loc_chat);

  chat_text_bold_2->setChecked(i_aimSettings->chatRoomToolBarSettings->text_bold);
  chat_text_italic_2->setChecked(i_aimSettings->chatRoomToolBarSettings->text_italic);
  chat_text_underline_2->setChecked(i_aimSettings->chatRoomToolBarSettings->text_underline);
  chat_text_fontdown_2->setChecked(i_aimSettings->chatRoomToolBarSettings->text_fontdown);
  chat_text_fontnorm_2->setChecked(i_aimSettings->chatRoomToolBarSettings->text_fontnormal);
  chat_text_fontup_2->setChecked(i_aimSettings->chatRoomToolBarSettings->text_fontbig);
  chat_text_bgcolor_2->setChecked(i_aimSettings->chatRoomToolBarSettings->text_bgcolor);
  chat_text_textcolor_2->setChecked(i_aimSettings->chatRoomToolBarSettings->text_pencolor);
  chat_text_link_2->setChecked(i_aimSettings->chatRoomToolBarSettings->text_link);
  chat_text_smiley_2->setChecked(i_aimSettings->chatRoomToolBarSettings->text_smiley);

  chat_chat_clear_2->setChecked(i_aimSettings->chatRoomToolBarSettings->chat_clear);
  chat_room_send_2->setChecked(i_aimSettings->chatRoomToolBarSettings->chat_send);
  chat_chat_save_2->setChecked(i_aimSettings->chatRoomToolBarSettings->chat_save);
  chat_chat_print_2->setChecked(i_aimSettings->chatRoomToolBarSettings->chat_print);
  chat_chat_time_2->setChecked(i_aimSettings->chatRoomToolBarSettings->chat_time);
  chat_chat_log_2->setChecked(i_aimSettings->chatRoomToolBarSettings->chat_log);
  chat_chat_sound_2->setChecked(i_aimSettings->chatRoomToolBarSettings->chat_sound);

  chat_room_invite->setChecked(i_aimSettings->crToolBarSettings->room_invite);
}

/******************************************************************************
 * Copy the settings to the dialogs
 ******************************************************************************/
void ChatOptionsImp::getData(){
  i_aimSettings->chatSettings->chat_raise_window = chat_message_raise->isChecked();
  i_aimSettings->chatSettings->chat_flash_on_new_message = chat_message_flash->isChecked();
  i_aimSettings->chatSettings->chat_log = chat_log_everything->isChecked();
  i_aimSettings->chatSettings->chat_log_inHtml = chat_log_html->isChecked();
  i_aimSettings->chatSettings->chat_log_singleFile = !chat_log_single_file->isChecked();
  i_aimSettings->chatSettings->chat_show_time = chat_show_time->isChecked();

  i_aimSettings->chatSettings->chat_log_time = chat_log_time->isChecked();
  i_aimSettings->chatSettings->chat_return_send = chat_send_return->isChecked();
  i_aimSettings->chatSettings->chat_sreturn_send = chat_send_shift->isChecked();
  i_aimSettings->chatSettings->chat_send_blank = chat_send_blank->isChecked();
  i_aimSettings->chatSettings->chat_ignore_buddyhtml = chat_remove_tages->isChecked();
  i_aimSettings->chatSettings->chat_show_smilies = chat_show_smilies->isChecked();
  i_aimSettings->chatSettings->chat_line_limit = chat_conversation_limit->isChecked();
  i_aimSettings->chatSettings->chat_line_limit_number = chat_conversation_limit_number->value();

  i_aimSettings->chatSettings->chat_log = chat_log_everything->isChecked();

  //TOOLBAR STUFF
  bool Change = false;
  if (i_aimSettings->chatToolBarSettings->view_text != chat_view_text->isChecked() ||
  i_aimSettings->chatToolBarSettings->view_chat != chat_view_chat->isChecked() ||

  i_aimSettings->chatToolBarSettings->loc_text != chat_text_loc->currentItem() ||
  i_aimSettings->chatToolBarSettings->loc_chat != chat_chat_loc->currentItem() ||

  i_aimSettings->chatToolBarSettings->text_bold != chat_text_bold->isChecked() ||
  i_aimSettings->chatToolBarSettings->text_italic != chat_text_italic->isChecked() ||
  i_aimSettings->chatToolBarSettings->text_underline != chat_text_underline->isChecked() ||
  i_aimSettings->chatToolBarSettings->text_fontdown != chat_text_fontdown->isChecked() ||
  i_aimSettings->chatToolBarSettings->text_fontnormal != chat_text_fontnorm->isChecked() ||
  i_aimSettings->chatToolBarSettings->text_fontbig != chat_text_fontup->isChecked() ||
  i_aimSettings->chatToolBarSettings->text_bgcolor != chat_text_bgcolor->isChecked() ||
  i_aimSettings->chatToolBarSettings->text_pencolor != chat_text_textcolor->isChecked() ||
  i_aimSettings->chatToolBarSettings->text_link != chat_text_link->isChecked() ||
  i_aimSettings->chatToolBarSettings->text_smiley != chat_text_smiley->isChecked() ||

  i_aimSettings->chatToolBarSettings->chat_send != chat_chat_send->isChecked() ||
  i_aimSettings->chatToolBarSettings->chat_clear != chat_chat_clear->isChecked() ||
  i_aimSettings->chatToolBarSettings->chat_save != chat_chat_save->isChecked() ||
  i_aimSettings->chatToolBarSettings->chat_print != chat_chat_print->isChecked() ||
  i_aimSettings->chatToolBarSettings->chat_time != chat_chat_time->isChecked() ||
  i_aimSettings->chatToolBarSettings->chat_log != chat_chat_log->isChecked() ||
  i_aimSettings->chatToolBarSettings->chat_sound != chat_chat_sound->isChecked() ||
  i_aimSettings->imToolBarSettings->chat_remove != chat_chat_addremove->isChecked() ||
  i_aimSettings->imToolBarSettings->chat_warn != chat_chat_warn->isChecked() ||
  i_aimSettings->imToolBarSettings->chat_block != chat_chat_block->isChecked() ||
  i_aimSettings->imToolBarSettings->chat_info != chat_chat_info->isChecked() ||
	i_aimSettings->imToolBarSettings->chat_pounce != chat_chat_pounce->isChecked())
  Change = true;

  i_aimSettings->chatToolBarSettings->view_text = chat_view_text->isChecked();
  i_aimSettings->chatToolBarSettings->view_chat = chat_view_chat->isChecked();

  i_aimSettings->chatToolBarSettings->loc_text = chat_text_loc->currentItem();
  i_aimSettings->chatToolBarSettings->loc_chat = chat_chat_loc->currentItem();

  i_aimSettings->chatToolBarSettings->text_bold = chat_text_bold->isChecked();
  i_aimSettings->chatToolBarSettings->text_italic = chat_text_italic->isChecked();
  i_aimSettings->chatToolBarSettings->text_underline = chat_text_underline->isChecked();
  i_aimSettings->chatToolBarSettings->text_fontdown = chat_text_fontdown->isChecked();
  i_aimSettings->chatToolBarSettings->text_fontnormal = chat_text_fontnorm->isChecked();
  i_aimSettings->chatToolBarSettings->text_fontbig = chat_text_fontup->isChecked();
  i_aimSettings->chatToolBarSettings->text_bgcolor = chat_text_bgcolor->isChecked();
  i_aimSettings->chatToolBarSettings->text_pencolor = chat_text_textcolor->isChecked();
  i_aimSettings->chatToolBarSettings->text_link = chat_text_link->isChecked();
  i_aimSettings->chatToolBarSettings->text_smiley = chat_text_smiley->isChecked();

  i_aimSettings->chatToolBarSettings->chat_clear = chat_chat_clear->isChecked();
  i_aimSettings->chatToolBarSettings->chat_send = chat_chat_send->isChecked();
  i_aimSettings->chatToolBarSettings->chat_save = chat_chat_save->isChecked();
  i_aimSettings->chatToolBarSettings->chat_print = chat_chat_print->isChecked();
  i_aimSettings->chatToolBarSettings->chat_time = chat_chat_time->isChecked();
  i_aimSettings->chatToolBarSettings->chat_log = chat_chat_log->isChecked();
  i_aimSettings->chatToolBarSettings->chat_sound = chat_chat_sound->isChecked();
  i_aimSettings->imToolBarSettings->chat_remove = chat_chat_addremove->isChecked();
  i_aimSettings->imToolBarSettings->chat_warn = chat_chat_warn->isChecked();
  i_aimSettings->imToolBarSettings->chat_block = chat_chat_block->isChecked();
  i_aimSettings->imToolBarSettings->chat_info = chat_chat_info->isChecked();
  i_aimSettings->imToolBarSettings->chat_pounce = chat_chat_pounce->isChecked();

  // Chat Room Toolbar settings
  bool chatRoomToolbarChanged = false;
  if (i_aimSettings->chatRoomToolBarSettings->loc_text != chat_text_loc_2->currentItem() ||
  i_aimSettings->chatRoomToolBarSettings->loc_chat != chat_chat_loc_2->currentItem() ||

  i_aimSettings->chatRoomToolBarSettings->view_text != chat_view_text_2->isChecked() ||
  i_aimSettings->chatRoomToolBarSettings->view_chat != chat_view_chat_2->isChecked() ||

  i_aimSettings->chatRoomToolBarSettings->text_bold != chat_text_bold_2->isChecked() ||
  i_aimSettings->chatRoomToolBarSettings->text_italic != chat_text_italic_2->isChecked() ||
  i_aimSettings->chatRoomToolBarSettings->text_underline != chat_text_underline_2->isChecked() ||
  i_aimSettings->chatRoomToolBarSettings->text_fontdown != chat_text_fontdown_2->isChecked() ||
  i_aimSettings->chatRoomToolBarSettings->text_fontnormal != chat_text_fontnorm_2->isChecked() ||
  i_aimSettings->chatRoomToolBarSettings->text_fontbig != chat_text_fontup_2->isChecked() ||
  i_aimSettings->chatRoomToolBarSettings->text_bgcolor != chat_text_bgcolor_2->isChecked() ||
  i_aimSettings->chatRoomToolBarSettings->text_pencolor != chat_text_textcolor_2->isChecked() ||
  i_aimSettings->chatRoomToolBarSettings->text_link != chat_text_link_2->isChecked() ||
  i_aimSettings->chatRoomToolBarSettings->text_smiley != chat_text_smiley_2->isChecked() ||

  i_aimSettings->chatRoomToolBarSettings->chat_clear != chat_chat_clear_2->isChecked() ||
  i_aimSettings->chatRoomToolBarSettings->chat_send != chat_room_send_2->isChecked() ||
  i_aimSettings->chatRoomToolBarSettings->chat_save != chat_chat_save_2->isChecked() ||
  i_aimSettings->chatRoomToolBarSettings->chat_print != chat_chat_print_2->isChecked() ||
  i_aimSettings->chatRoomToolBarSettings->chat_time != chat_chat_time_2->isChecked() ||
  i_aimSettings->chatRoomToolBarSettings->chat_log != chat_chat_log_2->isChecked() ||
  i_aimSettings->chatRoomToolBarSettings->chat_sound != chat_chat_sound_2->isChecked() ||

  i_aimSettings->crToolBarSettings->room_invite != chat_room_invite->isChecked())
    chatRoomToolbarChanged = true;

  i_aimSettings->chatRoomToolBarSettings->loc_text = chat_text_loc_2->currentItem();
  i_aimSettings->chatRoomToolBarSettings->loc_chat = chat_chat_loc_2->currentItem();
  
	i_aimSettings->chatRoomToolBarSettings->view_text = chat_view_text_2->isChecked();
  i_aimSettings->chatRoomToolBarSettings->view_chat = chat_view_chat_2->isChecked();

  i_aimSettings->chatRoomToolBarSettings->text_bold = chat_text_bold_2->isChecked();
  i_aimSettings->chatRoomToolBarSettings->text_italic = chat_text_italic_2->isChecked();
  i_aimSettings->chatRoomToolBarSettings->text_underline = chat_text_underline_2->isChecked();
  i_aimSettings->chatRoomToolBarSettings->text_fontdown = chat_text_fontdown_2->isChecked();
  i_aimSettings->chatRoomToolBarSettings->text_fontnormal = chat_text_fontnorm_2->isChecked();
  i_aimSettings->chatRoomToolBarSettings->text_fontbig = chat_text_fontup_2->isChecked();
  i_aimSettings->chatRoomToolBarSettings->text_bgcolor = chat_text_bgcolor_2->isChecked();
  i_aimSettings->chatRoomToolBarSettings->text_pencolor = chat_text_textcolor_2->isChecked();
  i_aimSettings->chatRoomToolBarSettings->text_link = chat_text_link_2->isChecked();
  i_aimSettings->chatRoomToolBarSettings->text_smiley = chat_text_smiley_2->isChecked();

  i_aimSettings->chatRoomToolBarSettings->chat_send = chat_room_send_2->isChecked();
  i_aimSettings->chatRoomToolBarSettings->chat_clear = chat_chat_clear_2->isChecked();
  i_aimSettings->chatRoomToolBarSettings->chat_save = chat_chat_save_2->isChecked();
  i_aimSettings->chatRoomToolBarSettings->chat_print = chat_chat_print_2->isChecked();
  i_aimSettings->chatRoomToolBarSettings->chat_time = chat_chat_time_2->isChecked();
  i_aimSettings->chatRoomToolBarSettings->chat_log = chat_chat_log_2->isChecked();
  i_aimSettings->chatRoomToolBarSettings->chat_sound = chat_chat_sound_2->isChecked();

  i_aimSettings->crToolBarSettings->room_invite = chat_room_invite->isChecked();

  emit (saveSettings());

  if (Change == true){
		//qDebug("emit chatToolbarUpdated\n");
    emit chatToolbarUpdated();
	}
  if ( chatRoomToolbarChanged ){
		//qDebug("emit chatRoomToolbarUpdated\n");
    emit chatRoomToolbarUpdated();
	}
}

//ChatOptionsImp.cpp

