/***************************************************************************
                             awayoptionsimp.cpp
                             -------------------
    begin                : Tuesday Jan 10 2001
    copyright            : (C) 2001 Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/


#include <qlistbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qmultilineedit.h>
#include "awayoptionsimp.h"

/* 
 *  Constructs a AwayWindowOptionsImp which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
AwayWindowOptionsImp::AwayWindowOptionsImp( QWidget* parent,  const char* name)
    : awayOptions( parent, name )
{
	i_aimSettings = setup::settings();
  connect(away_add, SIGNAL(clicked()), this, SLOT(addAwayMessage()));
  connect(away_delete, SIGNAL(clicked()), this, SLOT(removeAwayMessage()));
  connect(away_new, SIGNAL(clicked()), this, SLOT(newAwayMessage()));
  connect(away_list, SIGNAL(highlighted(int)), this, SLOT(awayMessageSelected(int)));
  connect(away_list, SIGNAL(selected(int)), this, SLOT(awayMessageSelected(int)));
}

/*  
 *  Destroys the object and frees any allocated resources
 */
AwayWindowOptionsImp::~AwayWindowOptionsImp()
{
    // no need to delete child widgets, Qt does it all for us
}

void AwayWindowOptionsImp::awayMessageSelected(int number){
  int num = number;
  QString name = away_list->text(num);
	QString message = (*i_aimSettings->mapAwayMessages)[name];
  if (!message.isNull()){
		away_title->setText(name);
		away_edit->setText(message);
    away_title->setFocus();
  }
  away_title->setEnabled(false);
  away_add->setText("&Update");
	away_add->setEnabled( true );
}

void AwayWindowOptionsImp::addAwayMessage(){
	QString message = (*i_aimSettings->mapAwayMessages)[away_title->text()];
  QString text = away_edit->text();
  QString lastLetter = text.mid(text.length()-1,1);
	QString selected = away_idle_choice->currentText();
  while (text.length() > 0 && lastLetter == "\n"){
    text = text.mid(0,text.length()-1);
    lastLetter = text.at(text.length()-1);
  }
  away_edit->setText(text);
  if (message.isNull() ){
		i_aimSettings->mapAwayMessages->insert(away_title->text(), away_edit->text());
		QMap <QString,QString>::Iterator it;
		int position = 0;
		for(it = i_aimSettings->mapAwayMessages->begin();
								it != i_aimSettings->mapAwayMessages->end() && 
								it.key() != away_title->text(); ++it){
			position++;
		}
    away_list->insertItem(away_title->text(), position);
		away_idle_choice->insertItem(away_title->text(), position);
  }
  else{
		(*i_aimSettings->mapAwayMessages)[away_title->text()] = away_edit->text();
  }
  newAwayMessage();
	for(int i = 0; i < away_idle_choice->count(); i++){
		if(away_idle_choice->text(i) == selected){
			away_idle_choice->setCurrentItem(i);
			break;
		}
	}
}

void AwayWindowOptionsImp::removeAwayMessage(){
	QString selected = away_idle_choice->currentText();
	QString message = (*i_aimSettings->mapAwayMessages)[away_title->text()];
  if (!message.isNull() ){
    message = "";
    if (away_list->count() == 1)
      QMessageBox::information(this, "Message",("You must have 1 away message."), QMessageBox::Ok);
    else{
			i_aimSettings->mapAwayMessages->remove(away_title->text());
			//to update the combo box, we are relying on the fact that the indeces in
			//the away_list match up with the indeces in away_idle_choice:
			away_idle_choice->removeItem(away_list->currentItem());
			i_aimSettings->away_auto_default_message = away_idle_choice->currentItem();
      away_list->removeItem(away_list->currentItem());
      away_list->setCurrentItem(0);
      //awayMessageSelected(0);
    }
  }
  //newAwayMessage();
	for(int i = 0; i < away_idle_choice->count(); i++){
		if(away_idle_choice->text(i) == selected){
			away_idle_choice->setCurrentItem(i);
			break;
		}
	}
}

void AwayWindowOptionsImp::newAwayMessage(){
	away_title->setEnabled(true);
	away_add->setText("&Add");
	away_edit->setText("");
	away_title->setText("");
	away_title->setFocus();
}

// Get settings
void AwayWindowOptionsImp::updateData(){
	i_aimSettings = setup::settings();

	int id = 0;
  away_list->clear();
	away_idle_choice->clear();
  away_enable_auto->setChecked(i_aimSettings->away_enable_auto);

	//Disable as appropriate:
	away_auto_minutes->setEnabled( i_aimSettings->away_enable_auto );
	autoAwayMinutes->setEnabled( i_aimSettings->away_enable_auto );
	away_idle_choice->setEnabled( i_aimSettings->away_enable_auto );

	away_auto_minutes->setValue(i_aimSettings->away_auto_delay_minutes);
	QMap <QString, QString>::Iterator it;
	for(it = i_aimSettings->mapAwayMessages->begin(); 
					it != i_aimSettings->mapAwayMessages->end(); ++it){
		away_list->insertItem(it.key());
		away_idle_choice->insertItem(it.key());
	}
	for(int i = 0; i < away_idle_choice->count(); i++){
		if(away_idle_choice->text(i) == i_aimSettings->away_auto_default_message){
			id = i;
			break;
		}
	}
	away_idle_choice->setCurrentItem(id);
	/*		
	if(away_idle_choice->count() <= i_aimSettings->away_auto_default_message)
		away_idle_choice->setCurrentItem(0); //must have gotten deleted
	else	
		away_idle_choice->setCurrentItem(i_aimSettings->away_auto_default_message);
	*/
		
	chat_ignore_tik->setChecked(i_aimSettings->ignore_automated_get_away);
  away_back_button_only->setChecked(i_aimSettings->away_comeBackOnlyOnBackClick);
}

// Save settings;
void AwayWindowOptionsImp::getData(){
  i_aimSettings->away_comeBackOnlyOnBackClick = away_back_button_only->isChecked();
	i_aimSettings->away_enable_auto = away_enable_auto->isChecked();
	i_aimSettings->away_auto_delay_minutes = away_auto_minutes->value();
	i_aimSettings->away_auto_default_message = away_idle_choice->currentText();
  i_aimSettings->ignore_automated_get_away = chat_ignore_tik->isChecked();
}


