/***************************************************************************
                                  login.cpp
                             -------------------
    begin                : Sun Feb 13 2000
    copyright            : (C) 2000 by Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/***************************************************************************
 * Login Box.  Ask for Name and Password.  Starts SignOn proccess.  Options
 * can also be brought up from here.
 ***************************************************************************/

#include "login.h"
#include <kiconloader.h> 
#include "taim.h"

/***************************************************************************
 * Constructor
 ***************************************************************************/
Login::Login(QWidget *parent, const char *name) : QWidget(parent,name){
	i_aimSettings = setup::settings();

  // Load GUI
  initDialog();
  // Load main image from memory
  logoImage->setPixmap(SmallIcon("kinkattalogo"));
  // Change Password fild to show stars and not the letters
  aolPass->setEchoMode(QLineEdit::Password);
  // Connect the GUI to the appropiate slots
  connect(autoLogin, SIGNAL(toggled(bool)), this, SLOT(toggleAuto(bool)));
  connect(save, SIGNAL(toggled(bool)), this, SLOT(toggleSave(bool)));
  connect(aolName, SIGNAL(activated(int) ), this, SLOT(moveToPass(int)));	
  connect(aolName, SIGNAL(textChanged( const QString &)), this, SLOT(newName(const QString&)));
	
  connect(aolName, SIGNAL(textChanged( const QString &)), this, SLOT(enableDisableButton(const QString&)));
  connect(aolPass, SIGNAL(textChanged( const QString &)), this, SLOT(enableDisableButton(const QString&)));
  
  connect(aolPass, SIGNAL(returnPressed()), this, SLOT(SignOnClicked()));	
  connect(signOn, SIGNAL(clicked()), this, SLOT(SignOnClicked()));
  connect(setupButton, SIGNAL(clicked()), this, SLOT(SetupClicked()));
  // Start the sign on if auto login is enabled
  //if (autoLogin->isChecked() == true)
  //  emit(signOnClicked());
}

/***************************************************************************
 * Destructor
 ***************************************************************************/
Login::~Login(){
}

/***************************************************************************
 * initDialog
 ***************************************************************************/
void  Login::initDialog(){
  Layout1 = new QVBoxLayout( this ); 
  Layout1->setSpacing( 6 );
  Layout1->setMargin( 11 );

  logoImage = new QLabel( this, "TextLabel1" );
  logoImage->setText( tr( " " ) );
	logoImage->setFixedSize(272,105);
  Layout1->addWidget( logoImage );

  Layout2 = new QHBoxLayout; 
  Layout2->setSpacing( 6 );
  Layout2->setMargin( 0 );

  aolnameL = new QLabel( this, "aolnameL" );
  aolnameL->setText( tr( "                           Name" ) );
  Layout2->addWidget( aolnameL );

  aolName = new QComboBox( true , this, "aolName" );
  Layout2->addWidget( aolName );
  Layout1->addLayout( Layout2 );

  Layout3 = new QHBoxLayout; 
  Layout3->setSpacing( 6 );
  Layout3->setMargin( 0 );

  aolpassL = new QLabel( this, "aolpassL" );
  aolpassL->setText( tr( "Password" ) );
  Layout3->addWidget( aolpassL );

  aolPass = new QLineEdit( this, "aolPass" );
  Layout3->addWidget( aolPass );
  Layout1->addLayout( Layout3 );

  Layout4 = new QHBoxLayout; 
  Layout4->setSpacing( 6 );
  Layout4->setMargin( 0 );

  save = new QCheckBox( this, "save" );
  save->setText( tr( "Save Password" ) );
  Layout4->addWidget( save );

  autoLogin = new QCheckBox( this, "autoLogin" );
  autoLogin->setText( tr( "Auto Login" ) );
  autoLogin->setChecked( false );
  Layout4->addWidget( autoLogin );
  Layout1->addLayout( Layout4 );

  Layout5 = new QHBoxLayout; 
  Layout5->setSpacing( 6 );
  Layout5->setMargin( 0 );

  version = new QLabel( this, "verions" );
  version->setText( tr( "Ver 0.00" ) );
  Layout5->addWidget( version );

  setupButton = new QPushButton( this, "setup" );
  setupButton->setText( tr( "Options" ) );
  Layout5->addWidget( setupButton );

  signOn = new QPushButton( this, "signOn" );
  signOn->setText( tr( "Sign On" ) );
	signOn->setDisabled(true);
  Layout5->addWidget( signOn );
  Layout1->addLayout( Layout5 );
}

/***************************************************************************
 * Load settings (name and password and both checks)
 ***************************************************************************/
void Login::updateSettings(){
  // Set version number
  version->setText((i_aimSettings->Version).mid((i_aimSettings->Version).length()-4,4));
  QToolTip::add(version,i_aimSettings->ReleaseDate);
  // Load Name and Password
  aolPass->setText(i_aimSettings->login_password);
  //aolName->insertItem(i_aimSettings->login_name);
  // Check buttons
  save->setChecked(i_aimSettings->login_enable_save);
  autoLogin->setChecked(i_aimSettings->login_enable_auto);
  
  QString currentText = aolName->currentText();
  aolName->clear(); 
  aolName->insertStringList( setup::instance()->registeredUsers() );

  for (int i = aolName->count(); i > 0; i--){
    if (tocNormalize(aolName->text(i-1)) == tocNormalize(i_aimSettings->login_name)){
      aolName->setCurrentItem(i-1);
    }
    if (tocNormalize(aolName->text(i-1)) == tocNormalize(currentText))
      currentText = "";
  }
  if( currentText.length() > 0 ){
    aolName->insertItem(currentText);
    aolName->setCurrentItem(aolName->count()-1);
  }
  if (aolName->count() == 0)
    aolName->insertItem("<new user>");
}

/***************************************************************************
 * If AutoSave is unchecked then it is deleted
 ***************************************************************************/
void Login::toggleSave(bool value){
  if (value == false){
    removePassword(aolName->currentText());
  }
} 

/***************************************************************************
 * If AutoLogin is checked the other one is automaticly checked and disabled
 ***************************************************************************/
void Login::toggleAuto(bool value){
  if (value == true){
    save->setEnabled(false);
    save->setChecked(true);
  }
  else{
    save->setEnabled(true);	
  }
} 

/***************************************************************************
 * Moves the Cursor to the Password field if return is hit
 ***************************************************************************/
void Login::moveToPass(int){
  aolPass->setFocus();
}

/***************************************************************************
 * When the name changes change the password too.
 ***************************************************************************/
void Login::newName(const QString &name){
  readPassword(name);
}

/******************************************************************************
 * Saves the password
 ******************************************************************************/
void Login::savePassword(QString name){
  QString plainPass = aolPass->text();
  setup::instance()->savePassword(name, plainPass);
}

/******************************************************************************
 * Reads the password 
 ******************************************************************************/
void Login::readPassword(QString name){
  QString password = setup::instance()->readPassword(name);
	
  aolPass->setText(password);
  if ( password.isEmpty() ){
    autoLogin->setChecked(false);
    save->setChecked(false);
  } else {
    save->setChecked(true);
  }
}

/******************************************************************************
 * Remove the password 
 ******************************************************************************/
void Login::removePassword(QString name){
  setup::instance()->removePassword(name);
}

/***************************************************************************
 * Attempts to Sign on
 * Occurs when the signOn button is clicked.
 ***************************************************************************/
void Login::SignOnClicked(){
  if(aolName->currentText() == QString("<new user>")){
    int choice = -1;
		choice = QMessageBox::information(0, "Kinkatta - Error",(
"Kinkatta can't register new aim users at this time.\nYou must goto aol's website and register for\na new account. (http://aim.aol.com)"), "Ok", "Goto web site to register.");
    if (choice == 1){
	    browser->openURL(QString( "http://aim.aol.com/ "));
	  }
		return;
  }
  if ((aolName->currentText().length() == 0 ) || (aolPass->text().length() == 0) ){
     QMessageBox::information(this, "Kinkatta - Message",("Please enter a name and password."), QMessageBox::Ok);
  }
  else{
    i_aimSettings->login_password = aolPass->text();
    i_aimSettings->login_name = aolName->currentText();
    i_aimSettings->login_enable_save = save->isChecked();
    i_aimSettings->login_enable_auto = autoLogin->isChecked();
    if (i_aimSettings->login_enable_save == true)
      savePassword(i_aimSettings->login_name);
    else
      removePassword(aolName->currentText());
    emit(signOnClicked());
  }
}

/***************************************************************************
 * Brings up the Setup Dialog box
 * Occurs when the Setup Button is hit.
 ***************************************************************************/
void Login::SetupClicked(){
	QString selected = aolName->currentText();
	
	i_aimSettings->login_enable_save = save->isChecked();
	i_aimSettings->login_enable_auto = autoLogin->isChecked();
	
	if( setup::instance()->isRegisteredUser(selected) ){
		i_aimSettings->login_name = selected;
	} else {
		i_aimSettings->login_name = "";
	}

	emit (setupClicked());
} 

/***************************************************************************
 * The name or password was changed.  Check to see if either are of length 0
 * if so the disable the signon button.
 ***************************************************************************/
void Login::enableDisableButton( const QString &){
	if (aolName->currentText().length() == 0 || aolPass->text().length() == 0)
		signOn->setDisabled(true);
  else
		signOn->setDisabled(false);
}

// login.cpp
#include "login.moc"
