// Copyright (C) 2001 Neil Stevens <multivac@fcmail.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
// AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
// 
// Except as contained in this notice, the name(s) of the author(s) shall not be
// used in advertising or otherwise to promote the sale, use or other dealings
// in this Software without prior written authorization from the author(s).

#ifndef KITPASSWORDCHANGER_H
#define KITPASSWORDCHANGER_H

#include <kdialogbase.h>
#include <krestrictedline.h>

/**
 * Dialog for changing the user's password.
 * This class is used to display a dialog to change the user's
 * password.
 * @author Neil Stevens
 */

class KitPasswordChanger : public KDialogBase
{
Q_OBJECT

public:
/**
 * Constructor.
 * @param parent the parent of this widget
 * @param name the name of this widget
 */
	KitPasswordChanger(QWidget * = 0, const char * = 0);

/**
 * Set the user's old password
 * @param _old the old password
 * Set the user's old password. !!!Crustified?
 */ 
	void setOldPassword(QString _old) {old = _old;};

	/**
	 * Get the user's old password.
	 * Return the user's old password from the textfield.
	 * @return the user's old password
	 */
	QString oldPassword(void) {return oldPasswordEdit->text();}

	/**
	 * Get the user's new password.
	 * Return the user's new password from the textfield.
	 * @return the user's new password
	 */
	QString newPassword(void) {return newPasswordEdit->text();}

protected slots:
  /**
   * Called when the accept button is hit
   */
  virtual void accept(void);

private:
	KRestrictedLine *oldPasswordEdit, *newPasswordEdit, *verifyEdit;
	QString old;
};

#endif
