/***************************************************************************
																	info.h
														 -------------------
		begin								: Mon Jul 31 2000
		copyright						: (C) 2000 by Benjamin Meyer
		email								: benjamin@csh.rit.edu
***************************************************************************/

/***************************************************************************
 *																																				 *
 *	 This program is free software; you can redistribute it and/or modify	*
 *	 it under the terms of the GNU General Public License as published by	*
 *	 the Free Software Foundation; either version 2 of the License, or		 *
 *	 (at your option) any later version.																	 *
 *																																				 *
 ***************************************************************************/

#ifndef INFO_H
#define INFO_H

#include <qdialog.h>
#include <kio/jobclasses.h>
#include <ktempfile.h>

class QPushButton;
class KinkattaTextBrowser;
class Browser;

/**
 * User information dialog.
 * This class retreives a user's info and displays it in a dialog.
 * @author Benjamin Meyer
 */

class Info : public QDialog	{
  Q_OBJECT
    public:

  /**
   * Constructor.
   * @param parent the parent widget
   * @param name the name of this widget
   */
  Info(QWidget *parent=0, const char *name=0);

  /**
   * Destructor.
   */
  ~Info();

  /**
   * Web browser instance
   */
  Browser *browser;

  /**
   * Text browser instance
   */
  KinkattaTextBrowser *Information;

  /**
   * User to lookup
   */
  QString user;

  public slots:

    /**
     * Get the page from the web.
     */
    void addToWindow(QString data);
	
  private slots:
    /**
     * Copies the data from the web and puts it in the text browser
     */
    void copyJobResult(KIO::Job*);

  /**
   * Close the window.
   * Close the window once the close button is hit.
   */
  void closeWindow();

  /**
   * Open a URL.
   * Open this url in a web browser.
   * @param url the URL to open
   */
  void urlClicked(const QString &url);

  /**
   * Open a mail URL.
   * Open this URL in the system mail editor.
   * @param name the name of the person to mail (!!!not used!!!)
   * @param address the address to send mail to
   */
  void mailToClicked(const QString &name, const QString &address);

 protected: 
  
  /**
   * Resize the window.
   * Resizes the object in the window when the window is resized.
   * @param e the resize event
   */
  void resizeEvent( QResizeEvent *e );

  /**
   * Initialize the dialog.
   * Create the GUI.
   */
  void initDialog();

  /**
   * Close the window.
   * @param e the close event
   */
  void closeEvent(QCloseEvent *e);

  /**
   * The close button.
   */
  QPushButton *Close;
};

#endif

// info.h






