/***************************************************************************
                               controlimp.cpp
                             -------------------
    begin                : Wednesday March 28 2001
    copyright            : (C) 2001 Benjamin Meyer 
    email                : ben@meyerhome.net
 ***************************************************************************/

#include "controlimp.h"
#include <qtoolbutton.h>
#include <qlistbox.h>
#include <qlabel.h>
#include <qmessagebox.h>
#include <kpopupmenu.h>
#include <kiconloader.h>

/******************************************************************************
 * Constructor
 ******************************************************************************/
ChatRoomControlImp::ChatRoomControlImp(QWidget *parent, const char *name) : ChatRoomControl( parent,name,false ){
  connect( buddyList, SIGNAL(rightButtonClicked(QListBoxItem *, const QPoint &)), this, SLOT(rightClick(QListBoxItem *, const QPoint &)) );
}

/******************************************************************************
 * Deconstructor
 ******************************************************************************/
ChatRoomControlImp::~ChatRoomControlImp(){
}

/******************************************************************************
 * A buddy has been updated, add or remove as needed.  Update count.
 ******************************************************************************/
void ChatRoomControlImp::updateBuddy(QString buddy, bool curstat){
  if (curstat == true)
    buddyList->insertItem(buddy);
  else{
    int count = buddyList->count();
    int index = -1;
    for(int i=0; i< count; i++){
      QString bud = buddyList->text(i);
      if (bud == buddy)
        index = i;
      // Check ignore case;
      if(buddy.mid(0,1) == QString("*"))
        if ( bud.mid(1,bud.length()-1) == buddy)
          index = i;
    }
    if (index != -1)
      buddyList->removeItem(index);
  }
  QString people;
  if (buddyList->count() == 1)
    people = "1 person";
  else
    people = QString("%1 people").arg(buddyList->count());
  numberOfPeople->setText(people);
  if ( buddyList->currentItem() == -1)
    buddyList->setCurrentItem ( buddyList->firstItem() ) ;
}

/******************************************************************************
 * Tells if the buddy should be ignored or not.
 ******************************************************************************/
bool ChatRoomControlImp::ignore(QString buddy){
  QString ignoreBuddy = QString("*") + buddy;
  int count = buddyList->count();
  for(int i=0; i< count; i++){
    if ( (buddyList->text(i)) == ignoreBuddy)
      return true;
  }
  return false;
}

/******************************************************************************
 * If a buddy is selected send out a signal to get there info.
 ******************************************************************************/
void ChatRoomControlImp::infoClicked(){
  if ( buddyList->currentItem() == -1)
    QMessageBox::information(this, "Kinkatta - Message","Select a buddy.", QMessageBox::Ok);
  else
    emit ( getInfo(buddyList->currentText()) );
}

/******************************************************************************
 * When you ignore someone put an asteric next to there name to show that you
 * will ignore them.  If they have one, remove it.
 ******************************************************************************/
void ChatRoomControlImp::ignoreClicked(){
  int curBuddy = buddyList->currentItem();
  if ( curBuddy == -1){
    QMessageBox::information(this, "Kinkatta - Message","Select a buddy.", QMessageBox::Ok);
    return;
  }
  QString buddy = buddyList->text(curBuddy);
  if (buddy == owner){
    QMessageBox::information(this, "Kinkatta - Message","You can not ignore yourself.", QMessageBox::Ok);
    return;
  }

  // Make sure we havn't ignored them already.
  if (buddy.mid(0,1) != QString("*")){
    buddy = QString("*") + buddy;
    buddyList->changeItem ( buddy,curBuddy );
  }
  else{
    buddy = buddy.mid(1,buddy.length()-1);
    buddyList->changeItem ( buddy,curBuddy );
  }
}

/******************************************************************************
 * If a buddy is selected send out a signal to open a chat with them.
 ******************************************************************************/
void ChatRoomControlImp::imClicked(){
  if ( buddyList->currentItem() == -1)
    QMessageBox::information(this, "Kinkatta - Message","Select a buddy.", QMessageBox::Ok);
  else
    emit ( im(buddyList->currentText()) );
}

/******************************************************************************
 * When you right click on a buddy this is the menu that pops up.
 ******************************************************************************/
void ChatRoomControlImp::rightClick(QListBoxItem *, const QPoint &pos){
  if ( buddyList->currentItem() == -1 /*|| buddyList->itemAt(pos) == NULL*/ ){
    QMessageBox::information(this, "Kinkatta - Message","Select a buddy.", QMessageBox::Ok);
    return;
  }
   KPopupMenu *_Menu = new KPopupMenu(this, "rightclickmenu");
  _Menu->clear();
  _Menu->insertItem(SmallIcon("chat"), "&IM", this, SLOT(imClicked()));
  _Menu->insertItem(SmallIcon("close"), "&Ignore", this, SLOT(ignoreClicked()));
  _Menu->insertItem(SmallIcon("info"), "&Info", this, SLOT(infoClicked()));
  _Menu->exec(pos);
}

// contolimp.cpp

