/******************************************************************************
                                chatroom.cpp
                             -------------------
    begin                : Wednesdat May 28 2000
    copyright            : (C) 2000 by Benjamin Meyer
    email                : ben@meyerhome.net
 ******************************************************************************/

/******************************************************************************
 *                                                                            *
 *   This program is free software; you can redistribute it and/or modify     *
 *   it under the terms of the GNU General Public License as published by     *
 *   the Free Software Foundation; either version 2 of the License, or        *
 *   (at your option) any later version.                                      *
 *                                                                            *
 ******************************************************************************/

/******************************************************************************
 * This is the implimentation of a chat "room" window.  It uses the chat class.
 ******************************************************************************/

#include "chatroom.h"
#include <kiconloader.h>
#include "controlimp.h"
#include <qcolor.h>
#include <qsplitter.h>
#include <ktoolbar.h>
#include <qtoolbutton.h>
#include <kpopupmenu.h>

/******************************************************************************
 * Constructor
 ******************************************************************************/
ChatRoom::ChatRoom(QString userName, QString buddysName, QWidget *parent): Chat(userName,buddysName,parent){
  roomToolBarSettings = setup::settings()->crToolBarSettings;
  toolBarSettings = setup::settings()->chatRoomToolBarSettings;
  
  initToolBar();
  initChatWindow();
  control->owner = myName;

  initMenuBar();
  this->setMinimumSize(350,200);
}

/******************************************************************************
 * Deconstructor
 ******************************************************************************/
ChatRoom::~ChatRoom(){

}

/******************************************************************************
 * The toolbar settings have been changed in options, copy chatroom settings
 * and then update.
 ******************************************************************************/
void ChatRoom::updateChatToolBarSettings(){
	//qDebug("ChatRoom::updateChatToolBarSettings\n");
  roomToolBarSettings = setup::settings()->crToolBarSettings;
  toolBarSettings = setup::settings()->chatRoomToolBarSettings;
	this->initToolBar();
}

/******************************************************************************
 * Set the current size of the window.
 ******************************************************************************/
void ChatRoom::setSize(int x, int y, int s1, int s2){
  this->resize(x,y);
  
  QValueList<int> list;
  list = spliter->sizes();
  list[1] = s1;
  spliter->setSizes(list);

  QValueList<int> list2;
  list2 = vSpliter->sizes();
  list2[1] = s2;
  vSpliter->setSizes(list2);
}

/******************************************************************************
 * Save the size of the window.
 ******************************************************************************/
void ChatRoom::saveSize(){
  QValueList<int> list;
  list = spliter->sizes();
  int s1 = list[1];

  QValueList<int> list2;
  list2 = vSpliter->sizes();
  int s2 = list2[1];

  emit saveNewSize(this->width(),this->height(),s1,s2);
}

/******************************************************************************
 * Sets up the input window and the chat window
 ******************************************************************************/
void ChatRoom::initChatWindow(){
  vSpliter = new QSplitter(this, "Splitter" );
  vSpliter->setOrientation(QSplitter::Horizontal);
  spliter = new QSplitter(vSpliter, "Splitter" );
  control = new ChatRoomControlImp( vSpliter, "control" );
  connect(control, SIGNAL(getInfo(QString)), this, SIGNAL(getInfo(QString)));
  connect(control, SIGNAL(im(QString)), this, SIGNAL(im(QString)));

  Chat::initChatWindow();

  QValueList<int> list;
  list = vSpliter->sizes();
  list[1] = 40;
  vSpliter->setSizes(list);
  this->setCentralWidget( vSpliter );
}


/******************************************************************************
 * ToolBar setup  Clears the toolbars and fills them with the widgets
 * specified in toolBarSettings then oriants the toolbars as chosen.
 ******************************************************************************/
void ChatRoom::initToolBar(){
  Chat::initToolBar();
  
  if ( roomToolBarSettings->room_invite == true)
    fileToolbar->insertButton("mail_generic",-1,SIGNAL(clicked()), this, SLOT(slotBuddyInvite()),true,"Invite Buddy(s)", -1);
}

/******************************************************************************
 * MenuBar setup.  Clears the menu bar and filles them up with the chat widgets
 * and then the chatroom ones. 
 ******************************************************************************/
void ChatRoom::initMenuBar(){
  Chat::initMenuBar();
  buddyMenu->insertItem(SmallIcon("mail_generic"), "&Invite Buddy(s)...", this, SLOT(slotBuddyInvite()), 0, ID_BUDDY_INVITE);

	viewMenu->insertSeparator();
	viewMenu->insertItem("&Save Size", this, SLOT(saveSize()), 0 , ID_VIEW_SAVESIZE);
}

/******************************************************************************
 * Parse the incoming message and set up the room to accept the incoming.
 ******************************************************************************/
void ChatRoom::messageInParse(QString buddy, bool , QString message){
  if (control->ignore(buddy) == false){
    buddyName = buddy;
    if (myName != buddy)
      messageIn(message);
  }
}

/******************************************************************************
 * A buddy left or joined the room, update
 ******************************************************************************/
void ChatRoom::updateBuddy(QString buddy, bool curstat){
  control->updateBuddy(buddy, curstat);
}

/******************************************************************************
 * The server just knocked you off.  Send such a message to the chatroom.
 ******************************************************************************/
void ChatRoom::leftRoom(){
  buddyName = "AOL Server";
  messageIn("YOU HAVE LEFT THE ROOM.\n");
}

/******************************************************************************
 * Bring up the buddy invite dialog.
 ******************************************************************************/
void ChatRoom::slotBuddyInvite(){
  emit showInviteWidget(room);
}

// chatroom.cpp



