/***************************************************************************
                                  browser.h
                             -------------------
    begin                : Mon Feb 9 2001
    copyright            : (C) 2000 by Benjamin Meyer
    email                : benjamin@csh.rit.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BROWSER_H
#define BROWSER_H

#include <qstring.h>

/**
 * Web browser abstraction.
 * This class is used to open URLs and retrieve files via HTTP.
 *@author Benjamin Meyer
 */

class Browser  {

public: 
  /**
   * Constructor.
   */
  Browser();

  /**
   * Destructor.
   */
  ~Browser();

  /**
   * Set which browser to use.
   * @param choice specify browser to use
   * - 1 - Netscape
   * - 2 - other browser
   */
  void setBrowser(int choice);

  /**
   * Open or retrieve a URL.
   * @param url the URL to retrieve/open
   * Opens or downloads a URL with the specified browser.
   */
  void openURL(QString url);

  /**
   * Browser to use.
   */
  QString otherBrowser;

private:
  /**
   * This appears to be a flag indicating whether to use Netscape (1)
   * or to use otherBrowser.
   */
  int browserChoice;	

};
#endif

// browser.h
