/***************************************************************************
                                broswer.cpp
			                    -------------------
    begin                : Mon Feb 9 2001
    copyright            : (C) 2000 by Benjamin Meyer
    email                : ben@meyerhome.net 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "browser.h"
#include <qmessagebox.h>
#include <unistd.h> 
#include <stdlib.h>
#include <qtextstream.h>
#include <kprocess.h>

/***************************************************************************
 * Constructor
 ***************************************************************************/
Browser::Browser(){
	browserChoice = 1;
	otherBrowser = "";
}

/***************************************************************************
 * Deconstructor
 ***************************************************************************/
Browser::~Browser(){
}

/***************************************************************************
 * Set the browser choice number
 ***************************************************************************/
void Browser::setBrowser(int choice){
  browserChoice = choice;
}

/***************************************************************************
 * Open the url that is passed through.
 ***************************************************************************/
void Browser::openURL(QString url){
	if (url.mid(0,1) == "-"){
	  printf("Possible security hack, not parsing: %s.\n", url.latin1());
		return;	
	}
	
	// Make sure we are only passing in one thing.
	int space = url.find(" ", 0, true);
        // If spaces are found, escape them...
	if (space != -1)
          url = url.replace(QRegExp(" "), ("\\ ") );
  
	KProcess *proc = new KProcess();	

	*proc << otherBrowser.latin1();
        *proc << (url.latin1());
        proc->start( KProcess::DontCare );
}

// broswer.cpp

