/* Copyright (C) 2003-2005 Jesper K. Pedersen <blackie@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#include "imagedate.h"
#ifndef IMAGEDATERANGE_H
#define IMAGEDATERANGE_H

class ImageDateRange
{
public:
    ImageDateRange();
    ImageDateRange( const ImageDate& from, const ImageDate& to );

    enum MatchType { DontMatch, ExactMatch, RangeMatch };
    MatchType isIncludedIn( const ImageDateRange& searchRange );
    bool includes( const QDateTime& date );
    ImageDate start() const;
    ImageDate end() const;
    bool operator<(const ImageDateRange& other ) const;

private:
    ImageDate _imageStart;
    ImageDate _imageEnd;
};


#endif /* IMAGEDATERANGE_H */

