/*
 *   File name:	kdirstatmain.cpp
 *   Summary:	Main program for KDirStat
 *   License:	GPL - See file COPYING for details.
 *
 *   Author:	Stefan Hundhammer <sh@suse.de>
 *		Parts auto-generated by KDevelop
 *
 *   Updated:	2002-02-10
 *
 *   $Id: kdirstatmain.cpp,v 1.7 2002/02/11 10:04:33 hundhammer Exp $
 *
 */



#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "kdirstatapp.h"


static const char *description =
	I18N_NOOP("KDirStat - Directory statistics.\n"
		  "\n"
		  "Shows where all your disk space has gone\n"
		  "and helps you clean it up."
		  "\n"
		  "\n"
		  "If you have any comments or if you would simply like to tell us\n"
		  "your opinion about this program, please use \"Send Feedback Mail\"\n"
		  "from the \"Help\" menu."
		  );


static KCmdLineOptions options[] =
{
    { "+[Dir/URL]", I18N_NOOP("Directory or URL to open"), 0 },
    { 0, 0, 0 }
};

int main(int argc, char *argv[])
{

    KAboutData aboutData( "kdirstat", I18N_NOOP("KDirStat"),
			  VERSION, description, KAboutData::License_GPL,
			  "(c) 1999-2002 Stefan Hundhammer", 0, 0, 
			  "sh@suse.de" );
    
    aboutData.addAuthor( "Stefan Hundhammer",
#if USE_TREEMAPS
			 I18N_NOOP("Core engine, application, cleanup actions"),
#else
			 I18N_NOOP("\n"
				   "If you have any comments or if you would simply like to tell us\n"
				   "your opinion about this program, please use \"Send Feedback Mail\"\n"
				   "from the \"Help\" menu." ),
#endif
			 "sh@suse.de", "http://kdirstat.sourceforge.net/" );

#if USE_TREEMAPS
    aboutData.addAuthor( "Alexander Rawass", I18N_NOOP( "Tree maps" ),
			 "alexannika@users.sourceforge.net" );
    
    aboutData.addCredit( I18N_NOOP( "All the people who worked on SequoiaView" ),
			 I18N_NOOP( "for giving us the inspiration just how useful treemaps really can be - \n"
				    "even though that program runs on that 'other' OS only...\n"
				    ";-) \n"),
			 0,	// e-mail
			 "http://www.win.tue.nl/sequoiaview" );
    
    aboutData.addCredit( I18N_NOOP( "Jarke J. van Wijk and Huub van de Wetering" ),
			 I18N_NOOP( "for their papers about treemaps.\n" ),
			 "vanwijk@win.tue.nl",
			 "http://www.win.tue.nl/~vanwijk/" );
    
    aboutData.addCredit( "Ben Shneiderman",
			 I18N_NOOP( "for his ingenious idea of treemaps -\n"
				    "a truly intuitive way of visualizing tree contents." ),
			 "",	// E-Mail
			 "http://www.cs.umd.edu/hcil/treemaps/" );
#endif
    
    KCmdLineArgs::init( argc, argv, &aboutData );
    KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

    KApplication app;

    if ( app.isRestored() )
    {
	RESTORE(KDirStatApp);
    }
    else
    {
	KDirStatApp *kdirstat = new KDirStatApp();
	kdirstat->show();

	KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

	if ( args->count() )
	{
	    // Process command line arguments as URLs or paths to scan

	    KURL url = fixedUrl( args->arg( 0 ) );
	    // kdDebug() << "Opening " << url.url() << endl;
	    kdirstat->openURL( url );
	}
	else
	{
	    kdirstat->fileAskOpenDir();
	}
	
	args->clear();
    }

    // kdDebug() << "Entering main loop" << endl;

    return app.exec();
}

