/*
 *   File name:	kdirstatapp.h
 *   Summary:	The KDirStat application - menu bar, tool bar, ...
 *   License:	GPL - See file COPYING for details.
 *
 *   Author:	Stefan Hundhammer <sh@suse.de>
 *		Parts auto-generated by KDevelop
 *
 *   Updated:	2002-02-09
 *
 *   $Id: kdirstatapp.h,v 1.8 2002/02/11 10:04:33 hundhammer Exp $
 *
 */


#ifndef KDirStatApp_h
#define KDirStatApp_h
 

#ifdef HAVE_CONFIG_H
#   include <config.h>
#endif

#include <kapp.h>
#include <kmainwindow.h>
#include <kaccel.h>
#include <kaction.h>
#include "kdirtreeview.h"
#include "kcleanupcollection.h"
#include "kdirstatsettings.h"


// Forward declarations
class QPopupMenu;
class KPacMan;
class KFeedbackDialog;
class KFeedbackQuestion;
class KActivityTracker;
class KDirStat::KFileInfo;


using namespace KDirStat;

/**
  * The base class for KDirStat application windows. It sets up the main window
  * and reads the config file as well as providing a menubar, toolbar and
  * statusbar. An instance of KDirStatView creates your center view, which is
  * connected to the window's Doc object.  KDirStatApp reimplements the methods
  * that KMainWindow provides for main window handling and supports full
  * session management as well as using KActions.
  *
  * @see KMainWindow
  * @see KApplication
  * @see KConfig
  *
  * @author Source Framework Automatically Generated by KDevelop,
  *	    (c) The KDevelop Team.
  *
  * @version KDevelop version 1.2 code generation
  **/
class KDirStatApp : public KMainWindow
{
    Q_OBJECT

public:
    
    /**
     * Construtor of KDirStatApp, calls all init functions to create the
     * application.
     **/
    KDirStatApp( QWidget* parent=0, const char* name=0 );

    /**
     * Destructor.
     **/
    virtual ~KDirStatApp();
    
    /**
     * Open an URL specified by command line argument.
     **/
    void openURL( const KURL & url );

    /**
     * Return the main window's @ref KDirTreeView
     **/
    KDirTreeView * treeView() { return _treeView; }


public slots:

    /**
     * Open a directory tree.
     **/
    void fileAskOpenDir();
    
    /**
     * Refresh the entire directory tree, i.e. re-read everything from disk.
     **/
    void refreshAll();
    
    /**
     * Refresh the selected subtree, i.e. re-read it from disk.
     **/
    void refreshSelected();
    
    /**
     * Open a directory tree from the "recent" menu.
     **/
    void fileOpenRecent( const KURL& url );
    
    /**
     * asks for saving if the file is modified, then closes the current file
     * and window
     **/
    void fileCloseDir();

    /**
     * put the marked text/object into the clipboard
     **/
    void editCopy();

    /**
     * Notification that the view's selection has changed.
     * Enable/disable user actions as appropriate. 
     **/
    void selectionChanged( KFileInfo *selection );
    
    /**
     * Toggle tool bar
     **/
    void toggleToolBar();
    
    /**
     * Toggle status bar
     **/
    void toggleStatusBar();

    /**
     * Open settings dialog
     **/
    void preferences();
    
    /**
     * Changes the statusbar contents for the standard label permanently, used
     * to indicate current actions.
     *
     * @param text the text that is displayed in the statusbar
     **/
    void statusMsg( const QString &text );

    /**
     * Opens a context menu for tree view items.
     **/
    void contextMenu( KDirTreeViewItem *item, const QPoint &pos );

    /**
     * Sends a user feedback mail.
     **/
    void sendFeedbackMail();
    
    /**
     * Read configuration for the main window.
     **/
    void readMainWinConfig();

    /**
     * Save the main window's configuration.
     **/
    void saveMainWinConfig();
    
    /**
     * Revert all cleanups to default values.
     **/
    void revertCleanupsToDefaults();

    /**
     * For the settings dialog only: Return the internal cleanup collection.
     **/
    KCleanupCollection * cleanupCollection() { return _cleanupCollection; }

    /**
     * Ask user if he wouldn't like to rate this program.
     **/
    void askForFeedback();

    /**
     * Notification that a feedback mail has been sent, thus don't remind
     * the user any more.
     **/
    void feedbackMailSent();
    
    
signals:

    /**
     * Emitted when the configuration is to be read - other than at program
     * startup / object creation where each object is responsible for reading
     * its configuraton at an appropriate time.
     **/
    void readConfig();

    /**
     * Emitted when the configuration is to be saved.
     **/
    void saveConfig();
    
    
protected:

    /**
     * Initialize the KActions of the application.
     **/
    void initActions();


    /**
     * Initialize @ref KCleanup actions.
     **/
    void initCleanups();

    /**
     * Initialize @ref KPacMan animation in the tool bar.
     **/
    void initPacMan();
    
    /**
     * Set up status bar for the main window by initializing a status label.
     **/
    void initStatusBar();

    /**
     * Set up the activity tracker.
     **/
    void initActivityTracker();
    
    /**
     * Called when a main window is to be closed.
     *
     * Returns "true" when closing this window is OK, "false" to abort closing.
     **/
    virtual bool queryClose();
    
    /**
     * Called when the application is to be shut down alltogether, i.e. when
     * all windows are to be closed.
     *
     * Returns "true" when exiting is OK, "false" otherwise.
     **/
    virtual bool queryExit();
    
    /**
     * Save the window properties for each open window during session end to
     * the session config file, including saving the currently opened file by a
     * temporary filename provided by KApplication.
     *
     * @see KTMainWindow#saveProperties
     **/
    virtual void saveProperties( KConfig * config );
    
    /**
     * Reads session config file and restore application state including the
     * last opened files and documents by reading the temporary files saved by
     * saveProperties().
     *
     * @see KTMainWindow#readProperties
     **/
    virtual void readProperties( KConfig * config );

    
    /**
     * Add a list of features of this program to a feedback question
     **/
    void addFeatureList( KFeedbackQuestion * question );

    /**
     * Check if the user should be reminded to submit feedback.
     **/
    bool doFeedbackReminder();


    //
    // Data members
    //
    
    // Widgets
    
    KDirTreeView *		_treeView;
    KPacMan *			_pacMan;
    QPopupMenu *		_treeViewContextMenu;
    KDirStat::KSettingsDialog *	_settingsDialog;
    KFeedbackDialog *		_feedbackDialog;
    KActivityTracker *		_activityTracker;
    

    // Actions
    
    KAction * 			_fileAskOpenDir;
    KRecentFilesAction *	_fileOpenRecent;
    KAction * 			_fileCloseDir;
    KAction * 			_fileRefreshAll;
    KAction *			_fileRefreshSelected;
    KAction *			_fileContinueReadingAtMountPoint;
    KAction * 			_fileQuit;
    KAction * 			_editCopy;
    KAction *			_reportMailToOwner;
    KAction *			_helpSendFeedbackMail;
    KToggleAction * 		_viewToolBar;
    KToggleAction * 		_viewStatusBar;
    
    KCleanupCollection *	_cleanupCollection;

};

 
#endif // KDirStatApp_h
