/***************************************************************************
                          edgeobject.cpp  -  description
                             -------------------
    begin                : Sat Jan 12 2002
    copyright            : (C) 2002 by Samuele Catuzzi
    email                : samuele_catuzzi@yahoo.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "edgeobject.h"
#include <iostream>
#include <math.h>

EdgeObject::EdgeObject(int bnumber,QCanvasPixmapArray * bitmap,QCanvas * canvas,int Z)
                      :QCanvasSprite( bitmap ,canvas){
 images=bitmap;
 setZ(Z);
 show();
 vect_Dir.x=0.0;
 vect_Dir.y=0.0;
 vect_Dir.z=0.0;
 name="Edge";
 edgenumber=bnumber; //ID of bouncer
 is_a_bouncer=false; //default is a simple sprite object
}

EdgeObject::~EdgeObject(){
 delete(images);
}
/** No descriptions */
int EdgeObject::rtti() const {
 return 2000 ;
}
/** No descriptions */
void EdgeObject::setLines(double A,double B,double C,double A1,double B1,double C1,double A2,double B2,double C2){
 //set parameter of Bouncing line
 a=A;
 b=B;
 c=C;
 //set parameter of first delimiter line
 a1=A1;
 b1=B1;
 c1=C1;
 //set parameter of second delimiter line
 a2=A2;
 b2=B2;
 c2=C2;

 is_a_bouncer=true;
}
/**
Line that contain segment of bouncing is:  ax + by +c = 0
Lines delimiter area are:  a1x+b1y+c1 >= 0   ,    a2x+b2y+c2 >= 0

Input data: center of ball C(Cx,Cy) , radius, speed of ball: V(Vx,Vy)
Output: time left to impact or -1 if the ball not collide with this edge
*/
double EdgeObject::EdgeCPrediction(Ball * ball){

 if ( !is_a_bouncer ) return -1;

 double Cx=ball->xcenter();
 double Cy=ball->ycenter();
 double radius=ball->diameter/2;
 double Vx=ball->vect_Vel.x ;
 double Vy=ball->vect_Vel.y ;

 double time;

 double i,j,distance;
 i= a*Cx + b*Cy + c;
 if ( i < 0 ) i= -i ;
 distance=i/sqrt(a*a + b*b) ;
 j= Vy*b + a*Vx ;
 if ( j == 0 ) return -1 ;
 if ( j < 0 ) j= -j ;
 i= (distance - radius)*sqrt(a*a + b*b);
 time=i/j;

 //changed 8 nov 2004
 //italian: significa che sto gia compenetrando l'oggetto
 if ( time < 0 ) time=-time;

 //now I check if a ball is coming or not on this segment
 double C2x= -Vx + Cx; // calculate precedent position
 double C2y= -Vy + Cy;
 i= a*C2x + b*C2y + c;
 if ( i < 0 ) i= -i ;
 j= i/sqrt(a*a + b*b) ; //last distance
 if ( j <= distance ) return -1;

 //last check..
 C2x=Vx*time + Cx;
 C2y=Vy*time + Cy;
 if (!(  (rint( a1*C2x+b1*C2y+c1 ) >= 0 ) && (rint( a2*C2x+b2*C2y+c2 ) >= 0 ) && (rint( a*C2x+b*C2y+c ) >= 0 ) )) return -1;

 return time;
}
