/*
 * setupdlg.h
 * Copyright (C) 1999-2001 Kurt Granroth <granroth@kde.org>
 *
 * This file contains the setup dialog and related widgets
 * for KBiff.  All user configuration is done here.
 *
 * $Id: setupdlg.h,v 1.3 2001/05/21 21:54:39 gran Exp $
 */
#ifndef SETUPDLG_H
#define SETUPDLG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif //HAVE_CONFIG_H

#include <kbiffurl.h>

#include <qlistview.h>

#include <qwidget.h>
#include <kdialog.h>
#include <qdict.h>
#include <qlineedit.h>

class QLineEdit;
class QCheckBox;
class QPushButton;
class QComboBox;

#include <kicondialog.h>

struct KBiffMailbox
{
  KBiffURL url;
  bool store;
  QString key;
};

class KBiffGeneralTab;
class KBiffNewMailTab;
class KBiffMailboxTab;
class KBiffAboutTab;
class KBiffNewDlg;

class KBiffSetup : public KDialog
{
	Q_OBJECT
public:
	KBiffSetup(const QString& name = QString::null, bool secure = false);
	virtual ~KBiffSetup();

	const QString getProfile() const;
	const KBiffURL getCurrentMailbox() const;
	const QList<KBiffMailbox> getMailboxList() const;

	const QString getMailClient() const;
	const QString getRunCommandPath() const;
	const QString getPlaySoundPath() const;
	const QString getNoMailIcon() const;
	const QString getNewMailIcon() const;
	const QString getOldMailIcon() const;
	const QString getNoConnIcon() const;
	const bool getSystemBeep() const;
	const bool getRunCommand() const;
	const bool getPlaySound() const;
	const bool getNotify() const;
	const bool getStatus() const;
	const bool getDock() const;
	const bool getSessionManagement() const;
	const bool getCheckStartup() const;
	const bool getSecure() const;
	const unsigned int getPoll() const;

public slots:
	void invokeHelp();

	void readConfig(const QString& profile);
	void saveConfig();

protected:
	QString getSomeProfile() const;

protected slots:
	void slotDone();
	void slotAddNewProfile();
	void slotRenameProfile();
	void slotDeleteProfile();

private:
	bool isSecure;

	// "outer" dialog
	QComboBox   *comboProfile;

	// tabs
	KBiffGeneralTab *generalTab;
	KBiffNewMailTab *newmailTab;
	KBiffMailboxTab *mailboxTab;
	KBiffAboutTab   *aboutTab;
};

class KBiffGeneralTab : public QWidget
{
	Q_OBJECT
public:
	KBiffGeneralTab(const QString& profile = QString::null, QWidget *parent=0);
	virtual ~KBiffGeneralTab();

	const QString getButtonNewMail() const;
	const QString getButtonOldMail() const;
	const QString getButtonNoMail() const;
	const QString getButtonNoConn() const;
	const QString getMailClient() const;
	const int   getPoll() const;
	const bool  getDock() const;
	const bool  getSessionManagement() const;
	const bool  getCheckStartup() const;

public slots:
	void readConfig(const QString& profile);
	void saveConfig(const QString& profile);

private:
	QLineEdit* editPoll;
	QLineEdit* editCommand;
	QCheckBox* checkDock;
	QCheckBox* checkNoSession;
	QCheckBox* checkNoStartup;

	KIconButton *buttonNoMail;
	KIconButton *buttonOldMail;
	KIconButton *buttonNewMail;
	KIconButton *buttonNoConn;
};

class KBiffNewMailTab : public QWidget
{
	Q_OBJECT
public:
	KBiffNewMailTab(const QString& profile = QString::null, QWidget *parent=0);
	virtual ~KBiffNewMailTab();

	const bool getRunCommand() const;
	const QString getRunCommandPath() const;
	const bool getPlaySound() const;
	const QString getPlaySoundPath() const;
	const bool getSystemBeep() const;
	const bool getNotify() const;
	const bool getStatus() const;

public slots:
	void readConfig(const QString& profile);
	void saveConfig(const QString& profile);

protected slots:
	void enableRunCommand(bool);
	void enablePlaySound(bool);
	void browseRunCommand();
	void browsePlaySound();
	void testPlaySound();

private:
	QLineEdit *editRunCommand;
	QLineEdit *editPlaySound;

	QCheckBox *checkRunCommand;
	QCheckBox *checkPlaySound;
	QCheckBox *checkBeep;
	QCheckBox *checkNotify;
	QCheckBox *checkStatus;

	QPushButton *buttonBrowsePlaySound;
	QPushButton *buttonTestPlaySound;
	QPushButton *buttonBrowseRunCommand;
};

class KBiffMailboxAdvanced : public KDialog
{
	Q_OBJECT
public:
	KBiffMailboxAdvanced();
	virtual ~KBiffMailboxAdvanced();

	const KBiffURL getMailbox() const;
	const unsigned int getPort() const;
	bool getPreauth() const;

	void setPort(unsigned int the_port, bool enable = true);
	void setTimeout(unsigned int the_to, bool enable = true);
	void setMailbox(const KBiffURL& url);
	void setPreauth(bool on);
	void setKeepalive(bool on);
	void setAsync(bool on);

protected slots:
	void portModified(const QString& text);
	void timeoutModified(const QString& text);
	void preauthModified(bool toggled);
	void keepaliveModified(bool toggled);
	void asyncModified(bool toggled);

private:
	QString    password;
	QLineEdit *mailbox;
	QLineEdit *port;
	QLineEdit *timeout;
	QCheckBox *preauth;
	QCheckBox *keepalive;
	QCheckBox *async;
};

class KBiffMailboxTab : public QWidget
{
	Q_OBJECT
public:
	KBiffMailboxTab(const QString& profile = QString::null, QWidget *parent=0);
	virtual ~KBiffMailboxTab();

	void setMailbox(const KBiffURL& url);

	const KBiffURL getMailbox() const;
	const QList<KBiffMailbox> getMailboxList() const;

public slots:
	void readConfig(const QString& profile);
	void saveConfig(const QString& profile);

protected slots:
	void slotDeleteMailbox();
	void slotNewMailbox();
	void slotMailboxSelected(QListViewItem *item);

	void protocolSelected(int protocol);
	void browse();
	void advanced();

	void enableFetchCommand(bool);
	void browseFetchCommand();

protected:
	const KBiffURL defaultMailbox() const;

private:
	QDict<KBiffMailbox> *mailboxHash;
	QListViewItem       *oldItem;

	unsigned int port;
	unsigned int timeout;
	bool         preauth;
	bool         keepalive;
	bool         async;
	QComboBox   *comboProtocol;
	QLineEdit   *editMailbox;
	QLineEdit   *editServer;
	QLineEdit   *editUser;
	QLineEdit   *editPassword;
	QLineEdit   *editFetchCommand;
	QCheckBox   *checkFetchCommand;
	QCheckBox   *checkStorePassword;
	QPushButton *buttonBrowse;
	QListView   *mailboxes;

	QPushButton *buttonBrowseFetchCommand;
};

class KBiffAboutTab : public QWidget
{
	Q_OBJECT
public:
	KBiffAboutTab(QWidget *parent=0);
	virtual ~KBiffAboutTab();

protected slots:
	void mailTo(const QString&);
	void homepage(const QString&);
};

class KBiffNewDlg : public KDialog
{
	Q_OBJECT
public:
	KBiffNewDlg(QWidget* parent = 0, const char * name = 0);

	const QString getName() const
		{ return editName->text(); }

private:
	QLineEdit *editName;
};

#endif // SETUPDLG_H
