/*
 * kbiff.h
 * Copyright (C) 1999 Kurt Granroth <granroth@kde.org>
 *
 * This file contains the declaration of the main KBiff
 * widget.
 *
 * $Id: kbiff.h,v 1.3 2001/05/21 21:54:38 gran Exp $
 */
#ifndef KBIFF_H 
#define KBIFF_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qlist.h>

#include <kbiffmonitor.h>
#include <setupdlg.h>

#include <kbiffurl.h>
#include <kapp.h>

// mediatool.h is needed by kaudio.h
//extern "C" {
//#include <mediatool.h>
//} 
//#include <kaudio.h>

#include <qlabel.h>
#include <qtimer.h>

#include <notify.h>
#include <status.h>

#include <dcopclient.h>
#include <dcopobject.h>

class KBiff : public QLabel, virtual public DCOPObjectProxy
{
    Q_OBJECT
public:
    KBiff(DCOPClient *client, QWidget *parent = 0);
    virtual ~KBiff();

    const bool isDocked() const;

    void processSetup(const KBiffSetup* setup, bool start);
    void readSessionConfig();

    void setMailboxList(const QList<KBiffMailbox>& mailbox_list, unsigned int poll = 60);

    virtual bool process(const QCString& obj, const QCString& function,
                         const QByteArray& data, QCString& replyType,
                         QByteArray &replyData );

public slots:
    void slotPlaySound(const QString&);
    void slotLaunchFetchClient(const QString&);
    void slotLaunchMailClient();

protected:
    void mousePressEvent(QMouseEvent *);
    void enterEvent(QEvent *);
    void leaveEvent(QEvent *);

protected:
    void popupMenu();
    void reset();
    bool isRunning();
    bool isGIF8x(const QString & file);
    void executeCommand(const QString& command);
    void registerMe(DCOPClient *client);

protected slots:
    void saveYourself();
    void invokeHelp();
    void displayPixmap();
    void haveNewMail(const int, const QString &);
    void currentStatus(const int, const QString &, const KBiffMailState);
    void dock();
    void setup();
    void checkMailNow();
    void readMailNow();
    void readPop3MailNow();
    void stop();
    void start();
    void popupStatus();
    void invalidLogin(const QString& mailbox);

private:
    bool findMailbox(const QString& url, QString& proxy);
    int newMailCount(const QString& url);

protected:
    bool myMUTEX;
    QList<KBiffMonitor> monitorList;
    QList<KBiffNotify>  notifyList;
    KBiffStatusList     statusList;
    QStringList         proxyList;

    // Capability
    QTimer  *statusTimer;
    
    // General settings
    QString profile;
    QString mailClient;

    // New mail
    bool    systemBeep;
    bool    runCommand;
    QString runCommandPath;
    bool    playSound;
    QString playSoundPath;
    bool    notify;
    bool    dostatus;

    bool    docked;
    bool    sessions;
    bool    skipcheck;

    bool    isSecure;

    QString noMailIcon;
    QString newMailIcon;
    QString oldMailIcon;
    QString noConnIcon;

    KBiffStatus *status;
    bool         statusChanged;
};

#endif // KBIFF_H 
