/*
 * notify.h
 * Copyright (C) 1999 Kurt Granroth <granroth@kde.org>
 *
 * This file contains the declaration of the KBiffNotify
 * widget.
 *
 * $Id: notify.h,v 1.2 2001/03/24 18:50:21 gran Exp $
 */
#ifndef KBIFFNOTIFY_H 
#define KBIFFNOTIFY_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qdialog.h>
#include <qstring.h>

class QLabel;

class KBiffNotify : public QDialog
{
	Q_OBJECT
public:
	KBiffNotify(const int num_new, const QString& mailbx);
	virtual ~KBiffNotify();

	const QString getMailbox() { return mailbox; }
	const int newMessages() { return messages; }

	void setNew(const int num_new);

signals:
    void signalLaunchMailClient();

protected slots:
	void slotLaunchMailClient();

protected:
	QString mailbox;
	QLabel* msgLabel;
	int     messages;
};

#endif // KBIFFNOTIFY_H
