/* GNet - Networking library
 * Copyright (C) 2000  David Helder
 * Copyright (C) 2000  Andrew Lanoix
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

/*
 *  2003-10-08 Hiroyuki Ikezoe <poincare@ikezoe.net>
 *     Deleted some include files.
 *     Deleted GNet version info.
 *     Remove gnet_init().
 */

#ifndef _GNET_H
#define _GNET_H

#ifdef __CYGWIN__
#  define __USE_W32_SOCKETS
#endif

#include <glib.h>
#ifdef G_OS_WIN32
#  define GNET_WIN32
#endif

#include "inetaddr.h"
#include "tcp.h"
#include "uri.h"
#include "ipv6.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/**
 * GNET_EXPORT:
 *
 * Declares a variable exported.  Used interally.
 *
 **/
#ifdef GNET_WIN32
#  define GNET_EXPORT extern __declspec(dllimport)
#else
#  define GNET_EXPORT extern
#endif

#ifdef __cplusplus
}
#endif				/* __cplusplus */

#endif /* _GNET_H */
