/***************************************************************************
                           gstreamerconfig.h - config dialog for gstreamer parameters
                             -------------------
    begin                : Sat Jul 16 2005
    revision             : $Revision: 1.1 $
    last modified        : $Date: 2005/07/18 18:13:29 $ by $Author: juergenk $
    copyright            : (C) 2005 by Jürgen Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GSTREAMERCONFIG_H
#define GSTREAMERCONFIG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kdialogbase.h>

class QString;
class QStringList;
class KComboBox;
class KLineEdit;

class GStreamerConfig : public KDialogBase
{
	Q_OBJECT
public:
	GStreamerConfig(const QStringList& audioDrivers, const QStringList& videoDrivers);
	~GStreamerConfig();

	QString getAudioDriver() const;
	QString getVideoDriver() const;
	QString getDrive() const;

	void setDrive(const QString& drive);
	void setAudioDriver(const QString& name);
	void setVideoDriver(const QString& name);

private:
	KComboBox* m_audioDriverBox;
	KComboBox* m_videoDriverBox;
	KLineEdit* m_driveEdit;
};

#endif


