/***************************************************************************
                          filterdialog.h  - config dialog for postprocessing filters
                             -------------------
    begin                : Mon Dez 8 2003
    revision             : $Revision: 1.2 $
    last modified        : $Date: 2005/02/02 10:08:27 $ by $Author: juergenk $   
    copyright            : (C) 2003-2005 by Jürgen Kofler
    email                : kaffeine@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILTERDIALOG_H
#define FILTERDIALOG_H

#include <kdialogbase.h>

class KComboBox;
class QVBox;
class QString;
class QStringList;

/**
  *@author Juergen  Kofler
  */

class FilterDialog : public KDialogBase
{
   Q_OBJECT
public: 
  FilterDialog(const QStringList& audiofilters, const QStringList& videofilters, QWidget *parent=0, const char *name=0);
  ~FilterDialog();

signals:
  void signalCreateAudioFilter(const QString& name, QWidget* parent);
  void signalRemoveAllAudioFilters();
  void signalUseAudioFilters(bool);
  void signalCreateVideoFilter(const QString& name, QWidget* parent);
  void signalRemoveAllVideoFilters();
  void signalUseVideoFilters(bool);
  
private slots:
  void slotAddAudioClicked() { emit signalCreateAudioFilter(m_audioFilterCombo->currentText(), (QWidget*)m_audioFilterPage); }
  void slotUseAudioFilters(bool on);
  void slotAddVideoClicked() { emit signalCreateVideoFilter(m_videoFilterCombo->currentText(), (QWidget*)m_videoFilterPage); }
  void slotUseVideoFilters(bool on);

private:
  KComboBox* m_audioFilterCombo;      
  QVBox* m_audioFilterPage;
  KPushButton* m_addAudioButton;
  KPushButton* m_removeAudioButton;  
  
  KComboBox* m_videoFilterCombo;      
  QVBox* m_videoFilterPage;
  KPushButton* m_addVideoButton;
  KPushButton* m_removeVideoButton;
};

#endif
