/***************************************************************************
                          dvbevents.h  -  description
                             -------------------
    begin                : Tue Dec 16 2003
    copyright            : (C) 2003-2005 by Christophe Thommeret
    email                : hftom@free.fr
    last modified        : $Date: 2005/04/27 07:56:48 $ by $Author: hftom $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DVBEVENTS_H
#define DVBEVENTS_H

#include <sys/poll.h>

#include <qtimer.h>
#include <qmutex.h>

#include "dvbsection.h"
#include "channeldesc.h"



class EventTsidList
{
public:
	EventTsidList( unsigned short t );
	~EventTsidList();
	unsigned short tsid;
	QPtrList<EventDesc> events;
};



class EventSourceList
{
public:
	EventSourceList( QString src );
	~EventSourceList();
	QString source;
	QPtrList<EventTsidList> tsidList;
};



class DVBevents : public DVBsection
{
	Q_OBJECT

public:

	DVBevents( bool *ok, int anum, int tnum, const QString &charset );
	~DVBevents();
	bool go( QString src, bool all=false );
	void stop();
	void doClean( bool b );
	void dumpEvents();

	QPtrList<EventSourceList> srcList;
	EventSourceList *currentSrcList;
	QMutex mutex;

protected:

	virtual void run();
	bool tableEIT( unsigned char* buffer );
	bool shortEventDesc( unsigned char *buf, EventDesc *desc );
	bool extEventDesc( unsigned char *buf, EventDesc *desc );
	bool safeLen( unsigned char* buf );

	bool clean;
	QTimer cleanTimer;

private slots:

	void setClean();

private:

	unsigned char secbuf[4096];
	int readSize;
	bool demuxOpened;
	struct pollfd pf[1];
	QString source;

signals:

	void newEvent( EventDesc* );

};

#endif
