/***************************************************************************
                          dvbpanel.h  -  description
                             -------------------
    begin                : Mon Jan 19 2004
    copyright            : (C) 2004-2006 by Christophe Thommeret
    email                : hftom@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DVBPANEL_H
#define DVBPANEL_H

#include <qframe.h>
#include <qcombobox.h>
#include <qtoolbutton.h>
#include <qptrlist.h>
#include <qtimer.h>
#include <qsplitter.h>
#include <qvbox.h>

#include <kapp.h>
#include <kpushbutton.h>
#include <kled.h>
#include <klistview.h>
#include <kiconview.h>

#include "scandialog.h"
#include "dvbconfig.h"
#include "krecord.h"
#include "ts2rtp.h"
#include "cleaner.h"



class ChannelDesc;
class DvbStream;
class DvbPanel;
class KaffeineInput;



class DListView : public KListView
{
	Q_OBJECT
public:
	DListView( QWidget *parent );
protected:
	virtual QDragObject* dragObject();
};



class DIconViewItem : public KIconViewItem
{
public:
	DIconViewItem( DvbPanel *pan, QIconView *parent, const QString &text, const QPixmap &icon );
protected:
	void dropped( QDropEvent *e, const QValueList<QIconDragItem> & );
private:
	DvbPanel *panel;
};



class DvbPanel : public KaffeineInput
{
	Q_OBJECT

public:

	DvbPanel( QWidget *parent, QObject *objParent, const char *name=0);
	~DvbPanel();
	bool getChannelList();
	bool saveChannelList();
	bool timeShiftMode();
	void setConfig();
	void enableLiveDvb( bool on );
	void checkFirstRun();
	void moveChannel( const QString &cat, const QString &name );

	// Reimplemented from KaffeineInput
	QWidget *wantPlayerWindow();
	QWidget *inputMainWidget();
	void toggleLayout( bool );
	bool close();
	bool nextTrack( MRL& );
	bool previousTrack( MRL& );
	bool currentTrack( MRL& );
	bool trackNumber( int, MRL& );
	bool playbackFinished( MRL& );
	void getTargets( QStringList &uiNames, QStringList &iconNames, QStringList &targetNames );
	bool execTarget( const QString& );
	//***************************************

	QPtrList<ChannelDesc> channels;
	QPtrList<RecTimer> timers;
	QPtrList<DvbStream> dvb;
	QString fifoName, fifoName1, currentFifo;
	QString timeShiftFileName;
	Ts2Rtp *rtp;
	QVBox *mainWidget;
	QVBox *playerBox, *pbox;

public slots:

	void playLastChannel();
	void playNumChannel( int num );
	void stopLive();
	void setShiftLed( bool on );
	void setRecordLed( bool on );
	void setBroadcastLed( bool on );
	void setRecord();
	void setBroadcast();
	void pauseLiveTV();
	void killTimer( RecTimer *t );
	void showEvents();
	void showTimers();
	void scanner();
	void showConfigDialog();
	void next();
	void previous();
	void dvbOSD();

	void dvbOSDNext();
	void dvbOSDPrev();
	void dvbOSDSkip(int skip, int timeShift = 0);
	void dvbOSDZap();
	void dvbOSDHide();

	void dvbOSDAdvance();
	void dvbOSDRetreat();

private:

	void setupActions();
	bool getTimerList();
	bool saveTimerList();
	void fillChannelList();
	QPtrList<Transponder> getSourcesStatus();
	void updateModeTimer( RecTimer *t );
	DvbStream* getWorkingDvb( int mode, ChannelDesc *chan );

	void dvbOSD(ChannelDesc liveChannel, DvbStream *d, int timeShift = 0);
	DvbStream* getLiveDVBStream();

	QPixmap tvPix, raPix, tvcPix, racPix;
	QSplitter *split;
	QFrame *panel;
	KIconView *iconView;
	DListView *channelsCb;
	QComboBox *audioComb;
	QToolButton *broadcastBtn, *recordBtn;
	QToolButton *dateBtn, *infoBtn, *channelsBtn, *configBtn, *osdBtn;
	KLed *shiftLed, *recordLed, *broadcastLed;
	QTimer timersTimer;
	DVBconfig *dvbConfig;
	KRecord *timersDialog;
	int updown;
	unsigned long autocount;
	int currentChannelNumber;
	Cleaner *cleaner;
	int osdMode;
	QTimer osdTimer;
	QTimer showOsdTimer;
	QString currentCategory;

	int browseDvbStream;
	int maxChannelNumber, minChannelNumber;
	int browseDvbTimeShift;

private slots:

	void checkTimers();
	void channelSelected( QListViewItem *it );
	void channelSelected( const QString &name );
	void audioSelected( int n );
	void dvbZap( ChannelDesc *chan );
	void finalZap( DvbStream *d, ChannelDesc *chan, bool setAudio, int napid=0 );
	void newTimer( QString channel, QString name, QDateTime begin, QTime duration );
	void dumpEvents();
	void resetOSD();
	void catContextMenu( QIconViewItem*, const QPoint& );
	void catSelected( QIconViewItem* );
	void channelNumberChanged( QListViewItem* );

signals:

	void zap( ChannelDesc* );
	void playDvb();
	void timersChanged();
	void dvbOpen( const QString &filename, const QString &chanName, int haveVideo );
	void dvbStop();
	void dvbPause( bool pauseLive );
	void setTimeShiftFilename( const QString& );
	void showOSD( const QString &text, int duration, int priority );
	void showDvbOSD( const QStringList& );
	void showDvbOSD( const QString&, const QStringList& );
};

#endif
