/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractMapEntrySet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import kaffe.util.NotImplemented;

public class TreeMap
extends AbstractMap
implements SortedMap,
Cloneable,
Serializable {
    private static final int BLACK = 0;
    private static final int RED = 1;
    private static final Node NIL;
    private final Comparator c;
    private Node insertionPoint;
    private int modCount = 0;
    private Node root = NIL;
    private int size = 0;

    public int size() {
        return this.size;
    }

    public boolean containsKey(Object object) {
        return this.find(object) != null;
    }

    public boolean containsValue(Object object) {
        TreeMap treeMap = this;
        if (treeMap == null) {
            throw null;
        }
        NodeIterator nodeIterator = treeMap.new NodeIterator();
        while (nodeIterator.hasNext()) {
            Node node = (Node)nodeIterator.next();
            boolean bl = object == null ? node.value == null : object.equals(node.value);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public Object get(Object object) {
        Node node = this.find(object);
        if (node == null) {
            return null;
        }
        return node.value;
    }

    public Comparator comparator() {
        return this.c == Arrays.DEFAULT_COMPARATOR ? null : this.c;
    }

    public Object firstKey() {
        if (this.root == NIL) {
            throw new NoSuchElementException();
        }
        Node node = this.root;
        while (node.left != NIL) {
            node = node.left;
        }
        return node.key;
    }

    public Object lastKey() {
        if (this.root == NIL) {
            throw new NoSuchElementException();
        }
        Node node = this.root;
        while (node.right != NIL) {
            node = node.right;
        }
        return node.key;
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object put(Object object, Object object2) {
        Object object3;
        Node node = this.find(object);
        if (node == null) {
            this.insertNode(this.insertionPoint, new Node(object, object2));
            object3 = null;
        } else {
            object3 = node.value;
            node.value = object2;
        }
        return object3;
    }

    public Object remove(Object object) {
        Node node = this.find(object);
        if (node == null) {
            return null;
        }
        Object object2 = node.value;
        this.deleteNode(node);
        return object2;
    }

    public void clear() {
        ++this.modCount;
        this.root = NIL;
        this.size = 0;
    }

    public Object clone() {
        TreeMap treeMap;
        try {
            treeMap = (TreeMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            treeMap = null;
        }
        treeMap.keyset = null;
        treeMap.valcol = null;
        treeMap.root = this.root.cloneTree();
        return treeMap;
    }

    public Set entrySet() {
        TreeMap treeMap = this;
        if (treeMap == null) {
            throw null;
        }
        return new AbstractMapEntrySet(treeMap, this){
            private final /* synthetic */ TreeMap this$0;

            public Iterator iterator() {
                TreeMap treeMap = this.this$0;
                if (treeMap == null) {
                    throw null;
                }
                return treeMap.new NodeIterator();
            }

            protected Map.Entry find(Map.Entry entry) {
                Node node = TreeMap.access$0(this.this$0, entry.getKey());
                return entry.equals(node) ? node : null;
            }
            {
                this.this$0 = treeMap;
                this.constructor$0(treeMap, map);
            }

            private final void constructor$0(TreeMap treeMap, Map map) {
            }
        };
    }

    public SortedMap subMap(Object object, Object object2) {
        throw new NotImplemented(this.getClass().getName() + ".subMap()");
    }

    public SortedMap headMap(Object object) {
        throw new NotImplemented(this.getClass().getName() + ".headMap()");
    }

    public SortedMap tailMap(Object object) {
        throw new NotImplemented(this.getClass().getName() + ".tailMap()");
    }

    private Node find(Object object) {
        this.insertionPoint = null;
        Node node = this.root;
        while (node != NIL) {
            if (this.c.compare(object, node.key) == 0) {
                return node;
            }
            this.insertionPoint = node;
            Node node2 = node = this.c.compare(object, node.key) < 0 ? node.left : node.right;
        }
        return null;
    }

    private Node insertNode(Node node, Node node2) {
        ++this.modCount;
        ++this.size;
        node2.parent = node;
        node2.left = NIL;
        node2.right = NIL;
        node2.color = 1;
        if (node != null) {
            if (this.c.compare(node2.key, node.key) < 0) {
                node.left = node2;
            } else {
                node.right = node2;
            }
        } else {
            this.root = node2;
        }
        this.insertFixup(node2);
        return node2;
    }

    private void deleteNode(Node node) {
        Node node2;
        ++this.modCount;
        --this.size;
        if (node.left == NIL || node.right == NIL) {
            node2 = node;
        } else {
            node2 = node.right;
            while (node2.left != NIL) {
                node2 = node2.left;
            }
        }
        Node node3 = node2.left != NIL ? node2.left : node2.right;
        node3.parent = node2.parent;
        if (node2.parent != null) {
            if (node2 == node2.parent.left) {
                node2.parent.left = node3;
            } else {
                node2.parent.right = node3;
            }
        } else {
            this.root = node3;
        }
        if (node2 != node) {
            node.key = node2.key;
            node.value = node2.value;
        }
        if (node2.color == 0) {
            this.deleteFixup(node3);
        }
    }

    private void insertFixup(Node node) {
        while (node != this.root && node.parent.color == 1) {
            Node node2;
            if (node.parent == node.parent.parent.left) {
                node2 = node.parent.parent.right;
                if (node2.color == 1) {
                    node.parent.color = 0;
                    node2.color = 0;
                    node.parent.parent.color = 1;
                    node = node.parent.parent;
                    continue;
                }
                if (node == node.parent.right) {
                    node = node.parent;
                    this.rotateLeft(node);
                }
                node.parent.color = 0;
                node.parent.parent.color = 1;
                this.rotateRight(node.parent.parent);
                continue;
            }
            node2 = node.parent.parent.left;
            if (node2.color == 1) {
                node.parent.color = 0;
                node2.color = 0;
                node.parent.parent.color = 1;
                node = node.parent.parent;
                continue;
            }
            if (node == node.parent.left) {
                node = node.parent;
                this.rotateRight(node);
            }
            node.parent.color = 0;
            node.parent.parent.color = 1;
            this.rotateLeft(node.parent.parent);
        }
        this.root.color = 0;
    }

    private void deleteFixup(Node node) {
        while (node != this.root && node.color == 0) {
            Node node2;
            if (node == node.parent.left) {
                node2 = node.parent.right;
                if (node2.color == 1) {
                    node2.color = 0;
                    node.parent.color = 1;
                    this.rotateLeft(node.parent);
                    node2 = node.parent.right;
                }
                if (node2.left.color == 0 && node2.right.color == 0) {
                    node2.color = 1;
                    node = node.parent;
                    continue;
                }
                if (node2.right.color == 0) {
                    node2.left.color = 0;
                    node2.color = 1;
                    this.rotateRight(node2);
                    node2 = node.parent.right;
                }
                node2.color = node.parent.color;
                node.parent.color = 0;
                node2.right.color = 0;
                this.rotateLeft(node.parent);
                node = this.root;
                continue;
            }
            node2 = node.parent.left;
            if (node2.color == 1) {
                node2.color = 0;
                node.parent.color = 1;
                this.rotateRight(node.parent);
                node2 = node.parent.left;
            }
            if (node2.right.color == 0 && node2.left.color == 0) {
                node2.color = 1;
                node = node.parent;
                continue;
            }
            if (node2.left.color == 0) {
                node2.right.color = 0;
                node2.color = 1;
                this.rotateLeft(node2);
                node2 = node.parent.left;
            }
            node2.color = node.parent.color;
            node.parent.color = 0;
            node2.left.color = 0;
            this.rotateRight(node.parent);
            node = this.root;
        }
        node.color = 0;
    }

    private void rotateLeft(Node node) {
        Node node2 = node.right;
        node.right = node2.left;
        if (node2.left != NIL) {
            node2.left.parent = node;
        }
        if (node2 != NIL) {
            node2.parent = node.parent;
        }
        if (node.parent != null) {
            if (node == node.parent.left) {
                node.parent.left = node2;
            } else {
                node.parent.right = node2;
            }
        } else {
            this.root = node2;
        }
        node2.left = node;
        if (node != NIL) {
            node.parent = node2;
        }
    }

    private void rotateRight(Node node) {
        Node node2 = node.left;
        node.left = node2.right;
        if (node2.right != NIL) {
            node2.right.parent = node;
        }
        if (node2 != NIL) {
            node2.parent = node.parent;
        }
        if (node.parent != null) {
            if (node == node.parent.right) {
                node.parent.right = node2;
            } else {
                node.parent.left = node2;
            }
        } else {
            this.root = node2;
        }
        node2.right = node;
        if (node != NIL) {
            node.parent = node2;
        }
    }

    static /* synthetic */ Node access$4(TreeMap treeMap) {
        return treeMap.root;
    }

    public TreeMap() {
        this.c = Arrays.DEFAULT_COMPARATOR;
    }

    public TreeMap(Comparator comparator) {
        this.c = comparator;
    }

    public TreeMap(Map map) {
        this.c = Arrays.DEFAULT_COMPARATOR;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public TreeMap(SortedMap sortedMap) {
        Comparator comparator = sortedMap.comparator();
        this.c = comparator != null ? comparator : Arrays.DEFAULT_COMPARATOR;
        Iterator iterator = sortedMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    static {
        TreeMap.NIL.left = NIL = new Node(null, null);
        TreeMap.NIL.right = NIL;
        TreeMap.NIL.parent = null;
        TreeMap.NIL.color = 0;
    }

    private static class Node
    implements Cloneable,
    Map.Entry {
        int color;
        Node left;
        Node right;
        Node parent;
        Object key;
        Object value;

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = object;
            this.value = object;
            return object2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            boolean bl;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            if (this.key == null) {
                if (entry.getKey() != null) {
                    return false;
                }
                bl = true;
            } else {
                bl = this.key.equals(entry.getKey());
            }
            if (!bl) return false;
            if (this.value == null) {
                if (entry.getValue() == null) return true;
                return false;
            }
            boolean bl2 = this.value.equals(entry.getValue());
            if (bl2) return true;
            return false;
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        Node cloneTree() {
            Node node;
            try {
                node = (Node)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new Error();
            }
            if (this.left != NIL) {
                node.left = this.left.cloneTree();
                node.left.parent = node;
            }
            if (this.right != NIL) {
                node.right = this.right.cloneTree();
                node.right.parent = node;
            }
            return node;
        }

        Node(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }
    }

    private class NodeIterator
    implements Iterator {
        private Node node = null;
        private Node prev = null;
        private int modCount = TreeMap.access$2(TreeMap.this);

        public boolean hasNext() {
            if (this.modCount != TreeMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.node != null;
        }

        public Object next() {
            if (this.modCount != TreeMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.node == null) {
                throw new NoSuchElementException();
            }
            this.prev = this.node;
            this.nextNode();
            return this.prev;
        }

        public void remove() {
            if (this.modCount != TreeMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.prev == null) {
                throw new IllegalStateException();
            }
            Object object = null;
            if (this.node != null) {
                object = this.node.key;
            }
            TreeMap.this.deleteNode(this.prev);
            ++this.modCount;
            if (this.node != null) {
                this.node = TreeMap.this.find(object);
            }
            this.prev = null;
        }

        /*
         * Unable to fully structure code
         */
        private void nextNode() {
            block5: {
                block4: {
                    if (this.node != null) break block4;
                    if (TreeMap.access$4(TreeMap.this) == TreeMap.access$1()) {
                        return;
                    }
                    this.node = TreeMap.access$4(TreeMap.this);
                    ** GOTO lbl19
                }
                if (this.node.right == TreeMap.access$1()) break block5;
                this.node = this.node.right;
                if (true) ** GOTO lbl19
            }
            while (true) {
                if (this.node.parent == null || this.node == this.node.parent.left) {
                    this.node = this.node.parent;
                    return;
                }
                this.node = this.node.parent;
            }
            do {
                this.node = this.node.left;
lbl19:
                // 3 sources

            } while (this.node.left != TreeMap.access$1());
        }

        NodeIterator() {
            this.nextNode();
        }
    }
}

