/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PushbackInputStream
extends FilterInputStream {
    protected byte[] buf;
    protected int pos;

    public int available() throws IOException {
        return super.available() + (this.buf.length - this.pos);
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        return this.pos < this.buf.length ? this.buf[this.pos++] & 0xFF : super.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (this.pos < this.buf.length && n2 > 0) {
            byArray[n++] = this.buf[this.pos++];
            --n2;
            ++n3;
        }
        if (n2 > 0) {
            int n4 = super.read(byArray, n, n2);
            if (n4 == -1) {
                if (n3 == 0) {
                    n3 = -1;
                }
            } else {
                n3 += n4;
            }
        }
        return n3;
    }

    public void unread(byte[] byArray) throws IOException {
        this.unread(byArray, 0, byArray.length);
    }

    public void unread(byte[] byArray, int n, int n2) throws IOException {
        if (this.pos < n2) {
            throw new IOException("pushback buffer is full");
        }
        this.pos -= n2;
        System.arraycopy(byArray, n, this.buf, this.pos, n2);
    }

    public void unread(int n) throws IOException {
        if (this.pos == 0) {
            throw new IOException("pushback buffer is full");
        }
        --this.pos;
        this.buf[this.pos] = (byte)n;
    }

    public PushbackInputStream(InputStream inputStream) {
        this(inputStream, 1);
    }

    public PushbackInputStream(InputStream inputStream, int n) {
        super(inputStream);
        this.buf = new byte[n];
        this.pos = this.buf.length;
    }
}

