/*
 * Decompiled with CFR 0.152.
 */
package kaffe.net.www.protocol.jar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JarURLConnection
extends java.net.JarURLConnection {
    private URL jarFileURL;
    private File underlyingFile;
    private JarFile jarFile;
    private String jarEntryName;
    private ZipEntry jarEntry;

    public JarFile getJarFile() throws IOException {
        this.connect();
        return this.jarFile;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if (this.jarFileURL.getProtocol().equals("file")) {
            this.underlyingFile = new File(this.jarFileURL.getFile());
        } else {
            int n;
            this.jarFileURLConnection = this.jarFileURL.openConnection();
            this.jarFileURLConnection.connect();
            InputStream inputStream = this.jarFileURLConnection.getInputStream();
            this.underlyingFile = File.createTempFile("jar", null);
            this.underlyingFile.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(this.underlyingFile);
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) != -1) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            inputStream.close();
            ((OutputStream)fileOutputStream).close();
        }
        this.jarFile = new JarFile(this.underlyingFile);
        if (this.jarEntryName.equals("")) {
            this.jarEntry = null;
        } else {
            this.jarEntry = this.jarFile.getEntry(this.jarEntryName);
            if (this.jarEntry == null) {
                throw new IOException("JAR entry \"" + this.jarEntryName + "\" not found");
            }
        }
        this.connected = true;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            throw new IOException("not connected");
        }
        return this.jarEntry == null ? new FileInputStream(this.underlyingFile) : this.jarFile.getInputStream(this.jarEntry);
    }

    public JarURLConnection(URL uRL) throws MalformedURLException {
        super(uRL);
        String string = uRL.getFile();
        int n = string.lastIndexOf("!/");
        if (n == -1) {
            throw new MalformedURLException("missing !/");
        }
        this.jarFileURL = new URL(string.substring(0, n));
        this.jarEntryName = string.substring(n + 2);
    }
}

