/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;

public class Manifest
implements Cloneable {
    private static final Attributes.Name NAME = new Attributes.Name("Name");
    private static final String MANIFEST_ENCODING = "8859_1";
    private Attributes main;
    private HashMap ents;

    public Attributes getMainAttributes() {
        return this.main;
    }

    public Map getEntries() {
        return this.ents;
    }

    public Attributes getAttributes(String string) {
        return (Attributes)this.getEntries().get(string);
    }

    public void clear() {
        this.main.clear();
        this.ents.clear();
    }

    public void write(OutputStream outputStream) throws IOException {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, MANIFEST_ENCODING)));
        String string = this.main.getValue(Attributes.Name.MANIFEST_VERSION);
        if (string == null) {
            string = "1.0";
        }
        printWriter.println(Attributes.Name.MANIFEST_VERSION + ": " + string);
        this.writeAttributes(printWriter, this.main, Attributes.Name.MANIFEST_VERSION);
        printWriter.println();
        Iterator iterator = this.ents.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String string2 = (String)entry.getKey();
            Attributes attributes = (Attributes)entry.getValue();
            printWriter.println("Name: " + attributes.getValue(NAME));
            this.writeAttributes(printWriter, attributes, NAME);
            printWriter.println();
        }
        printWriter.flush();
    }

    private void writeAttributes(PrintWriter printWriter, Attributes attributes, Attributes.Name name) {
        Iterator iterator = attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Attributes.Name name2 = (Attributes.Name)entry.getKey();
            String string = (String)entry.getValue();
            if (name2.equals(name)) continue;
            printWriter.println(name2 + ": " + string);
        }
    }

    public void read(InputStream inputStream) throws IOException {
        this.read(inputStream, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void read(InputStream inputStream, boolean bl) throws IOException {
        boolean bl2 = false;
        boolean bl3 = true;
        int n = 2;
        int n2 = 3;
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        PushbackReader pushbackReader = new PushbackReader(new BufferedReader(new InputStreamReader(inputStream, MANIFEST_ENCODING)));
        try {
            while (true) {
                Attributes attributes = new Attributes();
                StringBuffer stringBuffer = null;
                StringBuffer stringBuffer2 = null;
                block9: while (true) {
                    int n6;
                    if ((n6 = pushbackReader.read()) == -1) {
                        throw new EOFException();
                    }
                    if (n6 == 13) {
                        n6 = pushbackReader.read();
                        if (n6 != -1 && n6 != 10) {
                            pushbackReader.unread(n6);
                        }
                        n6 = 10;
                        ++n5;
                    }
                    switch (n3) {
                        case 0: {
                            if (n6 == 10) {
                                if (attributes.size() != 0) break block9;
                                break;
                            }
                            if (!(n6 >= 48 && n6 <= 57 || n6 >= 65 && n6 <= 90 || n6 >= 97 && n6 <= 122)) {
                                throw new IOException("invalid manifest, line " + n5);
                            }
                            stringBuffer = new StringBuffer();
                            stringBuffer.append((char)n6);
                            n3 = 1;
                            break;
                        }
                        case 1: {
                            if (n6 == 58) {
                                n6 = pushbackReader.read();
                                if (n6 != 32) {
                                    throw new IOException("invalid manifest, line " + n5);
                                }
                                stringBuffer2 = new StringBuffer();
                                n3 = 2;
                                break;
                            }
                            if (!(n6 >= 48 && n6 <= 57 || n6 >= 65 && n6 <= 90 || n6 >= 97 && n6 <= 122 || n6 == 95 || n6 == 45)) {
                                throw new IOException("invalid manifest, line " + n5);
                            }
                            stringBuffer.append((char)n6);
                            break;
                        }
                        case 2: {
                            if (n6 == 10) {
                                n3 = 3;
                                break;
                            }
                            stringBuffer2.append((char)n6);
                            break;
                        }
                        case 3: {
                            if (n6 == 32 || n6 == 9) {
                                n3 = 2;
                                break;
                            }
                            attributes.putValue(stringBuffer.toString(), stringBuffer2.toString());
                            pushbackReader.unread(n6);
                            n3 = 0;
                        }
                    }
                }
                if (n4++ == 0) {
                    if (bl) {
                        this.main.putAll(attributes);
                        continue;
                    }
                    this.main = attributes;
                    continue;
                }
                String string = attributes.getValue(NAME);
                if (string == null) {
                    throw new IOException("invalid manifest, line " + n5 + ": missing ``Name'' header");
                }
                Attributes attributes2 = (Attributes)this.ents.get(string);
                if (attributes2 == null) {
                    this.ents.put(string, attributes);
                    continue;
                }
                if (!bl) continue;
                attributes2.putAll(attributes);
            }
        }
        catch (EOFException eOFException) {
            if (n4 != 0 && n3 == 0) {
                return;
            }
            throw new IOException("premature EOF, line " + n5);
        }
    }

    public boolean equals(Object object) {
        return object instanceof Manifest && this.main.equals(((Manifest)object).main) && this.ents.equals(((Manifest)object).ents);
    }

    public int hashCode() {
        return this.main.hashCode() ^ this.ents.hashCode();
    }

    public Object clone() {
        return new Manifest(this);
    }

    public Manifest() {
        this.main = new Attributes();
        this.ents = new HashMap();
    }

    public Manifest(InputStream inputStream) throws IOException {
        this.main = new Attributes();
        this.ents = new HashMap();
        this.read(inputStream, false);
    }

    public Manifest(Manifest manifest) {
        this.main = (Attributes)manifest.main.clone();
        this.ents = (HashMap)manifest.ents.clone();
    }
}

