/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class Provider
extends Properties {
    private final String name;
    private final double version;
    private final String info;

    public String getName() {
        return this.name;
    }

    public double getVersion() {
        return this.version;
    }

    public String getInfo() {
        return this.info;
    }

    public String toString() {
        return this.name + " version " + this.version;
    }

    public void clear() {
        System.getSecurityManager().checkSecurityAccess("clearProviderProperties." + this.name);
        super.clear();
    }

    public void load(InputStream inputStream) throws IOException {
        super.load(inputStream);
    }

    public void putAll(Map map) {
        super.putAll(map);
    }

    public Set entrySet() {
        return Collections.unmodifiableSet(super.entrySet());
    }

    public Set keySet() {
        return Collections.unmodifiableSet(super.keySet());
    }

    public Collection values() {
        return Collections.unmodifiableCollection(super.values());
    }

    public Object put(Object object, Object object2) {
        System.getSecurityManager().checkSecurityAccess("putProviderProperty." + this.name);
        return super.put(object, object2);
    }

    public Object remove(Object object) {
        System.getSecurityManager().checkSecurityAccess("removeProviderProperty." + this.name);
        return super.remove(object);
    }

    protected Provider(String string, double d, String string2) {
        this.name = string;
        this.version = d;
        this.info = string2;
    }
}

