/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class PushbackReader
extends FilterReader {
    private char[] buf;
    private int pos;

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.pos < this.buf.length) {
                char c = this.buf[this.pos++];
                Object var2_4 = null;
                return c;
            }
            int n = super.read();
            Object var2_5 = null;
            return n;
        }
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n3 = 0;
            while (this.pos < this.buf.length && n2 > 0) {
                cArray[n++] = this.buf[this.pos++];
                --n2;
                ++n3;
            }
            if (n2 > 0) {
                int n4 = super.read(cArray, n, n2);
                if (n4 == -1) {
                    if (n3 == 0) {
                        n3 = -1;
                    }
                } else {
                    n3 += n4;
                }
            }
            int n5 = n3;
            Object var5_8 = null;
            return n5;
        }
    }

    public void unread(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.pos == 0) {
                throw new IOException("pushback buffer is full");
            }
            --this.pos;
            this.buf[this.pos] = (char)n;
        }
    }

    public void unread(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.pos < n2) {
                throw new IOException("pushback buffer is too full");
            }
            this.pos -= n2;
            System.arraycopy(cArray, n, this.buf, this.pos, n2);
        }
    }

    public void unread(char[] cArray) throws IOException {
        this.unread(cArray, 0, cArray.length);
    }

    public boolean ready() throws IOException {
        return this.pos < this.buf.length ? true : super.ready();
    }

    public boolean markSupported() {
        return false;
    }

    public void close() throws IOException {
        super.close();
    }

    public PushbackReader(Reader reader, int n) {
        super(reader);
        this.buf = new char[n];
        this.pos = this.buf.length;
    }

    public PushbackReader(Reader reader) {
        this(reader, 1);
    }
}

