/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

public class File
implements Serializable,
Comparable {
    private static final long serialVersionUID = 301077366599181567L;
    public static final String separator = System.getProperty("file.separator");
    public static final char separatorChar = separator.charAt(0);
    public static final String pathSeparator = System.getProperty("path.separator");
    public static final char pathSeparatorChar = pathSeparator.charAt(0);
    private static final Random random = new Random();
    private String path;

    public boolean canRead() {
        this.checkReadAccess();
        return this.exists() && this.canRead0();
    }

    private native boolean canRead0();

    public boolean canWrite() {
        this.checkWriteAccess();
        return this.canWrite0();
    }

    private native boolean canWrite0();

    private void checkReadAccess() {
        System.getSecurityManager().checkRead(this.getPath());
    }

    private void checkWriteAccess() {
        System.getSecurityManager().checkWrite(this.getPath());
    }

    public static File createTempFile(String string, String string2) throws IOException {
        return File.createTempFile(string, string2, null);
    }

    public static File createTempFile(String string, String string2, File file) throws IOException {
        File file2;
        if (string.length() < 3) {
            throw new IllegalArgumentException(string);
        }
        if (string2 == null) {
            string2 = ".tmp";
        }
        if (file == null) {
            file = new File(System.getProperties().getProperty("java.io.tmpdir"));
        }
        while ((file2 = new File(file, string + Integer.toHexString(random.nextInt(0x100000)).toUpperCase() + string2)).exists()) {
        }
        return file2;
    }

    public boolean delete() {
        System.getSecurityManager().checkDelete(this.getPath());
        return this.isDirectory0() ? this.rmdir0() : this.delete0();
    }

    private native boolean delete0();

    private native boolean rmdir0();

    public void deleteOnExit() {
    }

    public int compareTo(Object object) {
        return this.compareTo((File)object);
    }

    public int compareTo(File file) {
        return this.path.compareTo(file.path);
    }

    public boolean equals(Object object) {
        return object instanceof File ? this.path.equals(((File)object).path) : false;
    }

    public boolean exists() {
        this.checkReadAccess();
        return this.exists0();
    }

    private native boolean exists0();

    public String getAbsolutePath() {
        if (this.isAbsolute()) {
            return this.getPath();
        }
        return System.getProperty("user.dir") + separatorChar + this.getPath();
    }

    public String getCanonicalPath() throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(this.getAbsolutePath(), separator);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n + 2];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            String string = stringTokenizer.nextToken();
            if (string.equals("..")) {
                --n2;
            } else {
                stringArray[n2] = string;
                ++n2;
            }
            ++n3;
        }
        if (n2 == 0) {
            return separator;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = 0;
        while (n4 < n2) {
            stringBuffer.append(separatorChar);
            stringBuffer.append(stringArray[n4]);
            ++n4;
        }
        return stringBuffer.toString();
    }

    public String getName() {
        return this.path.substring(this.path.lastIndexOf(separatorChar) + 1);
    }

    public String getParent() {
        int n = this.path.lastIndexOf(separatorChar);
        if (n > 0) {
            return this.path.substring(0, n);
        }
        if (n == 0 && this.path.length() > 1) {
            return separator;
        }
        return null;
    }

    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public native boolean isAbsolute();

    public boolean isDirectory() {
        this.checkReadAccess();
        return this.isDirectory0();
    }

    private native boolean isDirectory0();

    public boolean isFile() {
        this.checkReadAccess();
        return this.isFile0();
    }

    private native boolean isFile0();

    public long lastModified() {
        this.checkReadAccess();
        return this.lastModified0();
    }

    private native long lastModified0();

    public long length() {
        this.checkReadAccess();
        return this.length0();
    }

    private native long length0();

    public String[] list() {
        this.checkReadAccess();
        return this.list0();
    }

    public String[] list(FilenameFilter filenameFilter) {
        String[] stringArray = this.list();
        if (stringArray == null || filenameFilter == null) {
            return stringArray;
        }
        Vector vector = new Vector();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            if (filenameFilter.accept(this, string)) {
                vector.addElement(string);
            }
            ++n;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public File[] listFiles() {
        return this.listFiles((FilenameFilter)null);
    }

    public File[] listFiles(FileFilter fileFilter) {
        File file = this;
        if (file == null) {
            throw null;
        }
        return this.listFiles(new FilenameFilter(file, fileFilter){
            private final /* synthetic */ File this$0;
            private final /* synthetic */ FileFilter val$filter;

            public boolean accept(File file, String string) {
                return this.val$filter.accept(new File(file, string));
            }
            {
                this.val$filter = fileFilter;
                this.this$0 = file;
                this.constructor$0(file);
            }

            private final void constructor$0(File file) {
            }
        });
    }

    public File[] listFiles(FilenameFilter filenameFilter) {
        String[] stringArray = this.list(filenameFilter);
        if (stringArray == null) {
            return null;
        }
        File[] fileArray = new File[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            fileArray[n] = new File(this, stringArray[n]);
            ++n;
        }
        return fileArray;
    }

    private native String[] list0();

    public boolean mkdir() {
        this.checkWriteAccess();
        if (this.isDirectory()) {
            return true;
        }
        return this.mkdir0();
    }

    private native boolean mkdir0();

    public boolean mkdirs() {
        File file;
        String string;
        if (!this.toString().equals(separator) && (string = this.getParent()) != null && !(file = new File(string)).mkdirs()) {
            return false;
        }
        return this.mkdir();
    }

    public boolean renameTo(File file) {
        System.getSecurityManager().checkWrite(this.getPath());
        System.getSecurityManager().checkWrite(file.getPath());
        return this.renameTo0(file);
    }

    private native boolean renameTo0(File var1);

    public String toString() {
        return this.path;
    }

    public File(File file, String string) {
        this(file == null ? null : file.getPath(), string);
    }

    public File(String string, String string2) {
        char c;
        if (string2 == null) {
            throw new NullPointerException();
        }
        this.path = string == null ? string2 : (string.length() == 0 ? separatorChar + string2 : ((c = string.charAt(string.length() - 1)) != separatorChar ? string + separatorChar + string2 : string + string2));
    }

    public File(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.path = string;
    }

    static {
        System.loadLibrary("io");
    }
}

